<#--noinspection HtmlUnknownTarget,FtlReferencesInspection-->
<#assign CACHE_VERSION = "v=1715084377.10">
<#assign base = springMacroRequestContext.getContextUrl("")>

<#assign baseLib="${base}/desform/lib">
<#assign baseJmForm="${baseLib}/jm-form">
<#assign baseElementUI="${baseLib}/element-ui">
<!DOCTYPE html>
<html lang="zh-Hans">

<head>
  <title></title>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=Edge，chrome=1">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <#-- 加载样式 -->
  <link rel="stylesheet" href="${baseElementUI}/elementUI.css?${CACHE_VERSION}">
  <link rel="stylesheet" href="${baseJmForm}/JmForm.css?${CACHE_VERSION}">

  <style>
		html,
    body,
    #app {
      height: 100%;
      font-size: 14px;
      color: #3a3a3a;
    }

	</style>
</head>

<body>
<div id="app">
  <data-linkage-dialog
          :visible="visible"
          :ok-callback="okCallback"
          v-bind="compProps"
          @update:visible="onUpdateVisible"
  >
  </data-linkage-dialog>
</div>
</body>

<script src="${base}/desform/lib/unpkg/polyfill/7.2.5/polyfill.js"></script>

<script src="${base}/desform/lib/unpkg/vue@2.7.13/vue.js?${CACHE_VERSION}"></script>
<script src="${base}/desform/lib/unpkg/jquery@3.4.1/jquery.js?${CACHE_VERSION}"></script>
<#--<script src="${base}/desform/lib/mathjs/MathJs.umd.js"></script>-->
<script src="${base}/desform/lib/unpkg/moment/moment@2.29.4.js"></script>
<script src="${base}/desform/lib/unpkg/moment/zh-cn@2.29.4.js"></script>

<script src="${baseElementUI}/ElementUI.umd.js?${CACHE_VERSION}"></script>
<script src="${base}/desform/lib/unpkg/vue-ls@3.2.1/vue-ls.min.js?${CACHE_VERSION}"></script>
<!-- 引入组件库 -->
<script src="${baseJmForm}/JmForm.umd.js?${CACHE_VERSION}"></script>
<script src="${base}/desform/utils.js?${CACHE_VERSION}"></script>

<script>

	const store = JmForm.default.store;
  const DeviceMixins = JmForm.default.mixins.DeviceMixins;
  const constant = JmForm.default.constant;
  const _utils = JmForm.default.utils;
  const _widgetUtils = JmForm.default.widgetUtils;

  // 从配置里读取主题颜色
  window['THEME_COLOR'] = '${themeColor}';
  // 从配置里读取上传方式
  window['UPLOAD_TYPE'] = '${uploadType}';
  // 从配置里读取签名秘钥 e3e3NcxzbUiGa53YYVXxWc8ADo5ISgQGx/gaZwERF91oAryDlivjqBv3wqRArgChupi+Y/Gg/swwGEyL0PuVFg==
  window['SIGNATURE_SECRET'] = '${signatureSecret}';

  const token = getQueryParams('token');
  const messageId = getQueryParams('messageId');
  const tenantId = getQueryParams('tenantId');
  const lowAppId = getQueryParams('lowAppId');

  Vue.ls.set(constant.BASE_URL, '${baseURL}');
  Vue.ls.set(constant.ACCESS_TOKEN, token);
  Vue.ls.set(constant.TENANT_ID, tenantId);
  Vue.ls.set(constant.LOW_APP_ID, lowAppId);

  let app = null;

  window.addEventListener('message', function (event) {
    const { type, data } = event.data;
    if (messageId !== event.data.messageId) {
      return;
    }
    switch (type) {
      case 'setup':
        setup(data);
        break;
      case 'update:visible':
        app.visible = data;
        break;
    }
  }, false);

  const designJson = ${designJson};

  function setup(data) {
    const { widget, widgets } = findWidgetListByKeys(data);
    if (widget) {
      if (data.advancedSetting) {
        widget.advancedSetting = data.advancedSetting;
      }
      data.props.widget = widget;
    }
    if (widgets.length > 0) {
      data.props.widgets = widgets;
    }
    data.props.designJson = designJson;

    if (!app) {
      app = createVue(data);
    } else {
      app.setup(data);
    }
    setLoading(false);
  }

  function findWidgetListByKeys(data) {
    const { widgetKey, widgetKeys, needSystemFields } = data;
    let widget = null;
    let widgets = [];

    _utils.recursiveAllWidget(designJson.list, (w) => {
      if (w.key === widgetKey) {
        widget = w;
      }
      if (widgetKeys && widgetKeys.includes(w.key)) {
        widgets.push(w);
      }
    });

    if (needSystemFields) {
      widgets.push({ type: 'divider', label: '系统字段', isDivider: true });
      widgets = widgets.concat(_widgetUtils.systemFieldOptions);
    }

    return {
      widget, widgets,
    };
  }

  function createVue(data) {
    return new Vue({
      el: '#app',
      store: store,
      mixins: [DeviceMixins],
      data() {
        return {
          visible: false,
          compProps: {},
        };
      },
      created: function () {
        this.setup(data);
        postEvent('created', null, messageId);
      },
      mounted: function () {
        postEvent('mounted', null, messageId);
      },
      methods: {
        setup(data) {
          this.visible = data.props.visible ?? false;
          delete data.props.visible;
          this.compProps = data.props;
        },

        // 点击确定后的回调
        okCallback({ desformCode, rules }) {
          postEvent('ok', { desformCode, rules }, messageId);
        },
        onUpdateVisible(v) {
          this.visible = v;
          postEvent('update:visible', v, messageId);
        },
      },
    });
  }

  function setLoading(flag) {
    postEvent('update:loading', flag, messageId);
  }

  postEvent('update:visible', false, messageId);

</script>

</html>