/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.vo.query;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import org.jeecg.common.constant.enums.DateRangeEnum;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.util.DateRangeUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.vo.query.LinkageVal;

public class SuperQueryItem {
    private String type;
    private String field;
    private String val;
    private LinkageVal linkageVal;
    private String beginVal;
    private String endVal;
    private QueryRuleEnum rule;
    private Boolean isSystemField;
    private JSONObject originalJson;

    public SuperQueryItem(JSONObject originalJson) {
        Object object;
        Object object2;
        this.rule = QueryRuleEnum.getByValue((String)originalJson.getString("rule"));
        this.type = originalJson.getString("type");
        this.field = originalJson.getString("field");
        if (this.rule == QueryRuleEnum.LINKAGE) {
            this.val = "";
            this.linkageVal = LinkageVal.of(this.field, originalJson.getJSONObject("val"));
        } else {
            object2 = originalJson.get((Object)"val");
            if (object2 == null) {
                this.val = "";
            } else if (object2 instanceof ArrayList) {
                object = (ArrayList)object2;
                this.val = String.join((CharSequence)",", (Iterable<? extends CharSequence>)object);
            } else {
                this.val = object2.toString();
            }
        }
        object2 = originalJson.get((Object)"beginVal");
        this.beginVal = object2 == null ? "" : object2.toString();
        object = originalJson.get((Object)"endVal");
        this.endVal = object == null ? "" : object.toString();
        this.originalJson = originalJson;
        this.handleDateFormat();
    }

    public SuperQueryItem(String type, String field, String val, QueryRuleEnum rule) {
        this.type = type;
        this.field = field;
        this.val = val;
        this.rule = rule;
        this.originalJson = new JSONObject();
        this.originalJson.put("type", (Object)type);
        this.originalJson.put("field", (Object)field);
        this.originalJson.put("val", (Object)val);
        this.originalJson.put("rule", (Object)rule.getValue());
        this.handleDateFormat();
    }

    public String getFormatStr() {
        return this.originalJson.getString("formatStr");
    }

    private void handleDateFormat() {
        if ("date".equalsIgnoreCase(this.type)) {
            this.addFormatStr("yyyy-MM-dd");
            this.handleDateRange();
        } else if ("datetime".equalsIgnoreCase(this.type)) {
            this.addFormatStr("yyyy-MM-dd HH:mm:ss");
            this.handleDateRange();
        }
    }

    private void handleDateRange() {
        DateRangeEnum dateRangeEnum;
        if (oConvertUtils.isEmpty((Object)this.val)) {
            return;
        }
        try {
            dateRangeEnum = DateRangeEnum.valueOf((String)this.val);
        }
        catch (Exception exception) {
            return;
        }
        Date[] dateArray = DateRangeUtils.getDateRangeByEnum((DateRangeEnum)dateRangeEnum);
        if (dateArray == null) {
            return;
        }
        this.rule = QueryRuleEnum.EQ.equals((Object)this.rule) ? QueryRuleEnum.RANGE : QueryRuleEnum.NOT_RANGE;
        this.val = dateArray[0].getTime() + "," + dateArray[1].getTime();
    }

    public void addFormatStr(String format) {
        this.originalJson.put("formatStr", (Object)format);
    }

    public void setCustomSetTimestamp() {
        if (this.originalJson == null) {
            this.originalJson = new JSONObject();
        }
        this.originalJson.put("timestamp", (Object)true);
    }

    public String getType() {
        return this.type;
    }

    public String getField() {
        return this.field;
    }

    public String getVal() {
        return this.val;
    }

    public LinkageVal getLinkageVal() {
        return this.linkageVal;
    }

    public String getBeginVal() {
        return this.beginVal;
    }

    public String getEndVal() {
        return this.endVal;
    }

    public QueryRuleEnum getRule() {
        return this.rule;
    }

    public Boolean getIsSystemField() {
        return this.isSystemField;
    }

    public JSONObject getOriginalJson() {
        return this.originalJson;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setVal(String val) {
        this.val = val;
    }

    public void setLinkageVal(LinkageVal linkageVal) {
        this.linkageVal = linkageVal;
    }

    public void setBeginVal(String beginVal) {
        this.beginVal = beginVal;
    }

    public void setEndVal(String endVal) {
        this.endVal = endVal;
    }

    public void setRule(QueryRuleEnum rule) {
        this.rule = rule;
    }

    public void setIsSystemField(Boolean isSystemField) {
        this.isSystemField = isSystemField;
    }

    public void setOriginalJson(JSONObject originalJson) {
        this.originalJson = originalJson;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof SuperQueryItem)) {
            return false;
        }
        SuperQueryItem superQueryItem = (SuperQueryItem)o2;
        if (!superQueryItem.canEqual(this)) {
            return false;
        }
        Boolean bl = this.getIsSystemField();
        Boolean bl2 = superQueryItem.getIsSystemField();
        if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
            return false;
        }
        String string = this.getType();
        String string2 = superQueryItem.getType();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getField();
        String string4 = superQueryItem.getField();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getVal();
        String string6 = superQueryItem.getVal();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        LinkageVal linkageVal = this.getLinkageVal();
        LinkageVal linkageVal2 = superQueryItem.getLinkageVal();
        if (linkageVal == null ? linkageVal2 != null : !((Object)linkageVal).equals(linkageVal2)) {
            return false;
        }
        String string7 = this.getBeginVal();
        String string8 = superQueryItem.getBeginVal();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        String string9 = this.getEndVal();
        String string10 = superQueryItem.getEndVal();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        QueryRuleEnum queryRuleEnum = this.getRule();
        QueryRuleEnum queryRuleEnum2 = superQueryItem.getRule();
        if (queryRuleEnum == null ? queryRuleEnum2 != null : !queryRuleEnum.equals(queryRuleEnum2)) {
            return false;
        }
        JSONObject jSONObject = this.getOriginalJson();
        JSONObject jSONObject2 = superQueryItem.getOriginalJson();
        return !(jSONObject == null ? jSONObject2 != null : !jSONObject.equals(jSONObject2));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SuperQueryItem;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        Boolean bl = this.getIsSystemField();
        n3 = n3 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
        String string = this.getType();
        n3 = n3 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getField();
        n3 = n3 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getVal();
        n3 = n3 * 59 + (string3 == null ? 43 : string3.hashCode());
        LinkageVal linkageVal = this.getLinkageVal();
        n3 = n3 * 59 + (linkageVal == null ? 43 : ((Object)linkageVal).hashCode());
        String string4 = this.getBeginVal();
        n3 = n3 * 59 + (string4 == null ? 43 : string4.hashCode());
        String string5 = this.getEndVal();
        n3 = n3 * 59 + (string5 == null ? 43 : string5.hashCode());
        QueryRuleEnum queryRuleEnum = this.getRule();
        n3 = n3 * 59 + (queryRuleEnum == null ? 43 : queryRuleEnum.hashCode());
        JSONObject jSONObject = this.getOriginalJson();
        n3 = n3 * 59 + (jSONObject == null ? 43 : jSONObject.hashCode());
        return n3;
    }

    public String toString() {
        return "SuperQueryItem(type=" + this.getType() + ", field=" + this.getField() + ", val=" + this.getVal() + ", linkageVal=" + this.getLinkageVal() + ", beginVal=" + this.getBeginVal() + ", endVal=" + this.getEndVal() + ", rule=" + this.getRule() + ", isSystemField=" + this.getIsSystemField() + ", originalJson=" + this.getOriginalJson() + ")";
    }
}

