/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jeecg.common.api.dto.DragRelIdsDTO;
import org.jeecg.common.desform.api.IDesformBaseApi;
import org.jeecg.common.desform.vo.DesignFormDataVo;
import org.jeecg.common.drag.api.IDragBaseApi;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.lowapp.model.LowAppCopyMenu;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.entity.DesignForm;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.mongo.model.ButtonInfo;
import org.jeecg.modules.online.desform.mongo.model.DesignFormListChartConfig;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormListChartConfigService;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormListViewButtonService;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormListViewService;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.jeecg.modules.online.desform.service.IDesignFormService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="desformBaseApiImpl")
public class a
implements IDesformBaseApi {
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    IDesignFormService designFormService;
    @Autowired
    IDesignFormDataService dataService;
    @Lazy
    @Autowired
    IDesignFormListViewService designFormListViewService;
    @Lazy
    @Autowired
    IDragBaseApi dragBaseApi;
    @Autowired
    IDesignFormListViewButtonService designFormListViewButtonService;
    @Autowired
    IDesignFormListChartConfigService designFormListChartConfigService;

    public DesignFormDataVo getDataById(String desformCode, String id) {
        DesignFormData designFormData = this.dataService.getById(desformCode, id);
        DesignFormDataVo designFormDataVo = new DesignFormDataVo();
        if (designFormData != null) {
            BeanUtils.copyProperties((Object)designFormData, (Object)designFormDataVo);
        }
        return designFormDataVo;
    }

    public DesignFormDataVo getTranslateDataById(String desformCode, String id) {
        DesignFormData designFormData = this.dataService.getById(desformCode, id);
        ArrayList<DesignFormData> arrayList = new ArrayList<DesignFormData>();
        DesignForm designForm = this.designFormService.getByCode(desformCode);
        arrayList.add(designFormData);
        this.dataService.translateListData(designForm, arrayList);
        this.dataService.queryLinkFieldData(designForm, arrayList, true);
        DesignFormDataVo designFormDataVo = new DesignFormDataVo();
        if (designFormData != null) {
            BeanUtils.copyProperties(arrayList.get(0), (Object)designFormDataVo);
        }
        return designFormDataVo;
    }

    public List<DesignFormDataVo> getDataByIds(String desformCode, String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        List<DesignFormData> list2 = this.dataService.getByIds(desformCode, list);
        ArrayList<DesignFormDataVo> arrayList = new ArrayList<DesignFormDataVo>(list2.size());
        for (DesignFormData designFormData : list2) {
            DesignFormDataVo designFormDataVo = new DesignFormDataVo();
            BeanUtils.copyProperties((Object)designFormData, (Object)designFormDataVo);
            arrayList.add(designFormDataVo);
        }
        return arrayList;
    }

    public boolean updateDataById(String desformCode, String id, JSONObject jsonData) {
        DesignFormData designFormData = new DesignFormData(desformCode, jsonData);
        designFormData.setId(id);
        designFormData.setDesformCode(desformCode);
        return this.dataService.updateById(designFormData);
    }

    public boolean deleteDataById(String desformCode, String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        return this.dataService.removeBatchByIds(desformCode, list);
    }

    public JSONObject translateListDataByJsonArray(String desformCode, JSONArray dataList) {
        return this.translateListDataByJsonArray(desformCode, null, dataList);
    }

    public JSONObject translateListDataByJsonArray(String desformCode, String onlyFields, JSONArray dataList) {
        JSONObject jSONObject;
        Object object;
        DesignForm designForm = this.designFormService.getByCode(desformCode);
        if (designForm == null) {
            throw new JeecgBootException(desformCode + " \u4e0d\u5b58\u5728");
        }
        ArrayList<DesignFormData> arrayList = new ArrayList<DesignFormData>();
        for (int i2 = 0; i2 < dataList.size(); ++i2) {
            object = dataList.getJSONObject(i2);
            DesignFormData designFormData = new DesignFormData(desformCode, (JSONObject)object);
            arrayList.add(designFormData);
        }
        if (oConvertUtils.isNotEmpty((Object)onlyFields)) {
            object = new HashSet<String>(Arrays.asList(onlyFields.split(",")));
            jSONObject = this.dataService.translateListData(designForm, arrayList, (Set<String>)object);
        } else {
            jSONObject = this.dataService.translateListData(designForm, arrayList);
        }
        this.dataService.queryLinkFieldData(designForm, arrayList, true);
        return jSONObject;
    }

    public boolean deleteDesignForm(String designFormCode) {
        return this.designFormService.deleteAll(designFormCode);
    }

    public LowAppCopyMenu copyDesignForm(LowAppCopyMenu lowAppCopyMenu) {
        return this.designFormService.copyDesignForm(lowAppCopyMenu);
    }

    public void updateDesignFormJson(LowAppCopyMenu lowAppCopyMenu) {
        Map map = lowAppCopyMenu.getFormCodeMapping();
        if (map != null && map.size() > 0) {
            for (String string : map.values()) {
                this.designFormService.updateDesignFormJson(string, map, lowAppCopyMenu.getDictCodeMapping());
            }
        }
    }

    public void coverDesignForm(LowAppCopyMenu lowAppCopyMenu) {
        this.designFormService.coverDesignForm(lowAppCopyMenu);
    }

    public List<JSONObject> getViewListByCode(String desformCode) {
        return this.designFormListViewService.getAllView(desformCode);
    }

    public void updateLowAppButtonProcessId(LowAppCopyMenu lowAppCopyMenu) {
        List list = lowAppCopyMenu.getDesignFormCodeList();
        if (list.size() > 0) {
            Map map = lowAppCopyMenu.getProcessIdMapping();
            List<ButtonInfo> list2 = this.designFormListViewButtonService.queryButtonByCode(list);
            if (list2 != null && list2.size() > 0) {
                for (ButtonInfo buttonInfo : list2) {
                    String string;
                    String string2 = buttonInfo.getProcessId();
                    if (oConvertUtils.isEmpty((Object)string2) || !oConvertUtils.isNotEmpty((Object)(string = (String)map.get(string2)))) continue;
                    this.designFormListViewButtonService.updateProcessId(buttonInfo.getId(), string);
                }
            }
        }
    }

    public void copyLowAppChart(LowAppCopyMenu lowAppCopyMenu) {
        List<DesignFormListChartConfig> list;
        Map map = lowAppCopyMenu.getFormCodeMapping();
        Map map2 = lowAppCopyMenu.getFormIdMapping();
        Map map3 = lowAppCopyMenu.getDragIdMapping();
        Map map4 = lowAppCopyMenu.getViewIdMapping();
        Map map5 = lowAppCopyMenu.getProcessIdMapping();
        Map map6 = lowAppCopyMenu.getDictCodeMapping();
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        if (arrayList != null && arrayList.size() > 0 && (list = this.designFormListChartConfigService.queryChartListByFormCode(arrayList)) != null && list.size() > 0) {
            ArrayList<DesignFormListChartConfig> arrayList2 = new ArrayList<DesignFormListChartConfig>();
            for (DesignFormListChartConfig designFormListChartConfig : list) {
                DesignFormListChartConfig designFormListChartConfig2 = new DesignFormListChartConfig();
                BeanUtils.copyProperties((Object)designFormListChartConfig, (Object)designFormListChartConfig2);
                designFormListChartConfig2.setId(null);
                designFormListChartConfig2.setCreateTime(new Date());
                String string = designFormListChartConfig.getDesignFormCode();
                String string2 = (String)map.get(string);
                if (string2 != null) {
                    designFormListChartConfig2.setDesignFormCode(string2);
                }
                String string3 = designFormListChartConfig.getChartId();
                DragRelIdsDTO dragRelIdsDTO = new DragRelIdsDTO(string3, map, map2, map3, map4, map5, map6);
                dragRelIdsDTO.setTenantId(lowAppCopyMenu.getTenantId());
                String string4 = this.dragBaseApi.copyPageCrossApp(dragRelIdsDTO);
                designFormListChartConfig2.setChartId(string4);
                arrayList2.add(designFormListChartConfig2);
            }
            this.designFormListChartConfigService.batchSave(arrayList2);
        }
    }

    public void deleteDesignFormForAppCopy(String menuUrl, Boolean deleteMongo) {
        DesignForm designForm = this.designFormService.getByCode(menuUrl);
        if (designForm == null) {
            designForm = this.designFormService.getByIdCache(menuUrl);
        }
        if (designForm == null) {
            return;
        }
        this.designFormService.removeById((Serializable)((Object)designForm.getId()));
        if (deleteMongo.booleanValue()) {
            this.designFormListViewService.deleteDesignFormMongoConfig(designForm.getDesformCode());
        }
    }

    public void batchDisabledOtherTenantLinkRecords(LowAppCopyMenu copyMenu) {
        if (oConvertUtils.isEmpty((Object)copyMenu.getTenantId()) || Integer.valueOf(0).equals(copyMenu.getTenantId())) {
            return;
        }
        Map map = copyMenu.getFormCodeMapping();
        if (map != null && map.size() > 0) {
            for (String string : map.values()) {
                this.designFormService.disabledOtherTenantLinkRecords(string, copyMenu.getTenantId());
            }
        }
    }
}

