<#assign CACHE_VERSION = "v=1704887009.10">
<#assign base = springMacroRequestContext.getContextUrl("")>

<!DOCTYPE html>
<html lang="zh-Hans">

<head>
  <title>${externalTitle}</title>

<#--  <script src="https://unpkg.com/vconsole@latest/dist/vconsole.min.js"></script>-->
<#--  <script>-->
<#--    (function () {-->
<#--      const vConsole = new window.VConsole();-->
<#--      console.log('移动端调试工具 vConsole 已加载');-->
<#--    })();-->
<#--  </script>-->

  <#include "ftl/generate/formHead.ftl">
  <style>
    #app {
      position: relative;
      margin: 0 auto 50px;
      background-color: #f5f5f5;
    }
    
    #app .header-img img {
      width: 100%;
    }
    
    #app .footer-box {
      position: absolute;
      width: 100%;
      text-align: center;
      color: #3a3a3a;
      bottom: -50px;
    }

    #app .footer-box a {
      color: #1890ff;
    }

    #app .footer-box a:hover {
      text-decoration: underline;
    }
  </style>
</head>

<body style="background-color: #f5f5f5;">

<div id="app" style="opacity: 0" :style="{opacity: '1', width: isMobile ? '100%' : appBoxWidth, backgroundColor: '#fff', minHeight: '100vh'}">
  <div v-if="showHeaderImg" class="header-img">
    <img :src="headerImgUrl" alt="页眉">
  </div>
  <!-- 表单渲染 -->
  <#include "ftl/generate/formRender.ftl">

  <div class="footer-box">
<#--    <p>此服务由<a href="http://jeecg.com" target="_blank">JEECG低代码平台</a>提供技术支持</p>-->
    <p>此服务由 <a href="https://qiaoqiaoyun.com" target="_blank">敲敲云</a> 提供技术支持</p>
  </div>

  <el-dialog title="查看已保存的数据" :visible.sync="externalVisible" width="800px" :fullscreen="isMobile">
    <div>
      <p style="font-size: 0.8rem;color: #999999;">仅展示最近的五条数据</p>
      <el-timeline v-if="externalSavedList.length > 0" :style="{paddingLeft:isMobile?'0':null}">
        <#-- 只展示前五条 -->
        <template v-for="(data,idx) of externalSavedList">
          <el-timeline-item v-if="idx < 5" :key="idx" :timestamp="data.updateTime" placement="top">
            <el-card>
              <template v-if="idx===0">
                <el-link v-if="isEditing(data.dataId)" @click="externalVisible=false">正在编辑</el-link>
                <el-link v-else type="primary" @click="jumpTo(data.dataId)">点击编辑</el-link>
                <span> | </span>
              </template>
              <el-link v-if="isReusing(data.dataId)" @click="externalVisible=false">正在复用</el-link>
              <el-link v-else type="primary" @click="jumpTo(data.dataId, true)">复用</el-link>
              <p>保存时间：<br>{{data.updateTime}}</p>
              <p style="text-align: right;margin: 0;">
                <el-link type="primary" @click="handleRemove(data.dataId)">删除</el-link>
              </p>
            </el-card>
          </el-timeline-item>
        </template>
      </el-timeline>
      <h3 v-else style="text-align: center;margin-top: 50px;">你还未保存任何数据</h3>
    </div>
    <div slot="footer" class="dialog-footer">
      <el-button v-if="!isMobile" type="primary" plain @click="jumpTo()">提交新数据</el-button>
      <el-button type="primary" @click="externalVisible = false" :style="{width:isMobile?'100%':null}">确 定</el-button>
      <el-button v-if="isMobile" type="primary" plain @click="jumpTo()" style="width:100%;margin: 8px 0 0 0;">提交新数据</el-button>
    </div>
  </el-dialog>

</div>

<#if hasMarkdown!true>
  <script src="${base}/desform/lib/toastui/ToastUI.umd.js?cv=1"></script>
</#if>

<#-- importJmForm 导入编译后的表单设计器 -->
<#--noinspection HtmlUnknownTarget,JSUnresolvedVariable,FtlReferencesInspection-->
<script src="${baseJmForm}/JmForm.umd.js?${CACHE_VERSION}"></script>
<#--noinspection FtlReferencesInspection-->
<script src="${base}/desform/utils.js?${CACHE_VERSION}"></script>
<script>

  // vuex 缓存
  var store = JmForm.default.store
  // 日期 moment
  var moment = JmForm.default.moment
  // 设备类型混入
  var DeviceMixins = JmForm.default.mixins.DeviceMixins
  // 常量
  var constant = JmForm.default.constant
  // 操作
  var actions = JmForm.default.actions

</script>

<script>

  // 从配置里读取主题颜色
  window['THEME_COLOR'] = '${themeColor}'
  // 从配置里读取上传方式
  window['UPLOAD_TYPE'] = '${uploadType}'
  // 从配置里读取签名秘钥
  window['SIGNATURE_SECRET']= '${signatureSecret}'

  // 外部链接使用模拟 Token、无messageId、无tenantId e3e3NcxzbUiGa53YYVXxWc8ADo5ISgQGx/gaZwERF91oAryDlivjqBv3wqRArgChupi+Y/Gg/swwGEyL0PuVFg==
  var token = '${mockToken}', messageId = '', tenantId = null

  var innerRequest = true, eventDialog = false, innerDialog = false, skip = true,
    disableScroll = false, showFooter = true, transparent = false, triggerTips = false

  var baseURL = '${baseURL}'
  Vue.ls.set(constant.BASE_URL, baseURL)
  Vue.ls.set(constant.ACCESS_TOKEN, token)
  Vue.ls.set(constant.LOW_APP_ID, "")

  var isExternal = true
  store.commit('TOGGLE_IS_EXTERNAL', isExternal)
  var showSaveData = ${showSaveData?string('1', '0')}

  // 是否是通过 ID 查询，否则就是通过 code
  var formIsId = ${formIsId?string('true', 'false')};
  // 通过id的前缀是 pub，code是ext
  var formUrlStr = formIsId ? 'pub' : 'ext';

  var defaultFormData = {}
  var widgetConfig = []

  window['__authUserInfo'] = {}

  // 外部页面专用的 Vue混入
  var ExternalMixins = {
    data: function () {
      return {
        isExternal: isExternal,
        showSaveData: showSaveData,
        externalSavedList: [],
        externalVisible: false,
        initialModels: '',
        // 页面宽度，会根据表单配置动态变更
        appBoxWidth: '1000px',
        // 是否显示页眉图片
        showHeaderImg: ${showHeaderImg?string('true', 'false')},
        // 页眉图片地址
        headerImgUrl: '${headerImgUrl!''}',
      }
    },
    mounted: function () {
      this.externalSavedList = this.getExternalSaved()
      var _this = this
      this.$nextTick(function () {
        _this.initialModels = JSON.stringify(_this.$refs['generateForm'].models)
      })
      this.appBoxWidth = this.jsonData.config.dialogOptions.width + 'px'
    },
    methods: {

      isEditing: function (dataId) {
        return dataId === this.dataId && this.action !== 'add'
      },

      isReusing: function (dataId) {
        return dataId === this.dataId && this.action === 'add'
      },

      handleViewExternalSaved: function () {
        this.externalVisible = true
      },

      // 判断数据是否更改
      dataIsChanged: function () {
        try {
          var models = this.$refs['generateForm'].models
          var jsonModels = JSON.stringify(models)
          if (jsonModels === this.initialModels || jsonModels === JSON.stringify(this.editData)) {
            return false
          }
          var changed = false
          for (var key in models) {
            if (models.hasOwnProperty(key)) {
              if (models[key] != null && models[key] !== '') {
                changed = true
                break
              }
            }
          }
          return changed
        } catch (e) {
          console.error(e)
        }
        return true
      },
      // 跳转至新页面
      jumpTo: function (dataId, reuse) {
        var formKey = formIsId ? this.desformId : this.desformCode
        var url = baseURL + '/desform/' + formUrlStr + '/' + formKey
        if (dataId) {
          if (reuse) {
            url += '?reuseId=' + dataId
          } else {
            url += '/' + dataId
          }
        }
        if (this.dataIsChanged()) {
          this.$confirm('确定放弃当前尚未保存的数据吗？', '提示', {
            type: 'warning'
          }).then(function () {
            window.location.href = url
          }).catch(function () {
          })
        } else {
          window.location.href = url
        }
      },

      /** 删除一条数据（只删缓存） */
      handleRemove: function (dataId) {
        var _this = this
        if (this.isEditing(dataId)) {
          this.$message.warning('当前正在编辑，无法删除')
          return
        }
        if (this.isReusing(dataId)) {
          this.$message.warning('当前正在复用，无法删除')
          return
        }
        this.$confirm('确定要删除吗？', '提示', {
          type: 'warning'
        }).then(function () {
          var dataList = _this.getExternalSaved()

          for (var i in dataList) {
            if (!dataList.hasOwnProperty(i)) {
              continue
            }
            if (dataList[i].dataId === dataId) {
              dataList.splice(i, 1)
              break
            }
          }
          _this.saveExternalSaved(dataList)
          _this.$message.success('删除成功')
        }).catch(function () {
        })
      },

      getExternalSavedKey: function () {
        return 'EXTERNAL_SAVED_' + this.desformId
      },
      // 从缓存中取出已保存的数据
      getExternalSaved: function () {
        return this.$ls.get(this.getExternalSavedKey()) || []
      },
      // 向缓存中保存数据，自动去重
      setExternalSaved: function (dataId) {
        var dataList = this.getExternalSaved() || []
        for (var idx in dataList) {
          if (dataList.hasOwnProperty(idx)) {
            var data = dataList[idx]
            if (data.dataId === dataId) {
              dataList.splice(idx, 1)
              break
            }
          }
        }
        // 最新的数据永远放到第一条
        dataList.splice(0, 0, { dataId: dataId, updateTime: moment().format('YYYY年MM月DD日 HH时mm分ss秒') })
        this.saveExternalSaved(dataList)
      },

      saveExternalSaved: function (dataList) {
        this.$ls.set(this.getExternalSavedKey(), dataList)
        this.externalSavedList = this.getExternalSaved()
      },

    }
  }


</script>

<!-- 初始化表单渲染所需数据 -->
<#include "ftl/generate/initFormRenderData.ftl" >

</body>

</html>