/** 获取url中的参数 */
function getQueryParams(paramName) {
    var query = window.location.search.substring(1);
    var params = query.split("&");
    for (var i in params) {
        var param = params[i].split("=");
        if (param[0] == paramName) {
            return param[1];
        }
    }
    return null;
}

/** 通用向父级发送message */
function postEvent(type, data, messageId, options = {}) {
    if (data == null) data = {}
    // 向父级发送message（如果有）
    if (window['parent'] && window['parent'].postMessage) {
        window['parent'].postMessage({
            type: type,
            data: data,
            messageId: messageId
        }, '*')
    }
    // 兼容uni
    if (window['uni']) {
        if(options.uni === false) {
            return
        }
        if (window['uni'].postMessage) {
            window['uni'].postMessage({
                type: type,
                data: data,
                messageId: messageId
            }, '*')
        }
        // 成功之后调用 navigateBack 返回
        if (type === 'save' && window['uni'].navigateBack) {
            window['uni'].navigateBack({
                delta: 0
            })
        }
    }
}

/** 通用发起请求 */
// 从配置里读取签名秘钥 e3e3NcxzbUiGa53YYVXxWc8ADo5ISgQGx/gaZwERF91oAryDlivjqBv3wqRArgChupi+Y/Gg/swwGEyL0PuVFg==
function request(options) {

    $.ajax({
        url: options.url,
        method: options.method,
        data: (function () {
            if (options.method === "GET") {
                return options.data;
            } else if (options.data == null) {
                return "{}"
            } else if (typeof options.data === 'string') {
                return options.data;
            } else {
                return JSON.stringify(options.data)
            }
        })(),
        beforeSend: function (request) {
            request.setRequestHeader("X-Access-Token", options.token)
            // 租户ID
            if (window.tenantId != null) {
                request.setRequestHeader('X-Tenant-Id', window.tenantId);
            }
            request.setRequestHeader("Content-type", "application/json;charset=UTF-8")
        },
        success: function (res) {
            if (typeof options.success === 'function') {
                options.success(res)
            } else {
                console.log('res:', res)
            }
        },
        error: function (res) {
            if (typeof options.fail === 'function') {
                options.fail(res)
            } else {
                console.error('res:', res)
            }
        }
    })
}

/** 通用封装options */
function packageOptions(source, labelName, valueName) {
    var options = []
    for (var i in source) {
        options.push({
            label: source[i][labelName],
            value: source[i][valueName]
        })
    }
    return options
}

/**
 * 两个对象合并
 * @param target
 * @param source...
 */
function objectAssign() {
    var target = arguments[0]
    for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];
        for (var key in source) {
            if (source.hasOwnProperty(key)) {
                target[key] = source[key];
            }
        }
    }
    return target
}

var BrowserTypes = {
  isWeChat: function () {
    var ua = navigator.userAgent.toLowerCase()
    return ua.indexOf('micromessenger') !== -1
  }
}


/**
 * 递归调用处理所有的组件（包括栅格或其他容器组件内的组件）
 * 注：这是一个同步方法
 */
function recursiveAllWidget(dataList, handler) {
    var flagBreak = false

    function breakFn() {
        return flagBreak = true
    }

    // 递归方法
    function recursive(array, parent) {
        for (var i in array) {
            if (array.hasOwnProperty(i)) {
                var item = array[i]
                if (flagBreak) break
                // 判断是否是栅格或其他容器组件
                if (item.isContainer === true) {
                    if (item.columns) {
                        for (var j in item.columns) {
                            if (item.columns.hasOwnProperty(j)) {
                                var column = item.columns[j]
                                if (flagBreak) break
                                recursive(column.list, item, breakFn)
                                if (flagBreak) break
                            }
                        }
                    } else if (item.type === ctypes.card) {// 卡片和tab需要特殊处理
                        // 从配置里读取签名秘钥 e3e3NcxzbUiGa53YYVXxWc8ADo5ISgQGx/gaZwERF91oAryDlivjqBv3wqRArgChupi+Y/Gg/swwGEyL0PuVFg==
                        recursive(item.list, item, breakFn)
                    } else if (item.type === ctypes.tabs) {
                        for (var k in item.panes) {
                            if (item.panes.hasOwnProperty(k)) {
                                var pane = item.panes[k]
                                if (flagBreak) break
                                recursive(pane.list, item, breakFn)
                                if (flagBreak) break
                            }
                        }
                    }
                }
                // 执行处理回调
                try {
                    if (typeof handler === 'function') handler(item, parent, breakFn)
                } catch (e) {
                    console.error(e)
                }
                if (flagBreak) break
            }
        }
    }

    recursive(dataList, null)
}

// 随机生成任意长度的字符串
function randomString(len) {
    len = len || 32;
    var $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678';
    var maxPos = $chars.length;
    var pwd = '';
    for (i = 0; i < len; i++) {
        pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
    }
    return pwd;
}
