/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jeecg.common.system.query.MatchTypeEnum;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.constant.WidgetTypes;
import org.jeecg.modules.online.desform.entity.DesignForm;
import org.jeecg.modules.online.desform.mongo.a.b;
import org.jeecg.modules.online.desform.mongo.b.a;
import org.jeecg.modules.online.desform.mongo.model.CalendarColumn;
import org.jeecg.modules.online.desform.mongo.model.FieldOption;
import org.jeecg.modules.online.desform.util.f;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQueryGroup;
import org.jeecg.modules.online.desform.vo.query.SuperQueryItem;
import org.jeecg.modules.online.desform.vo.widget.DesformWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public class DesformQueryUtils {
    private static final Logger a = LoggerFactory.getLogger(DesformQueryUtils.class);

    public static DesformSuperQuery a(String string, Map<String, String[]> map) throws UnsupportedEncodingException {
        DesformSuperQuery desformSuperQuery = DesformQueryUtils.a(string);
        if (map != null && !map.isEmpty()) {
            for (String string2 : map.keySet()) {
                if (!"id".equals(string2)) continue;
                CharSequence[] charSequenceArray = map.get(string2);
                if (charSequenceArray == null || charSequenceArray.length <= 0) break;
                String string3 = String.join((CharSequence)",", charSequenceArray);
                desformSuperQuery.add(new SuperQueryItem("string", "_id", string3, QueryRuleEnum.IN));
                break;
            }
        }
        return desformSuperQuery;
    }

    public static DesformSuperQueryGroup b(String string, Map<String, String[]> map) throws UnsupportedEncodingException {
        a.info("superQueryGroup \u539f\u751f = {}", (Object)string);
        String string2 = URLDecoder.decode(string, "UTF-8");
        a.info("superQueryGroup \u89e3\u7801 = {}", (Object)string2);
        DesformSuperQueryGroup desformSuperQueryGroup = new DesformSuperQueryGroup();
        ArrayList<DesformSuperQuery> arrayList = new ArrayList<DesformSuperQuery>();
        JSONObject jSONObject = JSON.parseObject((String)string2);
        JSONArray jSONArray = jSONObject.getJSONArray("superQueryGroup");
        for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
            if (jSONObject2.isEmpty()) continue;
            DesformSuperQuery desformSuperQuery = DesformQueryUtils.a(jSONObject2);
            arrayList.add(desformSuperQuery);
        }
        MatchTypeEnum matchTypeEnum = MatchTypeEnum.getByValue((String)jSONObject.getString("matchType"));
        desformSuperQueryGroup.setMatchType(matchTypeEnum == null ? MatchTypeEnum.AND : matchTypeEnum);
        desformSuperQueryGroup.setSuperQueryGroup(arrayList);
        return desformSuperQueryGroup;
    }

    public static DesformSuperQuery a(JSONObject jSONObject) throws UnsupportedEncodingException {
        MatchTypeEnum matchTypeEnum = MatchTypeEnum.getByValue((String)jSONObject.getString("matchType"));
        JSONArray jSONArray = jSONObject.getJSONArray("queryItems");
        List<SuperQueryItem> list = DesformQueryUtils.a(jSONArray);
        DesformSuperQuery desformSuperQuery = new DesformSuperQuery();
        desformSuperQuery.setMatchType(matchTypeEnum == null ? MatchTypeEnum.AND : matchTypeEnum);
        desformSuperQuery.addAll(list);
        return desformSuperQuery;
    }

    public static DesformSuperQuery a(String string) throws UnsupportedEncodingException {
        JSONObject jSONObject = JSON.parseObject((String)string);
        MatchTypeEnum matchTypeEnum = MatchTypeEnum.getByValue((String)jSONObject.getString("matchType"));
        String string2 = jSONObject.getString("superQueryParams");
        JSONArray jSONArray = new JSONArray();
        if (oConvertUtils.isNotEmpty((Object)string2)) {
            string2 = URLDecoder.decode(string2, "UTF-8");
            jSONArray = JSON.parseArray((String)string2);
        }
        List<SuperQueryItem> list = DesformQueryUtils.a(jSONArray);
        DesformSuperQuery desformSuperQuery = new DesformSuperQuery();
        desformSuperQuery.setMatchType(matchTypeEnum == null ? MatchTypeEnum.AND : matchTypeEnum);
        desformSuperQuery.addAll(list);
        return desformSuperQuery;
    }

    public static List<SuperQueryItem> a(JSONArray jSONArray) {
        ArrayList<SuperQueryItem> arrayList = new ArrayList<SuperQueryItem>();
        if (jSONArray != null && !jSONArray.isEmpty()) {
            for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                arrayList.add(new SuperQueryItem(jSONObject));
            }
        }
        return arrayList;
    }

    public static Query fillMongoQuery(DesformSuperQuery superQuery) {
        Criteria criteria;
        Query query = new Query();
        if (superQuery == null) {
            return query;
        }
        ArrayList<Criteria> arrayList = new ArrayList<Criteria>();
        List<String> list = superQuery.getIdList();
        if (list != null && list.size() > 0) {
            criteria = new Criteria("_id").in(list);
            arrayList.add(criteria);
        }
        if ((criteria = DesformQueryUtils.a(superQuery)) != null) {
            arrayList.add(criteria);
        }
        if (arrayList.size() > 0) {
            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(arrayList));
        }
        a.info("MongoDB \u67e5\u8be2\u6761\u4ef6: {}", (Object)query.getQueryObject().toJson());
        return query;
    }

    public static Criteria a(List<CalendarColumn> list, Map<String, String[]> map) {
        ArrayList<Date> arrayList = new ArrayList<Date>();
        String string = DesformQueryUtils.c("begin_date", map);
        String string2 = DesformQueryUtils.c("end_date", map);
        for (CalendarColumn calendarColumn : list) {
            Date date;
            Object object;
            ArrayList<Criteria> arrayList2 = new ArrayList<Criteria>();
            String string3 = calendarColumn.getBeginDateField();
            if (oConvertUtils.isNotEmpty((Object)string3) && oConvertUtils.isNotEmpty((Object)string)) {
                object = DateUtils.str2Date((String)string, (SimpleDateFormat)((SimpleDateFormat)DateUtils.datetimeFormat.get()));
                arrayList2.add(new Criteria(string3).gte(object));
            }
            if (oConvertUtils.isNotEmpty((Object)(object = calendarColumn.getEndDateField())) && oConvertUtils.isNotEmpty((Object)string2)) {
                date = DateUtils.str2Date((String)string2, (SimpleDateFormat)((SimpleDateFormat)DateUtils.datetimeFormat.get()));
                arrayList2.add(new Criteria(string3).lte((Object)date));
            }
            if (arrayList2.size() <= 0) continue;
            date = new Criteria().andOperator(arrayList2);
            arrayList.add(date);
        }
        if (arrayList.size() > 0) {
            return new Criteria().orOperator(arrayList);
        }
        return null;
    }

    public static Criteria b(List<FieldOption> list, Map<String, String[]> map) {
        String string = DesformQueryUtils.c("global_keyword", map);
        if (oConvertUtils.isEmpty((Object)string)) {
            return null;
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<Criteria> arrayList = new ArrayList<Criteria>();
        for (FieldOption fieldOption : list) {
            String string2 = fieldOption.getType();
            String string3 = fieldOption.getField();
            if (WidgetTypes.INPUT.getType().equals(string2) || WidgetTypes.TEXTAREA.getType().equals(string2) || WidgetTypes.TEXT.getType().equals(string2) || WidgetTypes.EMAIL.getType().equals(string2) || WidgetTypes.PHONE.getType().equals(string2) || WidgetTypes.AUTO_NUMBER.getType().equals(string2)) {
                Pattern pattern = Pattern.compile(".*" + string + ".*", 2);
                arrayList.add(new Criteria(string3).regex(pattern));
                continue;
            }
            if (WidgetTypes.MONEY.getType().equals(string2) || WidgetTypes.NUMBER.getType().equals(string2)) {
                try {
                    arrayList.add(new Criteria(string3).is((Object)b.a(string)));
                }
                catch (Exception exception) {
                    a.info("\u5b57\u7b26\u4e32\u8f6c\u6570\u503c\u5931\u8d25\uff0c\u76f4\u63a5\u8df3\u8fc7\u4e0d\u4f5c\u67e5\u8be2\uff1a" + string);
                }
                continue;
            }
            if (!WidgetTypes.INTEGER.getType().equals(string2)) continue;
            try {
                arrayList.add(new Criteria(string3).is((Object)Integer.parseInt(string)));
            }
            catch (Exception exception) {
                a.info("\u5b57\u7b26\u4e32\u8f6c\u6570\u503c\u5931\u8d25\uff0c\u76f4\u63a5\u8df3\u8fc7\u4e0d\u4f5c\u67e5\u8be2\uff1a" + string);
            }
        }
        if (arrayList.size() > 0) {
            return new Criteria().orOperator(arrayList);
        }
        return null;
    }

    public static String c(String string, Map<String, String[]> map) {
        String string2 = "";
        if (map == null) {
            return string2;
        }
        for (String string3 : map.keySet()) {
            if (!string3.equals(string)) continue;
            String[] stringArray = map.get(string);
            if (stringArray == null || stringArray.length <= 0) break;
            string2 = stringArray[0];
            break;
        }
        return string2;
    }

    public static Criteria a(DesignForm designForm, String string, List<String> list, List<String> list2) {
        ArrayList<Criteria> arrayList = new ArrayList<Criteria>();
        Criteria criteria = new Criteria("create_by").is((Object)string);
        arrayList.add(criteria);
        List<DesformWidget> list3 = org.jeecg.modules.online.desform.mongo.b.a.b(designForm, "owners,member");
        List list4 = Arrays.stream(string.split(",")).collect(Collectors.toList());
        if (list3 != null && list3.size() > 0) {
            for (DesformWidget desformWidget : list3) {
                WidgetTypes widgetTypes = desformWidget.getType();
                String string2 = desformWidget.getModel();
                if (WidgetTypes.SELECT_USER.equals((Object)widgetTypes)) {
                    arrayList.add(new Criteria(string2).elemMatch(new Criteria("$in").is(list4)));
                    continue;
                }
                if (WidgetTypes.SELECT_DEPART.equals((Object)widgetTypes)) {
                    if (list2 == null || list2.size() <= 0) continue;
                    arrayList.add(new Criteria(string2).elemMatch(new Criteria("$in").is(list2)));
                    continue;
                }
                if (!WidgetTypes.ORG_ROLE.equals((Object)widgetTypes) || list == null || list.size() <= 0) continue;
                arrayList.add(new Criteria(string2).elemMatch(new Criteria("$in").is(list)));
            }
        }
        Criteria criteria2 = new Criteria().orOperator(arrayList);
        return criteria2;
    }

    public static Criteria a(DesformSuperQuery desformSuperQuery) {
        return DesformQueryUtils.a(desformSuperQuery, false);
    }

    public static Criteria a(DesformSuperQuery desformSuperQuery, boolean bl) {
        List<Criteria> list = DesformQueryUtils.b(desformSuperQuery, bl);
        if (!CollectionUtils.isEmpty(list)) {
            if (desformSuperQuery.getMatchType() == MatchTypeEnum.AND) {
                Criteria criteria = new Criteria().andOperator(list);
                return criteria;
            }
            Criteria criteria = new Criteria().orOperator(list);
            return criteria;
        }
        return null;
    }

    public static List<Criteria> b(DesformSuperQuery desformSuperQuery, boolean bl) {
        List<SuperQueryItem> list = desformSuperQuery.getQueryItems();
        if (list != null || list.size() > 0) {
            ArrayList<Criteria> arrayList = new ArrayList<Criteria>(list.size());
            block20: for (SuperQueryItem superQueryItem : list) {
                String string = superQueryItem.getVal();
                String string2 = superQueryItem.getType();
                String string3 = superQueryItem.getField();
                if (string != null && string.indexOf("#{") >= 0) {
                    string = QueryGenerator.getSqlRuleValue((String)string);
                }
                if (bl) {
                    superQueryItem.setCustomSetTimestamp();
                }
                List<String> list2 = b.a(string2, string, superQueryItem);
                QueryRuleEnum queryRuleEnum = superQueryItem.getRule();
                if (queryRuleEnum == null) continue;
                if (string != null && string.startsWith("[") && string.endsWith("]")) {
                    string = string.substring(1, string.length() - 1).replace("\"", "");
                }
                switch (queryRuleEnum) {
                    case GT: {
                        arrayList.add(new Criteria(string3).gt((Object)list2));
                        break;
                    }
                    case GE: {
                        arrayList.add(new Criteria(string3).gte((Object)list2));
                        break;
                    }
                    case LT: {
                        arrayList.add(new Criteria(string3).lt((Object)list2));
                        break;
                    }
                    case LE: {
                        arrayList.add(new Criteria(string3).lte((Object)list2));
                        break;
                    }
                    case EQ: {
                        if (list2 instanceof String && list2.toString().contains(",")) {
                            list2 = Arrays.asList(list2.toString().split(","));
                        }
                        arrayList.add(new Criteria(string3).is((Object)list2));
                        break;
                    }
                    case NE: {
                        if (list2 instanceof String && list2.toString().contains(",")) {
                            list2 = Arrays.asList(list2.toString().split(","));
                        }
                        arrayList.add(new Criteria(string3).ne((Object)list2));
                        break;
                    }
                    case IN: {
                        String[] stringArray = string.split(",");
                        if (stringArray.length <= 0) break;
                        arrayList.add(new Criteria(string3).in(Arrays.asList(stringArray)));
                        break;
                    }
                    case NOT_IN: {
                        String[] stringArray = string.split(",");
                        if (stringArray.length <= 0) break;
                        arrayList.add(new Criteria(string3).nin(Arrays.asList(stringArray)));
                        break;
                    }
                    case LIKE: {
                        Pattern pattern = Pattern.compile(".*" + list2 + ".*", 2);
                        arrayList.add(new Criteria(string3).regex(pattern));
                        break;
                    }
                    case NOT_LIKE: {
                        Pattern pattern = Pattern.compile("^((?!" + list2 + ").)*$", 2);
                        arrayList.add(new Criteria(string3).regex(pattern));
                        break;
                    }
                    case LEFT_LIKE: {
                        Pattern pattern = Pattern.compile(".*" + list2 + "$", 2);
                        arrayList.add(new Criteria(string3).regex(pattern));
                        break;
                    }
                    case RIGHT_LIKE: {
                        Pattern pattern = Pattern.compile("^" + list2 + ".*", 2);
                        arrayList.add(new Criteria(string3).regex(pattern));
                        break;
                    }
                    case EMPTY: {
                        ArrayList<Criteria> arrayList2 = new ArrayList<Criteria>();
                        arrayList2.add(new Criteria(string3).is(null));
                        arrayList2.add(new Criteria(string3).is((Object)""));
                        arrayList2.add(new Criteria(string3).is(new ArrayList()));
                        arrayList.add(new Criteria().orOperator(arrayList2));
                        break;
                    }
                    case NOT_EMPTY: {
                        ArrayList<Criteria> arrayList3 = new ArrayList<Criteria>();
                        arrayList3.add(new Criteria(string3).ne(null));
                        arrayList3.add(new Criteria(string3).ne((Object)""));
                        arrayList3.add(new Criteria(string3).ne(new ArrayList()));
                        arrayList.add(new Criteria().andOperator(arrayList3));
                        break;
                    }
                    case LIKE_WITH_AND: {
                        if (!oConvertUtils.isNotEmpty((Object)string)) break;
                        Object object = string.split(",");
                        Object object2 = new ArrayList<String>();
                        for (String string4 : object) {
                            object2.add(new Criteria(string3).regex(string4));
                        }
                        arrayList.add(new Criteria().orOperator((Collection)object2));
                        break;
                    }
                    case ELE_MATCH: {
                        if (!oConvertUtils.isNotEmpty((Object)string)) break;
                        Object object = string.split(",");
                        Object object2 = Arrays.asList(object);
                        arrayList.add(new Criteria(string3).elemMatch(new Criteria("$in").is(object2)));
                        break;
                    }
                    case RANGE: {
                        Object e2;
                        Object object2;
                        if (!oConvertUtils.isNotEmpty((Object)string)) break;
                        Object object = (String[])list2;
                        if (object == null || object.size() <= 0) continue block20;
                        if (object.size() == 1) {
                            object2 = object.get(0);
                            if (!oConvertUtils.isNotEmpty(object2)) continue block20;
                            arrayList.add(new Criteria(string3).gte(object2));
                            break;
                        }
                        if (object.size() != 2) continue block20;
                        object2 = new Criteria(string3);
                        Object e3 = object.get(0);
                        if (oConvertUtils.isNotEmpty(e3)) {
                            object2.gte(e3);
                        }
                        if (oConvertUtils.isNotEmpty(e2 = object.get(1))) {
                            object2.lte(e2);
                        }
                        arrayList.add((Criteria)object2);
                        break;
                    }
                    case NOT_RANGE: {
                        Object object2;
                        if (!oConvertUtils.isNotEmpty((Object)string)) break;
                        Object object = list2;
                        if (object == null || object.size() <= 0) continue block20;
                        if (object.size() == 1) {
                            object2 = object.get(0);
                            if (!oConvertUtils.isNotEmpty(object2)) continue block20;
                            arrayList.add(new Criteria(string3).lt(object2));
                            break;
                        }
                        if (object.size() != 2) continue block20;
                        object2 = new Criteria(string3);
                        Object e4 = object.get(0);
                        if (oConvertUtils.isNotEmpty(e4)) {
                            object2.lt(e4);
                        }
                        Criteria criteria = new Criteria(string3);
                        Object e5 = object.get(1);
                        if (oConvertUtils.isNotEmpty(e5)) {
                            criteria.gt(e5);
                        }
                        arrayList.add(new Criteria().orOperator(new Criteria[]{object2, criteria}));
                        break;
                    }
                }
            }
            if (arrayList.size() > 0) {
                return arrayList;
            }
        }
        return null;
    }

    public static Query a(List<OrderItem> list, Query query) {
        if (list != null && !list.isEmpty()) {
            ArrayList<Sort.Order> arrayList = new ArrayList<Sort.Order>();
            for (OrderItem orderItem : list) {
                if (orderItem.isAsc()) {
                    arrayList.add(new Sort.Order(Sort.Direction.ASC, orderItem.getColumn()));
                    continue;
                }
                arrayList.add(new Sort.Order(Sort.Direction.DESC, orderItem.getColumn()));
            }
            query.with(Sort.by(arrayList));
        }
        return query;
    }

    public static DesformSuperQuery c(List<Map<String, Object>> list, Map<String, String[]> map) {
        DesformSuperQuery desformSuperQuery = new DesformSuperQuery();
        desformSuperQuery.setMatchType(MatchTypeEnum.AND);
        if (map == null || map.isEmpty()) {
            return desformSuperQuery;
        }
        if (list == null || list.size() == 0) {
            return desformSuperQuery;
        }
        ArrayList<SuperQueryItem> arrayList = new ArrayList<SuperQueryItem>();
        block0: for (Map<String, Object> map2 : list) {
            String string = map2.get("field").toString();
            String string2 = map2.get("queryType").toString();
            String string3 = map2.get("type").toString();
            for (String string4 : map.keySet()) {
                Object object;
                if (!string4.equals(string)) continue;
                CharSequence[] charSequenceArray = map.get(string);
                if (charSequenceArray == null || charSequenceArray.length <= 0) continue block0;
                String string5 = String.join((CharSequence)",", charSequenceArray);
                if (oConvertUtils.isEmpty((Object)string5)) continue;
                if (charSequenceArray.length > 1) {
                    object = new SuperQueryItem(string3, string, string5, QueryRuleEnum.IN);
                    arrayList.add((SuperQueryItem)object);
                    continue block0;
                }
                object = QueryRuleEnum.EQ;
                if ("like".equalsIgnoreCase(string2)) {
                    object = QueryRuleEnum.LIKE;
                } else if (QueryRuleEnum.RANGE.getCondition().equalsIgnoreCase(string2)) {
                    object = QueryRuleEnum.RANGE;
                } else if (QueryRuleEnum.ELE_MATCH.getCondition().equalsIgnoreCase(string2)) {
                    object = QueryRuleEnum.ELE_MATCH;
                }
                SuperQueryItem superQueryItem = new SuperQueryItem(string3, string, string5, (QueryRuleEnum)object);
                arrayList.add(superQueryItem);
                continue block0;
            }
        }
        desformSuperQuery.setQueryItems(arrayList);
        return desformSuperQuery;
    }

    public static List<OrderItem> a(String string, String string2, String string3) {
        ArrayList<OrderItem> arrayList = new ArrayList<OrderItem>();
        if (oConvertUtils.isEmpty((Object)string3)) {
            if ("desc".equals(string2)) {
                arrayList.add(OrderItem.desc((String)string));
            } else {
                arrayList.add(OrderItem.asc((String)string));
            }
        } else {
            JSONArray jSONArray = JSONArray.parseArray((String)string3);
            for (JSONObject jSONObject : jSONArray) {
                String string4 = jSONObject.getString("column");
                if (!oConvertUtils.isNotEmpty((Object)string4)) continue;
                String string5 = jSONObject.getString("order");
                if ("desc".equals(string5)) {
                    arrayList.add(OrderItem.desc((String)string4));
                    continue;
                }
                arrayList.add(OrderItem.asc((String)string4));
            }
        }
        return arrayList;
    }

    public static List<FieldOption> a(DesignForm designForm) {
        String string = designForm.getDesformDesignJson();
        ArrayList<FieldOption> arrayList = new ArrayList<FieldOption>();
        if (oConvertUtils.isNotEmpty((Object)string)) {
            JSONObject jSONObject = JSON.parseObject((String)string);
            DesformQueryUtils.a(arrayList, jSONObject);
        }
        return arrayList;
    }

    private static void a(List<FieldOption> list, JSONObject jSONObject3) {
        JSONArray jSONArray = jSONObject3.getJSONArray("list");
        if (jSONArray == null || jSONArray.isEmpty()) {
            return;
        }
        f.a(jSONArray, (WidgetTypes widgetTypes, JSONObject jSONObject, JSONObject jSONObject2) -> {
            String string = jSONObject.getString("model");
            if (WidgetTypes.INPUT == widgetTypes || WidgetTypes.TEXTAREA == widgetTypes || WidgetTypes.TEXT == widgetTypes || WidgetTypes.MONEY == widgetTypes || WidgetTypes.INTEGER == widgetTypes || WidgetTypes.NUMBER == widgetTypes || WidgetTypes.EMAIL == widgetTypes || WidgetTypes.PHONE == widgetTypes || WidgetTypes.AUTO_NUMBER == widgetTypes) {
                list.add(new FieldOption(string, widgetTypes.getType()));
            }
        });
    }

    public static void a(Page page, List<OrderItem> list) {
        if (page == null) {
            return;
        }
        List list2 = page.getOrders();
        for (OrderItem orderItem : list) {
            String string = orderItem.getColumn();
            boolean bl = true;
            for (OrderItem orderItem2 : list2) {
                if (!orderItem2.getColumn().equals(string)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            page.addOrder(new OrderItem[]{orderItem});
        }
    }
}

