/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate;

import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.enums.MessageTypeEnum;
import org.jeecg.common.constant.enums.Vue3MessageHrefEnum;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.UserAccountInfo;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.enums.TaskTipTypeEnum;
import org.jeecg.modules.extbpm.process.adapter.delegate.datahandle.service.MessagePushService;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.entity.ExtActProcess;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNodeDeployment;
import org.jeecg.modules.extbpm.service.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="messageDelegate")
public class MessageDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(MessageDelegate.class);
    @Autowired
    private ISysBaseAPI baseApi;
    @Autowired
    private ProcessUtils processUtils;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private MessagePushService messagePushService;
    public static ExecutorService cachedThreadPool = new ThreadPoolExecutor(0, 1024, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    public void execute(DelegateExecution delegateExecution) {
        if (this.baseApi == null) {
            this.baseApi = (ISysBaseAPI)SpringContextUtils.getBean(ISysBaseAPI.class);
        }
        if (this.processUtils == null) {
            this.processUtils = (ProcessUtils)SpringContextUtils.getBean((String)"processUtils");
        }
        if (this.messagePushService == null) {
            this.messagePushService = (MessagePushService)SpringContextUtils.getBean(MessagePushService.class);
        }
        ExecutionEntity executionEntity = (ExecutionEntity)delegateExecution;
        String string = executionEntity.getProcessDefinitionKey();
        String string2 = executionEntity.getId();
        String string3 = executionEntity.getProcessInstanceId();
        ExtActProcess extActProcess = this.processUtils.getExtActProcessByProcessKey(string);
        if (ObjectUtils.isNotEmpty((Object)extActProcess)) {
            String string4 = extActProcess.getId();
            String string5 = executionEntity.getActivityId();
            Integer n = extActProcess.getTenantId();
            ExtActProcessNodeDeployment extActProcessNodeDeployment = this.processUtils.getExtActProcessNodeDeployment(string4, string5);
            String string6 = extActProcessNodeDeployment.getProcessNodeCode();
            log.info("-------\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011-----\u63a8\u9001\u6d88\u606f\u5f00\u59cb--------------");
            log.info("\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011\u4f20\u5165\u53c2\u6570 tenantId={}\uff0cexecutionId={}\uff0ctaskId= {}\uff0ctaskName= {} ,processInstanceId= {}", new Object[]{n, string2, string5, extActProcessNodeDeployment.getProcessNodeName(), string4});
            this.sendMessage(extActProcess, delegateExecution, extActProcessNodeDeployment, string2, string3, string5, string6, n);
        }
    }

    private void sendMessage(ExtActProcess extActProcess, DelegateExecution delegateExecution, ExtActProcessNodeDeployment extActProcessNode, String executionId, String processInstanceId, String activityId, String taskDefKey, Integer tenantId) {
        String string;
        if (ObjectUtils.isNotEmpty((Object)extActProcessNode) && StringUtil.isNotEmpty((String)(string = extActProcessNode.getNodeConfigJson()))) {
            log.debug("-----\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011--------\u6d88\u606f\u53d1\u9001\u914d\u7f6enodeConfig:{}--------------", (Object)string);
            ChildAttr childAttr = (ChildAttr)JSON.parseObject((String)string, ChildAttr.class);
            String string2 = childAttr.getType();
            String string3 = childAttr.getTemplateContext();
            String string4 = childAttr.getJsonContext();
            Map<String, Object> map = this.getData(delegateExecution, string2, tenantId, processInstanceId, activityId, taskDefKey);
            log.debug("\u6a21\u677f\u89e3\u6790\uff0c\u539f\u59cb\u7684templateContext = {}", (Object)string3);
            log.debug("\u6a21\u677f\u89e3\u6790\uff0c\u6570\u636e\u5bf9\u8c61 data = {}", map);
            string3 = this.messagePushService.parseContent(extActProcess, string3, string4, map, processInstanceId, executionId);
            log.debug("\u6a21\u677f\u89e3\u6790\uff0c\u89e3\u6790\u540e\u7684templateContext = {}", (Object)string3);
            String string5 = childAttr.getTitle();
            String[] stringArray = childAttr.getToUserIds();
            MessageDTO messageDTO = new MessageDTO();
            HashSet<String> hashSet = new HashSet<String>();
            String string6 = this.getToUsers(stringArray, executionId, processInstanceId, hashSet);
            if (string6 == null) {
                log.error("\u6d88\u606f\u63a5\u6536\u4eba\u4e3a\u7a7a\uff01");
                messageDTO.setToAll(Boolean.valueOf(true));
            } else {
                messageDTO.setToAll(Boolean.valueOf(false));
                messageDTO.setToUser(string6);
                messageDTO.setToEmailList(hashSet);
            }
            if (oConvertUtils.isEmpty((Object)string6) && hashSet.size() == 0) {
                this.sendHandleExceptionMsg(extActProcess, extActProcessNode, processInstanceId, executionId);
                return;
            }
            HashSet<String> hashSet2 = new HashSet<String>();
            String[] stringArray2 = childAttr.getCopyToUserIds();
            String string7 = this.getToUsers(stringArray2, executionId, processInstanceId, hashSet2);
            if (string7 != null) {
                messageDTO.setCopyToUser(string7);
                messageDTO.setCcEmailList(hashSet2);
            }
            messageDTO.setTitle(string5);
            map.put("NOTICE_MSG_BUS_TYPE", Vue3MessageHrefEnum.BPM_SYSTEM_MSG.getBusType());
            messageDTO.setType(string2);
            messageDTO.setIsMarkdown(true);
            messageDTO.setFromUser("system");
            messageDTO.setContent(string3);
            messageDTO.setData(map);
            cachedThreadPool.execute(() -> {
                log.debug("-------\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011-----\u8fdb\u5165\u5f02\u6b65\u63a8\u9001-----------Begin---");
                log.info("------\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011------\u5f02\u6b65\u6d88\u606f\u53d1\u9001\u5bf9\u8c61 : {} ", (Object)JSON.toJSONString((Object)messageDTO));
                TenantContext.setTenant((String)oConvertUtils.getString((Object)tenantId));
                this.baseApi.sendTemplateMessage(messageDTO);
                log.debug("-------\u3010\u6d88\u606f\u901a\u77e5\u8282\u70b9\u3011-----\u5f02\u6b65\u63a8\u9001\u7ed3\u675f-----------End---");
            });
        }
    }

    private String getToUsers(String[] toUserIds, String executionId, String processInstanceId, Set<String> emailList) {
        List list;
        if (toUserIds == null || toUserIds.length == 0) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashSet hashSet2 = new HashSet();
        String[] stringArray = toUserIds;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            Object object;
            Object object2;
            String string = stringArray[j];
            if (string.startsWith("var.")) {
                List<String> list2;
                object2 = string.replace("var.", "");
                object = JSON.parseObject((String)object2);
                String string2 = object.getString("fieldType");
                Object object3 = this.messagePushService.getValueByJsonObject((JSONObject)object, executionId, processInstanceId);
                if (object3 == null) continue;
                if ("select-user".equals(string2)) {
                    list2 = this.messagePushService.getListValue(object3);
                    if (list2.size() <= 0) continue;
                    hashSet.addAll(list2);
                    continue;
                }
                if ("select-depart".equals(string2)) {
                    list2 = this.messagePushService.getListValue(object3);
                    if (list2.size() <= 0) continue;
                    arrayList2.addAll(list2);
                    continue;
                }
                if ("org-role".equals(string2)) {
                    list2 = this.messagePushService.getListValue(object3);
                    if (list2.size() <= 0) continue;
                    arrayList.addAll(list2);
                    continue;
                }
                if (!"email".equals(string2) || (list2 = this.messagePushService.getListValue(object3)).size() <= 0) continue;
                hashSet.add("_email");
                for (String string3 : list2) {
                    emailList.add(string3);
                }
                continue;
            }
            object2 = string.split("\\.");
            object = object2[0];
            if ("user".equals(object)) {
                hashSet.add(object2[1]);
                continue;
            }
            if ("role".equals(object)) {
                arrayList.add(object2[1]);
                continue;
            }
            if ("dept".equals(object)) {
                arrayList2.add(object2[1]);
                continue;
            }
            hashSet.add((String)object);
        }
        if (arrayList.size() > 0) {
            stringArray = this.baseApi.queryUserIdsByRoleds(arrayList);
            hashSet2.addAll(stringArray);
        }
        if (arrayList2.size() > 0) {
            stringArray = this.baseApi.queryUserIdsByDeptIds(arrayList2);
            hashSet2.addAll(stringArray);
        }
        if (hashSet2.size() > 0 && (list = this.baseApi.queryAllUserByIds(stringArray = hashSet2.toArray(new String[hashSet2.size()]))) != null && list.size() > 0) {
            for (String string : list) {
                hashSet.add(string.getUsername());
            }
        }
        if (hashSet.size() > 0) {
            stringArray = String.join((CharSequence)",", hashSet);
            return stringArray;
        }
        return null;
    }

    private Map<String, Object> getData(DelegateExecution delegateExecution, String type, Integer tenantId, String processInstanceId, String activityId, String taskDefKey) {
        Object object;
        String string;
        ExecutionEntity executionEntity = (ExecutionEntity)delegateExecution;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        Map map = delegateExecution.getVariableInstances();
        if (ObjectUtils.isNotEmpty((Object)map)) {
            for (Map.Entry object22 : map.entrySet()) {
                String string2;
                string = (String)object22.getKey();
                object = (VariableInstance)object22.getValue();
                if (!ObjectUtils.isNotEmpty((Object)object) || !StringUtil.isNotEmpty((String)(string2 = object.getTextValue()))) continue;
                hashMap.put(string, string2);
            }
        }
        String string3 = executionEntity.getProcessInstance().getProcessDefinitionName();
        String string4 = executionEntity.getCurrentFlowElement().getName();
        hashMap.put("_FW_NODE_NAME", string4);
        hashMap.put("_FW_NAME", string3);
        hashMap.put("_FW_MOBILE_URL", this.messagePushService.getDDMobileHrefUrl(processInstanceId, activityId, taskDefKey, tenantId));
        hashMap.put("_FW_TITLE", executionEntity.getVariable("bpm_biz_title"));
        hashMap.put("NOTICE_MSG_SUMMARY", this.messagePushService.getFormDetailRouteInfo(executionEntity));
        if (!MessageTypeEnum.XT.getType().equals(type)) {
            hashMap.put("NOTICE_MSG_BUS_ID", executionEntity.getId());
        }
        string = "";
        if (TaskTipTypeEnum.YJ.getType().equals(type)) {
            string = this.messagePushService.getEmailHrefUrl(hashMap);
        }
        if (TaskTipTypeEnum.DD.getType().equals(type)) {
            string = this.messagePushService.getAppHrefUrl(hashMap);
            object = this.messagePushService.getDDMobileHrefUrl(processInstanceId, activityId, taskDefKey, tenantId);
            hashMap.put("_FW_MOBILE_URL", object);
        }
        if (TaskTipTypeEnum.QYWX.getType().equals(type)) {
            string = this.messagePushService.getAppHrefUrl(hashMap);
        }
        hashMap.put("_FW_URL", string);
        return hashMap;
    }

    public String[] getUserIds(String toUserExpression, String executionId, String processInstanceId) {
        if (StringUtils.isNotEmpty((CharSequence)toUserExpression)) {
            JSONObject jSONObject = JSONObject.parseObject((String)toUserExpression);
            Object object = this.messagePushService.getValueByJsonObject(jSONObject, executionId, processInstanceId);
            if (object == null) {
                return null;
            }
            if (object instanceof JSONArray) {
                if (ObjectUtils.isNotEmpty((Object)object)) {
                    JSONArray jSONArray = (JSONArray)object;
                    List list = jSONArray.toJavaList(String.class);
                    return (String[])ArrayUtil.toArray((Collection)list, String.class);
                }
            } else if (object instanceof String) {
                return object.toString().split(",");
            }
        }
        return null;
    }

    public void sendHandleExceptionMsg(ExtActProcess extActProcess, ExtActProcessNodeDeployment extActProcessNode, String processInstanceId, String executeId) {
        JSONObject jSONObject;
        JSONArray jSONArray;
        String string = extActProcess.getErrorNoticeUserIds();
        if (oConvertUtils.isNotEmpty((Object)string) && (jSONArray = (jSONObject = JSONObject.parseObject((String)string)).getJSONArray("toUserIds")).size() > 0) {
            Object object;
            String string2 = this.getErrorNodeToUsers(jSONArray);
            String string3 = extActProcess.getProcessKey() + extActProcessNode.getId() + "_nodeError";
            log.info("redisKey:" + string3);
            boolean bl = false;
            String string4 = extActProcess.getErrorNoticeRepeat();
            long l = 0L;
            if (oConvertUtils.isEmpty((Object)string4) || "0".equals(string4)) {
                bl = true;
            } else {
                object = this.redisUtil.get(string3);
                if (object == null) {
                    bl = true;
                }
                l = (long)Integer.parseInt(string4) * 60L;
            }
            object = "\u3010\u6d41\u7a0b\u9519\u8bef\u3011\u5728\u6d41\u7a0b\u201c" + extActProcess.getProcessName() + "\u201d\u4e2d\uff0c\u8282\u70b9\u201c" + extActProcessNode.getProcessNodeName() + "\u201d\u4e2d\uff0c\u6d88\u606f/\u90ae\u4ef6\u63a5\u6536\u4eba\u65e0\u6548\uff0c\u6d41\u7a0b\u65e0\u6cd5\u7ee7\u7eed\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u63a5\u6536\u4eba\uff01";
            if (bl) {
                MessageDTO messageDTO = new MessageDTO();
                messageDTO.setType(MessageTypeEnum.XT.getType());
                messageDTO.setToAll(Boolean.valueOf(false));
                messageDTO.setToUser(string2);
                messageDTO.setTitle("\u3010\u6d41\u7a0b\u9519\u8bef\u3011");
                messageDTO.setFromUser("system");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("NOTICE_MSG_BUS_TYPE", "msg_node");
                messageDTO.setData(hashMap);
                messageDTO.setContent((String)object);
                this.baseApi.sendTemplateMessage(messageDTO);
                if (l > 0L) {
                    this.redisUtil.set(string3, (Object)1, l);
                }
            } else {
                log.error((String)object);
            }
            this.processUtils.stopProcessInstanceById(processInstanceId, executeId);
        }
    }

    private String getErrorNodeToUsers(JSONArray userArray) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashSet hashSet2 = new HashSet();
        String[] stringArray = userArray.iterator();
        while (stringArray.hasNext()) {
            object = stringArray.next();
            String string = object.toString();
            UserAccountInfo userAccountInfo = string.split("\\.");
            String string2 = userAccountInfo[0];
            if ("user".equals(string2)) {
                hashSet.add(userAccountInfo[1]);
                continue;
            }
            if ("role".equals(string2)) {
                arrayList.add(userAccountInfo[1]);
                continue;
            }
            if ("dept".equals(string2)) {
                arrayList2.add(userAccountInfo[1]);
                continue;
            }
            hashSet.add(string2);
        }
        if (arrayList.size() > 0) {
            stringArray = this.baseApi.queryUserIdsByRoleds(arrayList);
            hashSet2.addAll(stringArray);
        }
        if (arrayList2.size() > 0) {
            stringArray = this.baseApi.queryUserIdsByDeptIds(arrayList2);
            hashSet2.addAll(stringArray);
        }
        if (hashSet2.size() > 0 && (object = this.baseApi.queryAllUserByIds(stringArray = hashSet2.toArray(new String[hashSet2.size()]))) != null && object.size() > 0) {
            for (UserAccountInfo userAccountInfo : object) {
                hashSet.add(userAccountInfo.getUsername());
            }
        }
        if (hashSet.size() > 0) {
            stringArray = String.join((CharSequence)",", hashSet);
            return stringArray;
        }
        return null;
    }
}

