/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.config.vo.DomainUrl;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.entity.ExtActProcess;
import org.jeecg.modules.extbpm.process.entity.ExtActProcessNodeDeployment;
import org.jeecg.modules.joa.util.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="messageDelegate")
public class MessageDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(MessageDelegate.class);
    private JeecgBaseConfig jeecgBaseConfig;
    public static final String PC_TOKEN_LOGIN_PAGE = "/tokenLogin";
    public static ExecutorService cachedThreadPool = new ThreadPoolExecutor(0, 1024, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    public void execute(DelegateExecution delegateExecution) {
        ExecutionEntity executionEntity = (ExecutionEntity)delegateExecution;
        String string = executionEntity.getProcessDefinitionKey();
        ProcessUtils processUtils = (ProcessUtils)SpringContextUtils.getBean((String)"processUtils");
        ExtActProcess extActProcess = processUtils.getExtActProcessByProcessKey(string);
        if (ObjectUtils.isNotEmpty((Object)extActProcess)) {
            String string2 = extActProcess.getId();
            String string3 = executionEntity.getActivityId();
            ExtActProcessNodeDeployment extActProcessNodeDeployment = processUtils.getExtActProcessNodeDeployment(string2, string3);
            log.info("------------\u5f00\u59cb\u53d1\u9001\u6d88\u606f--------------");
            this.sendMessage(delegateExecution, extActProcessNodeDeployment);
            log.info("------------\u6d88\u606f\u53d1\u9001\u7ed3\u675f--------------");
        }
    }

    private void sendMessage(DelegateExecution delegateExecution, ExtActProcessNodeDeployment extActProcessNode) {
        String string;
        ISysBaseAPI iSysBaseAPI = (ISysBaseAPI)SpringContextUtils.getBean(ISysBaseAPI.class);
        Map<String, Object> map = this.getData(delegateExecution);
        if (ObjectUtils.isNotEmpty((Object)extActProcessNode) && StringUtils.isNotEmpty((CharSequence)(string = extActProcessNode.getNodeConfigJson()))) {
            log.info("------------\u6d88\u606f\u53d1\u9001\u914d\u7f6enodeConfig:{}--------------", (Object)string);
            ChildAttr childAttr = (ChildAttr)JSON.parseObject((String)string, ChildAttr.class);
            String string2 = childAttr.getType();
            String string3 = childAttr.getTemplateContext();
            string3 = this.parseContent(string3, map);
            String string4 = childAttr.getTitle();
            CharSequence[] charSequenceArray = childAttr.getToUserIds();
            CharSequence[] charSequenceArray2 = childAttr.getCopyToUserIds();
            MessageDTO messageDTO = new MessageDTO();
            if (ObjectUtils.isEmpty((Object)charSequenceArray)) {
                messageDTO.setToAll(Boolean.valueOf(true));
            } else {
                messageDTO.setToAll(Boolean.valueOf(false));
                messageDTO.setToUser(String.join((CharSequence)",", charSequenceArray));
            }
            if (ObjectUtils.isNotEmpty((Object)charSequenceArray2)) {
                messageDTO.setCopyToUser(String.join((CharSequence)",", charSequenceArray2));
            }
            messageDTO.setTitle(string4);
            messageDTO.setType(string2);
            messageDTO.setIsMarkdown(true);
            messageDTO.setFromUser("system");
            messageDTO.setContent(string3);
            messageDTO.setData(map);
            log.info("------------\u6d88\u606f\u53d1\u9001\u5bf9\u8c61:{}--------------", (Object)JSON.toJSONString((Object)messageDTO));
            iSysBaseAPI.sendTemplateMessage(messageDTO);
        }
    }

    private String parseContent(String templateContext, Map<String, Object> dataMap) {
        if (ObjectUtils.isNotEmpty(dataMap)) {
            for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                String string = entry.getKey();
                Object object = entry.getValue();
                if (ObjectUtils.isNotEmpty((Object)object)) {
                    templateContext = templateContext.replace("${" + string + "}", object.toString());
                    continue;
                }
                templateContext = templateContext.replace("${" + string + "}", "");
            }
        }
        return templateContext;
    }

    private Map<String, Object> getData(DelegateExecution delegateExecution) {
        String string;
        ExecutionEntity executionEntity = (ExecutionEntity)delegateExecution;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        Map map = delegateExecution.getVariableInstances();
        if (ObjectUtils.isNotEmpty((Object)map)) {
            for (Map.Entry object2 : map.entrySet()) {
                String string2;
                string = (String)object2.getKey();
                VariableInstance variableInstance = (VariableInstance)object2.getValue();
                if (!ObjectUtils.isNotEmpty((Object)variableInstance) || !StringUtils.isNotEmpty((CharSequence)(string2 = variableInstance.getTextValue()))) continue;
                hashMap.put(string, string2);
            }
        }
        String string3 = executionEntity.getProcessDefinitionName();
        String string4 = executionEntity.getCurrentFlowElement().getName();
        hashMap.put("_fw_node_name", string4);
        hashMap.put("_fw_name", string3);
        hashMap.put("_fw_title", executionEntity.getVariable("bpm_biz_title"));
        hashMap.put("NOTICE_MSG_SUMMARY", this.getRouteInfo(executionEntity));
        hashMap.put("NOTICE_MSG_BUS_ID", executionEntity.getId());
        string = this.getEmailHrefUrl(hashMap);
        hashMap.put("_fw_url", string);
        return hashMap;
    }

    private String getEmailHrefUrl(Map<String, Object> data) {
        String string = this.getPcDomainUrl();
        String string2 = string + PC_TOKEN_LOGIN_PAGE;
        try {
            string2 = string2 + "?loginToken={LOGIN_TOKEN}";
            Object object = data.get("NOTICE_MSG_SUMMARY");
            if (object != null) {
                string2 = string2 + "&info=" + URLEncoder.encode(object.toString(), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    private String getPcDomainUrl() {
        DomainUrl domainUrl;
        if (this.jeecgBaseConfig == null) {
            this.jeecgBaseConfig = (JeecgBaseConfig)SpringContextUtils.getBean(JeecgBaseConfig.class);
        }
        if ((domainUrl = this.jeecgBaseConfig.getDomainUrl()) == null || oConvertUtils.isEmpty((Object)domainUrl.getPc())) {
            log.error("\u7f3a\u5c11\u914d\u7f6e\uff1ajeecg.domainUrl.pc\uff01");
            return "";
        }
        return domainUrl.getPc();
    }

    private String getRouteInfo(ExecutionEntity executionEntity) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("taskId", (Object)executionEntity.getActivityId());
        jSONObject.put("procInsId", (Object)executionEntity.getProcessInstanceId());
        jSONObject.put("taskDetail", (Object)true);
        return jSONObject.toJSONString();
    }
}

