/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate.datahandle.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.query.QueryCondition;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.config.vo.DomainUrl;
import org.jeecg.modules.extbpm.process.adapter.mq.utils.MinFlowUtils;
import org.jeecg.modules.extbpm.process.common.WorkFlowGlobals;
import org.jeecg.modules.extbpm.process.entity.ExtActProcess;
import org.jeecg.modules.minides.enums.FormTableTypeEnums;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="messagePushService")
public class MessagePushService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagePushService.class);
    @Autowired
    private JeecgBaseConfig jeecgBaseConfig;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private IDesignFormDataService designFormDataService;
    @Autowired
    private ISysBaseAPI baseApi;
    public static final String APP_FLOW_PAGE = "/pages/process/my-task-detail";
    public static final String PC_TOKEN_LOGIN_PAGE = "/tokenLogin";

    public String getEmailHrefUrl(Map<String, Object> data) {
        String domain = this.getPcDomainUrl();
        String url = domain + PC_TOKEN_LOGIN_PAGE;
        try {
            url = url + "?loginToken={LOGIN_TOKEN}";
            Object msgAbstract = data.get("NOTICE_MSG_SUMMARY");
            if (msgAbstract != null) {
                url = url + "&info=" + URLEncoder.encode(msgAbstract.toString(), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        return url;
    }

    public String getDDMobileHrefUrl(String processInstanceId, String activityId, String taskDefKey, Integer tenantId) {
        String url = this.getAppDomainUrl() + "/pages/lowApp/process/taskDetail?tenantId={0}&procInsId={1}&taskId={2}&taskDefKey={3}";
        return MessageFormat.format(url, tenantId.toString(), processInstanceId, activityId, taskDefKey);
    }

    public String getAppHrefUrl(Map<String, Object> data) {
        String domain = this.getAppDomainUrl();
        if (domain != null) {
            String url = domain + APP_FLOW_PAGE;
            Object msgAbstract = data.get("NOTICE_MSG_SUMMARY");
            if (msgAbstract != null) {
                try {
                    url = url + "?info=" + URLEncoder.encode(msgAbstract.toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException e2) {
                    log.error("\u53c2\u6570\u52a0\u5bc6\u9519\u8bef", (Throwable)e2);
                }
            }
            return url;
        }
        return "";
    }

    public String getPcDomainUrl() {
        DomainUrl domain = this.jeecgBaseConfig.getDomainUrl();
        if (domain == null || oConvertUtils.isEmpty((Object)domain.getPc())) {
            log.error("\u7f3a\u5c11\u914d\u7f6e\uff1ajeecg.domainUrl.pc\uff01");
            return "";
        }
        return domain.getPc();
    }

    public String getAppDomainUrl() {
        DomainUrl domain;
        if (this.jeecgBaseConfig == null) {
            this.jeecgBaseConfig = (JeecgBaseConfig)SpringContextUtils.getBean(JeecgBaseConfig.class);
        }
        if ((domain = this.jeecgBaseConfig.getDomainUrl()) == null || oConvertUtils.isEmpty((Object)domain.getApp())) {
            log.error("\u7f3a\u5c11\u914d\u7f6e\uff1ajeecg.domainUrl.app!");
            return "";
        }
        return domain.getApp();
    }

    public String getFormDetailRouteInfo(ExecutionEntity executionEntity) {
        JSONObject msgAbstract = new JSONObject();
        msgAbstract.put("taskId", (Object)executionEntity.getActivityId());
        msgAbstract.put("procInsId", (Object)executionEntity.getProcessInstanceId());
        msgAbstract.put("taskDetail", (Object)true);
        return msgAbstract.toJSONString();
    }

    public String parseContent(ExtActProcess extActProcess, String templateContext, String jsonContext, Map<String, Object> dataMap, String processInstanceId, String executionId) {
        if (ObjectUtils.isNotEmpty(dataMap)) {
            JSONObject jsonObject = JSONObject.parseObject((String)jsonContext);
            return this.replaceCondition(extActProcess, templateContext, jsonObject, dataMap, processInstanceId, executionId);
        }
        return "";
    }

    private String replaceCondition(ExtActProcess extActProcess, String conditionValue, JSONObject jsonObject, Map<String, Object> dataMap, String processInstanceId, String executionId) {
        String text = conditionValue;
        if (text.contains("{{")) {
            String conditionText = text.substring(text.indexOf("{{"), text.indexOf("}}") + 2);
            String objText = conditionText.replace("{{", "").replace("}}", "");
            if (ObjectUtils.isNotEmpty((Object)objText)) {
                Object value = this.getValue(extActProcess, objText, jsonObject, dataMap, processInstanceId, executionId);
                text = ObjectUtils.isNotEmpty((Object)value) ? text.replace(conditionText, value.toString()) : text.replace(conditionText, "");
            }
            text = this.replaceCondition(extActProcess, text, jsonObject, dataMap, processInstanceId, executionId);
        }
        return text;
    }

    public Object getValue(ExtActProcess extActProcess, String objText, JSONObject jsonContext, Map<String, Object> dataMap, String processInstanceId, String executionId) {
        String[] obj = objText.split("\\.");
        if (ObjectUtils.isNotEmpty((Object)obj)) {
            String key = obj[0];
            if (key.contains("_FW_")) {
                for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                    String name = entry.getKey();
                    if (!name.equals(key)) continue;
                    return entry.getValue();
                }
            } else {
                try {
                    String jsonParams = jsonContext.getString(key);
                    String context = new String(Base64.getDecoder().decode(jsonParams), "utf-8");
                    JSONObject valueObj = JSONObject.parseObject((String)context);
                    MinFlowUtils.a(valueObj, extActProcess);
                    return this.getValueByJsonObject(valueObj, executionId, processInstanceId, true);
                }
                catch (Exception e2) {
                    log.warn("\u6d88\u606f\u6a21\u677f\u89e3\u6790\u5f02\u5e38\uff1a{}", (Object)e2.getMessage(), (Object)e2);
                }
            }
        }
        return null;
    }

    public Object getValueByJsonObject(JSONObject valueObj, String executionId, String processInstanceId) {
        return this.getValueByJsonObject(valueObj, executionId, processInstanceId, false);
    }

    public Object getValueByJsonObject(JSONObject valueObj, String executionId, String processInstanceId, boolean getDictText) {
        String formTableCode = valueObj.getString("formTableCode");
        String formNodeId = valueObj.getString("nodeId");
        String variableValue = valueObj.getString("field");
        String formNodeType = valueObj.getString("nodeType");
        if (StringUtils.isNotEmpty((CharSequence)formNodeType)) {
            String dataId;
            JSONObject user;
            String dataId2;
            String formDataSourceKey;
            Object object;
            DesignFormData designFormData = null;
            if (FormTableTypeEnums.getUserDeptRole.name().equals(formNodeType) && ObjectUtils.isNotEmpty((Object)(object = (JSONObject)this.runtimeService.getVariable(executionId, formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", processInstanceId, formNodeId), JSONObject.class)))) {
                return this.getJsonValue(getDictText, variableValue, (JSONObject)object);
            }
            if (FormTableTypeEnums.getMoreUserDeptRole.name().equals(formNodeType) && ObjectUtils.isEmpty(designFormData) && oConvertUtils.isNotEmpty((Object)(dataId2 = (String)this.runtimeService.getVariable(executionId, formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", processInstanceId, formNodeId), String.class)))) {
                if ("sys_user".equalsIgnoreCase(formTableCode)) {
                    JSONObject userJson = this.baseApi.queryUserById(dataId2);
                    if (userJson != null) {
                        String username;
                        List departIds;
                        if ("depart".equals(variableValue) && (departIds = this.baseApi.getDepartIdsByUsername(username = userJson.getString("username"))) != null && departIds.size() > 0) {
                            userJson.put("depart", (Object)oConvertUtils.list2JSONArray((List)departIds));
                        }
                        designFormData = new DesignFormData();
                        designFormData.setDesformData(userJson);
                    }
                } else if ("sys_depart".equalsIgnoreCase(formTableCode)) {
                    List departs = this.baseApi.queryDepartsByIds(dataId2);
                    if (departs != null && departs.size() > 0) {
                        designFormData = new DesignFormData();
                        designFormData.setDesformData((JSONObject)departs.get(0));
                    }
                } else if ("sys_role".equalsIgnoreCase(formTableCode)) {
                    ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
                    QueryCondition superQueryItem = new QueryCondition("id", "input", null, QueryRuleEnum.EQ.getValue(), dataId2);
                    conditions.add(superQueryItem);
                    try {
                        String superQueryParams = URLEncoder.encode(JSONObject.toJSONString(conditions), "UTF-8");
                        List roles = this.baseApi.queryRoleBySuperQuery(superQueryParams, "and");
                        if (roles != null && roles.size() > 0) {
                            designFormData = new DesignFormData();
                            designFormData.setDesformData((JSONObject)roles.get(0));
                        }
                    }
                    catch (UnsupportedEncodingException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            if (FormTableTypeEnums.userEvent.name().equals(formNodeType) && ObjectUtils.isNotEmpty((Object)(user = this.baseApi.queryUserById(dataId = (String)this.runtimeService.getVariable(executionId, WorkFlowGlobals.BPM_DATA_ID, String.class))))) {
                return this.getJsonValue(getDictText, variableValue, user);
            }
            if (FormTableTypeEnums.function.name().equals(formNodeType) && (object = this.runtimeService.getVariable(executionId, formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", processInstanceId, formNodeId))) != null) {
                return object.toString();
            }
            if (FormTableTypeEnums.table.name().equals(formNodeType)) {
                dataId = (String)this.runtimeService.getVariable(executionId, WorkFlowGlobals.BPM_DATA_ID, String.class);
                designFormData = this.designFormDataService.getDataWithDictText(formTableCode, dataId);
            }
            if (FormTableTypeEnums.search.name().equals(formNodeType)) {
                formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", processInstanceId, formNodeId);
                dataId2 = (String)this.runtimeService.getVariable(executionId, formDataSourceKey, String.class);
                designFormData = this.designFormDataService.getDataWithDictText(formTableCode, dataId2);
            }
            if (FormTableTypeEnums.plus.name().equals(formNodeType)) {
                formDataSourceKey = MessageFormat.format("flow:task:form_data:{0}:{1}", processInstanceId, formNodeId);
                dataId2 = (String)this.runtimeService.getVariable(executionId, formDataSourceKey, String.class);
                designFormData = this.designFormDataService.getDataWithDictText(formTableCode, dataId2);
            }
            if (ObjectUtils.isNotEmpty(designFormData)) {
                JSONObject sourceJsonObject = designFormData.getDesformData();
                return this.getJsonValue(getDictText, variableValue, sourceJsonObject);
            }
        }
        return null;
    }

    private Object getJsonValue(boolean getDictText, String variableValue, JSONObject sourceJsonObject) {
        if (getDictText) {
            String dictKey = variableValue + "_dictText";
            if (sourceJsonObject.containsKey((Object)dictKey)) {
                return sourceJsonObject.get((Object)dictKey);
            }
            return sourceJsonObject.get((Object)variableValue);
        }
        return sourceJsonObject.get((Object)variableValue);
    }

    public List<String> getListValue(Object value) {
        ArrayList<String> list = new ArrayList<String>();
        if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            for (int i2 = 0; i2 < array.size(); ++i2) {
                list.add(array.getString(i2));
            }
        } else {
            String str = value.toString();
            if (str.startsWith("[") && str.endsWith("]")) {
                JSONArray array = JSONArray.parseArray((String)str);
                for (int i3 = 0; i3 < array.size(); ++i3) {
                    list.add(array.getString(i3));
                }
            } else {
                String[] arr;
                for (String a2 : arr = str.split(",")) {
                    list.add(a2);
                }
            }
        }
        return list;
    }
}

