/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.process.adapter.delegate.datahandle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.adapter.d.f;
import org.jeecg.modules.extbpm.process.adapter.delegate.datahandle.base.BaseDataDelegate;
import org.jeecg.modules.extbpm.process.adapter.entity.ChildAttr;
import org.jeecg.modules.extbpm.process.common.WorkFlowGlobals;
import org.jeecg.modules.minides.enums.FormTableTypeEnums;
import org.jeecg.modules.minides.enums.GetDataTypeEnums;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.jeecg.modules.online.desform.vo.query.SuperQueryItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component(value="getMoreRecordDelegate")
public class GetMoreRecordDelegate
extends BaseDataDelegate
implements JavaDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetMoreRecordDelegate.class);

    public void execute(DelegateExecution delegateExecution) {
        log.info("---------\u8fdb\u5165\u83b7\u53d6\u591a\u6761\u8bb0\u5f55-\u670d\u52a1\u8282\u70b9 GetMoreRecordDelegate-----------");
        try {
            boolean init = this.init(delegateExecution);
            if (init) {
                List<DesignFormData> records = null;
                Integer selectType = this.childAttr.getSelectType();
                String formTableSourceTaskId = this.childAttr.getFormTableSourceTaskId();
                if (f.a.getType().equals(selectType)) {
                    records = this.queryFormDataBySuperQuery();
                }
                if (f.c.getType().equals(selectType)) {
                    String formDataSourceKey;
                    String formTableSourceNodeType = this.childAttr.getFormTableSourceNodeType();
                    String dataId = "";
                    if (FormTableTypeEnums.plus.name().equals(formTableSourceNodeType)) {
                        formDataSourceKey = MessageFormat.format("flow:task:form_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                        dataId = (String)delegateExecution.getVariable(formDataSourceKey, String.class);
                        records = this.getRecords(this.childAttr, dataId, null);
                    }
                    if (FormTableTypeEnums.table.name().equals(formTableSourceNodeType)) {
                        dataId = (String)delegateExecution.getVariable(WorkFlowGlobals.BPM_DATA_ID, String.class);
                        DesignFormData designFormData = this.getStartDesFormData(this.childAttr.getFormTableCode());
                        records = this.getRecords(this.childAttr, dataId, designFormData);
                    }
                    if (FormTableTypeEnums.search.name().equals(formTableSourceNodeType)) {
                        formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                        dataId = (String)delegateExecution.getVariable(formDataSourceKey, String.class);
                        records = this.getRecords(this.childAttr, dataId, null);
                    }
                    String mainFormTableKey = MessageFormat.format("flow:task:main_form_table_data:{0}:{1}", this.processInstanceId, this.activityId);
                    delegateExecution.setVariable(mainFormTableKey, (Object)dataId);
                }
                if (f.d.getType().equals(selectType)) {
                    String formDataSourceKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, formTableSourceTaskId);
                    records = this.queryRedisData(formDataSourceKey);
                }
                if (ObjectUtils.isNotEmpty(records)) {
                    Integer getDataType = this.childAttr.getGetDataType();
                    String processVariableKey = MessageFormat.format("flow:task:get_data:{0}:{1}", this.processInstanceId, this.activityId);
                    List dataIds = records.stream().map(DesignFormData::getId).collect(Collectors.toList());
                    dataIds = dataIds.stream().distinct().collect(Collectors.toList());
                    if (getDataType.equals(GetDataTypeEnums.from_redis.getType())) {
                        String redisFormDataKey = MessageFormat.format("flow:task:redis_get_data:{0}:{1}", this.processInstanceId, this.activityId);
                        this.redisUtil.set(redisFormDataKey, records);
                        log.info("========BEGIN=============================================================================================================");
                        log.info("---\u3010\u6d41\u7a0b\u6570\u636e\u8282\u70b9#\u83b7\u53d6\u591a\u6761\u8bb0\u5f55\uff0c\u8282\u70b9\u540d\u79f0\uff1a{}\u3011---------\u5b58\u50a8\u591a\u6761\u6570\u636e\u5230redis\u4e2d\uff0credisKey = {}, records size ={}", new Object[]{this.extActProcessNode.getProcessNodeName(), redisFormDataKey, records.size()});
                        for (DesignFormData data : records) {
                            log.info("--\u3010\u6d41\u7a0b\u6570\u636e\u8282\u70b9#\u83b7\u53d6\u591a\u6761\u8bb0\u5f55\uff0c\u8282\u70b9\u540d\u79f0\uff1a{}\u3011--- \u5b58\u50a8\u6570\u636e\u5230redis\u4e2d ====> id = {}, designFormData ={}", new Object[]{this.extActProcessNode.getProcessNodeName(), data.getId(), data.toString()});
                        }
                        log.info("=======END=============================================================================================================");
                        delegateExecution.setVariable(processVariableKey, (Object)redisFormDataKey);
                    }
                    if (getDataType.equals(GetDataTypeEnums.from_db.getType())) {
                        delegateExecution.setVariable(processVariableKey, dataIds);
                        log.info("---\u3010\u6d41\u7a0b\u6570\u636e\u8282\u70b9#\u83b7\u53d6\u591a\u6761\u8bb0\u5f55\uff0c\u8282\u70b9\u540d\u79f0\uff1a{}\u3011--------\u5b58\u50a8\u591a\u6761\u6570\u636eId\u5230\u6d41\u7a0b\u53d8\u91cf\u91cc\uff0cprocessVariableKey={}, dataIds = {}", new Object[]{this.extActProcessNode.getProcessNodeName(), processVariableKey, dataIds});
                    }
                    String inSubProcessDataIdsKey = MessageFormat.format("{0}_assigneeDataIdList", this.activityId);
                    delegateExecution.setVariable(inSubProcessDataIdsKey, (Object)StringUtils.join(dataIds, (String)","));
                }
            }
        }
        catch (Exception exception) {
            log.error("\u6d41\u7a0b\u9519\u8bef", (Throwable)exception);
            super.handleException(exception);
        }
    }

    private List<DesignFormData> getRecords(ChildAttr childAttr, String dataId, DesignFormData formData) {
        JSONArray jsonArray;
        JSONObject jsonObject;
        if (oConvertUtils.isEmpty((Object)dataId)) {
            log.warn("dataId must not be null!");
            return null;
        }
        List<Object> records = new ArrayList<DesignFormData>();
        String formTableCode = childAttr.getFormTableCode();
        String linkFormTableCode = childAttr.getLinkFormTableCode();
        String linkFormTableField = childAttr.getLinkFormTableField();
        DesignFormData designFormData = this.designFormDataService.getById(formTableCode, dataId);
        if (ObjectUtils.isEmpty((Object)designFormData)) {
            designFormData = formData;
        }
        if (ObjectUtils.isNotEmpty((Object)designFormData) && ObjectUtils.isNotEmpty((Object)(jsonObject = designFormData.getDesformData())) && ObjectUtils.isNotEmpty((Object)(jsonArray = jsonObject.getJSONArray(linkFormTableField)))) {
            Integer linkFormTableType = childAttr.getLinkFormTableType();
            if (ObjectUtils.isNotEmpty((Object)linkFormTableType) && linkFormTableType.equals(2)) {
                for (Object o : jsonArray) {
                    JSONObject obj = (JSONObject)o;
                    DesignFormData data = new DesignFormData();
                    String id = obj.getString("_id");
                    data.setDesformData(obj);
                    data.setId(id);
                    data.setDesformCode(linkFormTableCode);
                    records.add(data);
                }
            } else {
                List<OrderItem> orderItems;
                DesformSuperQuery desformSuperQuery = super.initFormSuperQuery();
                SuperQueryItem superQueryItem = new SuperQueryItem("", "_id", StringUtils.join((Iterable)jsonArray, (String)","), QueryRuleEnum.IN);
                desformSuperQuery.getQueryItems().add(superQueryItem);
                Page page = new Page();
                Long limitNum = ObjectUtils.isEmpty((Object)childAttr.getLimitNum()) ? 100L : childAttr.getLimitNum();
                if (ObjectUtils.isNotEmpty((Object)limitNum)) {
                    page.setSize(limitNum.longValue());
                }
                if (ObjectUtils.isNotEmpty(orderItems = GetMoreRecordDelegate.getQueryConditionOrders(childAttr))) {
                    page.setOrders(orderItems);
                }
                Result pageList = this.designFormDataService.pageList(linkFormTableCode, page, desformSuperQuery);
                IPage result = (IPage)pageList.getResult();
                records = result.getRecords();
            }
        }
        return records;
    }
}

