/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.flowable.engine.HistoryService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.b.a;
import org.jeecg.modules.extbpm.process.b.b;
import org.jeecg.modules.extbpm.process.mapper.ExtSystemOaMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="branchConditionGroupUtils")
public class BranchConditionGroupUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BranchConditionGroupUtils.class);
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ExtSystemOaMapper extSystemOaMapper;

    public List<org.jeecg.modules.extbpm.process.d.b> parseConditionInput(Object conditionInput) {
        if (conditionInput == null) {
            return Collections.emptyList();
        }
        try {
            if (conditionInput instanceof List) {
                return (List)conditionInput;
            }
            if (conditionInput instanceof String) {
                String input = (String)conditionInput;
                try {
                    byte[] decoded = Base64.getDecoder().decode(input);
                    String jsonStr = new String(decoded, StandardCharsets.UTF_8);
                    log.info("\u3010\u65b0\u5206\u652f\u8868\u8fbe\u5f0f\u3011Base64 \u89e3\u7801\u7ed3\u679c: {}", (Object)jsonStr);
                    ObjectMapper mapper = new ObjectMapper();
                    List rawGroups = (List)mapper.readValue(jsonStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                    return this.convertToConditionGroups(rawGroups);
                }
                catch (Exception e2) {
                    log.warn("Base64 \u89e3\u7801\u5931\u8d25\uff0c\u5c1d\u8bd5\u76f4\u63a5\u89e3\u6790 JSON: {}", (Object)e2.getMessage());
                    ObjectMapper mapper = new ObjectMapper();
                    List rawGroups = (List)mapper.readValue(input, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                    return this.convertToConditionGroups(rawGroups);
                }
            }
        }
        catch (Exception e3) {
            log.error("\u89e3\u6790\u6761\u4ef6\u8f93\u5165\u5931\u8d25", (Throwable)e3);
        }
        return Collections.emptyList();
    }

    public List<org.jeecg.modules.extbpm.process.d.b> convertToConditionGroups(List<Map<String, Object>> rawGroups) {
        ArrayList<org.jeecg.modules.extbpm.process.d.b> groups = new ArrayList<org.jeecg.modules.extbpm.process.d.b>();
        for (Map<String, Object> rawGroup : rawGroups) {
            String logic = (String)rawGroup.get("logic");
            List conditions = (List)rawGroup.get("conditions");
            org.jeecg.modules.extbpm.process.d.b group = new org.jeecg.modules.extbpm.process.d.b(logic != null ? logic : "and");
            if (conditions != null) {
                for (Map condMap : conditions) {
                    String operator = (String)condMap.get("operator");
                    String field = (String)condMap.get("field");
                    String expectedValue = String.valueOf(condMap.get("expectedValue"));
                    group.a(operator, field, null, expectedValue);
                }
            }
            groups.add(group);
        }
        return groups;
    }

    public boolean evaluateConditionGroup(DelegateExecution execution, org.jeecg.modules.extbpm.process.d.b group) {
        if (CollectionUtils.isEmpty(group.getConditions())) {
            return false;
        }
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        for (org.jeecg.modules.extbpm.process.d.a condition : group.getConditions()) {
            boolean result = this.evaluateSingleCondition(execution, condition);
            results.add(result);
            log.debug("\u6761\u4ef6 {}[{}] {} {} \u8bc4\u4f30\u7ed3\u679c: {}", new Object[]{condition.getField(), condition.getOperator(), condition.getActualValue(), condition.getExpectedValue(), result});
        }
        return this.combineResults(results, group.getLogic());
    }

    private boolean evaluateSingleCondition(DelegateExecution execution, org.jeecg.modules.extbpm.process.d.a condition) {
        String actualValue = this.getActualValue(execution, condition);
        return this.evaluateConditionByOperator(condition.getOperator(), actualValue, condition.getExpectedValue());
    }

    private String getActualValue(DelegateExecution execution, org.jeecg.modules.extbpm.process.d.a condition) {
        try {
            String fieldName = condition.getField();
            if (fieldName == null) {
                return null;
            }
            a fieldEnum = a.b(fieldName);
            if (fieldEnum != null) {
                return this.getValueByEnum(execution, fieldEnum);
            }
            return this.handleUnknownField(execution, fieldName);
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6\u5b57\u6bb5\u503c\u5f02\u5e38: {}", (Object)condition.getField(), (Object)e2);
            return null;
        }
    }

    private String getValueByEnum(DelegateExecution execution, a fieldEnum) {
        Object value = null;
        switch (3.a[fieldEnum.ordinal()]) {
            case 1: {
                value = execution.getVariable(fieldEnum.getVariableName());
                break;
            }
            case 2: {
                String applyUserId = oConvertUtils.getString((Object)execution.getVariable("applyUserId"));
                value = this.getUserPosts(applyUserId);
                break;
            }
            case 3: {
                String sysOrgCode = oConvertUtils.getString((Object)execution.getVariable(fieldEnum.getVariableName()));
                if (!oConvertUtils.isNotEmpty((Object)sysOrgCode)) break;
                value = this.extSystemOaMapper.getDepId(sysOrgCode);
                break;
            }
            case 4: {
                value = execution.getVariable(fieldEnum.getVariableName());
                break;
            }
            case 5: {
                return this.getLastAssigneeValue(execution);
            }
            default: {
                value = execution.getVariable(fieldEnum.getVariableName());
            }
        }
        return value != null ? String.valueOf(value) : null;
    }

    private String getLastAssigneeValue(DelegateExecution execution) {
        try {
            List tasks = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(execution.getProcessInstanceId())).finished().orderByHistoricTaskInstanceEndTime().desc()).list();
            if (tasks != null && tasks.size() > 0) {
                return ((HistoricTaskInstance)tasks.get(0)).getAssignee();
            }
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6\u4e0a\u4e2a\u8282\u70b9\u5904\u7406\u4eba\u5f02\u5e38", (Throwable)e2);
        }
        return null;
    }

    private String handleUnknownField(DelegateExecution execution, String fieldName) {
        Object value = execution.getVariable(fieldName);
        return value != null ? String.valueOf(value) : null;
    }

    private boolean evaluateConditionByOperator(String operator, String actualValue, String expectedValue) {
        try {
            if (operator == null) {
                return false;
            }
            b operatorEnum = b.b(operator);
            if (operatorEnum == null) {
                log.warn("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7b26: {}", (Object)operator);
                return false;
            }
            if (operatorEnum.c()) {
                if (operatorEnum == b.k) {
                    return actualValue == null || actualValue.trim().isEmpty();
                }
                if (operatorEnum == b.l) {
                    return actualValue != null && !actualValue.trim().isEmpty();
                }
            }
            if (operatorEnum.d()) {
                if (operatorEnum == b.m) {
                    return this.isDepartmentManager(actualValue);
                }
                if (operatorEnum == b.n) {
                    return !this.isDepartmentManager(actualValue);
                }
            }
            if (operatorEnum.b() && (actualValue == null || expectedValue == null)) {
                return false;
            }
            switch (3.b[operatorEnum.ordinal()]) {
                case 1: {
                    return expectedValue.equals(actualValue);
                }
                case 2: {
                    return !expectedValue.equals(actualValue);
                }
                case 3: {
                    return this.compareNumericOrDate(actualValue, expectedValue) > 0;
                }
                case 4: {
                    return this.compareNumericOrDate(actualValue, expectedValue) >= 0;
                }
                case 5: {
                    return this.compareNumericOrDate(actualValue, expectedValue) < 0;
                }
                case 6: {
                    return this.compareNumericOrDate(actualValue, expectedValue) <= 0;
                }
                case 7: {
                    return Arrays.asList(expectedValue.split("[,\uff0c]")).contains(actualValue);
                }
                case 8: {
                    return !Arrays.asList(expectedValue.split("[,\uff0c]")).contains(actualValue);
                }
                case 9: {
                    return this.evaluateContains(actualValue, expectedValue);
                }
                case 10: {
                    return !this.evaluateContains(actualValue, expectedValue);
                }
            }
            log.warn("\u672a\u5904\u7406\u7684\u64cd\u4f5c\u7b26: {}", (Object)operatorEnum);
            return false;
        }
        catch (Exception e2) {
            log.error("\u6761\u4ef6\u8bc4\u4f30\u5f02\u5e38: operator={}, actualValue={}, expectedValue={}", new Object[]{operator, actualValue, expectedValue, e2});
            return false;
        }
    }

    private boolean evaluateContains(String actualValue, String expectedValue) {
        if (actualValue == null || expectedValue == null) {
            return false;
        }
        try {
            if (actualValue.startsWith("[") && actualValue.endsWith("]")) {
                String listContent = actualValue.substring(1, actualValue.length() - 1);
                if (!listContent.trim().isEmpty()) {
                    String[] items;
                    for (String item : items = listContent.split("[,\uff0c]")) {
                        if (!item.trim().equals(expectedValue.trim())) continue;
                        return true;
                    }
                }
                return false;
            }
            if (actualValue.contains(",")) {
                String[] items;
                for (String item : items = actualValue.split("[,\uff0c]")) {
                    if (!item.trim().equals(expectedValue.trim())) continue;
                    return true;
                }
                return false;
            }
            return actualValue.contains(expectedValue);
        }
        catch (Exception e2) {
            log.warn("\u5305\u542b\u5173\u7cfb\u8bc4\u4f30\u5f02\u5e38: actualValue={}, expectedValue={}", new Object[]{actualValue, expectedValue, e2});
            return actualValue.contains(expectedValue);
        }
    }

    private int compareNumericOrDate(String actualValue, String expectedValue) {
        try {
            BigDecimal actual = new BigDecimal(actualValue);
            BigDecimal expected = new BigDecimal(expectedValue);
            return actual.compareTo(expected);
        }
        catch (NumberFormatException e2) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date actualDate = sdf.parse(actualValue);
                Date expectedDate = sdf.parse(expectedValue);
                return actualDate.compareTo(expectedDate);
            }
            catch (Exception ex) {
                return actualValue.compareTo(expectedValue);
            }
        }
    }

    public boolean combineResults(List<Boolean> results, String logic) {
        if (CollectionUtils.isEmpty(results)) {
            return false;
        }
        if ("or".equalsIgnoreCase(logic)) {
            return results.stream().anyMatch(Boolean::booleanValue);
        }
        return results.stream().allMatch(Boolean::booleanValue);
    }

    private boolean isDepartmentManager(String userId) {
        if (userId == null || userId.trim().isEmpty()) {
            return false;
        }
        try {
            boolean isManager = this.extSystemOaMapper.isDepartmentManager(userId);
            log.debug("\u5224\u65ad\u7528\u6237 {} \u662f\u5426\u4e3a\u90e8\u95e8\u8d1f\u8d23\u4eba: {}", (Object)userId, (Object)isManager);
            return isManager;
        }
        catch (Exception e2) {
            log.error("\u5224\u65ad\u90e8\u95e8\u8d1f\u8d23\u4eba\u5f02\u5e38: userId={}", (Object)userId, (Object)e2);
            return false;
        }
    }

    private Set<String> getUserPosts(String applyId) {
        try {
            if (applyId == null) {
                return null;
            }
            return this.extSystemOaMapper.getUserPositionIdsByUsername(applyId);
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6\u7528\u6237\u4e3b\u5c97\u4f4d\u548c\u517c\u804c\u5c97\u4f4d\u7684\u804c\u52a1\uff01\u5f02\u5e38: applyId={}", (Object)applyId, (Object)e2);
            return null;
        }
    }
}

