function getUrl(url){
    return `${baseFull}/drag` + url;
}
function getJimubiUrl(url){
    return `${baseFull}/jimubi` + url;
}
//拼接待tokenurl
function getHasTokenUrl(url, id){
    if (id){
        return `${baseFull}/drag${url}/${id}?token=${token}`;
    }else{
        return `${baseFull}/drag${url}?token=${token}`;
    }
}
//拼接待域名url
function getOrigin(url){
    return `${baseFull}/drag` + url;
}

const api = {
    //首页
    index: getJimubiUrl('/index'),
    //预览界面
    view: getJimubiUrl('/view'),
    //预览界面
    shareView: getJimubiUrl('/share/view'),
    //查询用户名
    getLoginUser: getUrl('/onlDragDatasetHead/getLoginUser'),
    //查询仪表盘
    queryPageList: getUrl('/page/list'),
    //查询模版仪表盘
    queryTemplateList: getUrl('/page/queryTemplateList'),
    //仪表盘预览
    show: getOrigin('/show'),
    //删除仪表盘
    deleteDrag: getUrl('/page/delete'),
    //彻底删除仪表盘
    physicalDeleteDrag: getUrl('/page/physicalDelete'),
    //还原删除的仪表盘
    clearRecoveryDrag: getUrl('/page/clearRecovery'),
    //还原删除的仪表盘
    recoveryDeleteDrag: getUrl('/page/recoveryDelete'),
    //图表复制
    dragCopy: getUrl('/page/copyPage'),
    //设置模版
    setTemplate: getUrl('/page/edit'),
    //新增和编辑仪表盘
    add: getUrl('/page/add'),
    edit: getUrl('/page/edit'),

    //-----目录相关接口begin-------------------------
    //查询目录api接口
    categoryList: getUrl('/category/list'),
    //编辑目录api接口
    editCategoryTree: getUrl('/category/edit'),
    //清除回收站
    clearRecovery: getUrl('/category/clearRecovery'),
    //保存目录
    saveCategoryTree: getUrl('/category/add'),
    //查询一个
    getCategoryById: getUrl('/category/getById'),
    //删除
    deleteCategoryTree: getUrl('/category/deleteById'),
    //查询回收站列表
    queryRecycleList: getUrl('/category/queryRecycleList'),
    //还原文件夹
    recoveryCategory: getUrl('/category/reductionById'),
    //删除文件夹
    physicalDeleteCategory: getUrl('/category/physicalDelete'),
    //查询目录数量
    queryRecycleCount: getUrl('/category/queryRecycleCount'),
    //查询目录和仪表盘数量根据ID
    queryCountById: getUrl('/category/queryCountById'),
    //-----目录相关接口end-------------------------

    //分享-根据id查询
    getShareByPageId: getUrl('/onlDragShare/getByPageId'),
    //分享-编辑
    shareEdit: getUrl('/onlDragShare/edit'),
    //分享-保存
    shareAdd: getUrl('/onlDragShare/add'),
    //分享-保存
    folderSort: `${baseFull}/jmreport/category/folder/sort`,

    //-----字典相关接口begin-------------------------
    //获取字典全部接口
    dictList: `${baseFull}/jmreport/dict/list`,
    //字典主表新增
    dictAdd: `${baseFull}/jmreport/dict/add`,
    //字典编辑
    dictEdit: `${baseFull}/jmreport/dict/edit`,
    //字典删除
    dictDelete: `${baseFull}/jmreport/dict/delete`,
    //批量删除
    dictDeleteBatch: `${baseFull}/jmreport/dict/deleteBatch`,
    //获取字典详细全部接口
    dictItemList: `${baseFull}/jmreport/dictItem/list`,
    //字典详细编辑
    dictItemEdit: `${baseFull}/jmreport/dictItem/edit`,
    //字典详细新增
    dictItemAdd: `${baseFull}/jmreport/dictItem/add`,
    //字典详细删除
    dictItemDelete: `${baseFull}/jmreport/dictItem/delete`,
    //字典刷新缓存
    refreshCache: `${baseFull}/jmreport/dict/refleshCache`,
    //获取字典回收站逻辑删除的数据
    deleteList: `${baseFull}/jmreport/dict/deleteList`,
    //字典回收站取回
    back: `${baseFull}/jmreport/dict/back`,
    //字典回收站批量取回
    batchRevert: `${baseFull}/jmreport/dict/batchRevert`,
    //字典回收站逻辑删除的数据
    thoroughDelete: `${baseFull}/jmreport/dict/thoroughDelete`,
    //字典批量真实删除
    batchRealDelete: `${baseFull}/jmreport/dict/batchRealDelete`
    //-----字典相关接口end-------------------------
}

/**图片预览地址*/
JM_VIEW_IMG_URL = '/jmreport/img/';