/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.drag.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.modules.drag.a.a;
import org.jeecg.modules.drag.config.page.DragPage;
import org.jeecg.modules.drag.dao.JimuDragCategoryDao;
import org.jeecg.modules.drag.dao.OnlDragPageCompDao;
import org.jeecg.modules.drag.dao.OnlDragPageDao;
import org.jeecg.modules.drag.entity.JimuDragCategory;
import org.jeecg.modules.drag.entity.OnlDragPage;
import org.jeecg.modules.drag.service.IJimuDragCategoryService;
import org.jeecg.modules.drag.util.l;
import org.jeecg.modules.drag.vo.OnlDragRecycleVo;
import org.jeecg.modules.drag.vo.TreeModel;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="jimuDragCategoryServiceImpl")
public class b
implements IJimuDragCategoryService {
    @Autowired
    private JimuDragCategoryDao jimuDragCategoryDao;
    @Autowired
    private OnlDragPageDao onlDragPageDao;
    @Autowired
    private OnlDragPageCompDao onlDragPageCompDao;

    @Override
    public JimuDragCategory getById(String id) {
        return this.jimuDragCategoryDao.get(id);
    }

    @Override
    public List<TreeModel> queryList(JimuDragCategory category) {
        List<JimuDragCategory> list = this.jimuDragCategoryDao.queryList(category);
        ArrayList<TreeModel> arrayList = new ArrayList<TreeModel>();
        list.forEach(jimuDragCategory -> {
            TreeModel treeModel = new TreeModel(jimuDragCategory.getId(), jimuDragCategory.getParentId(), jimuDragCategory.getId(), jimuDragCategory.getName(), jimuDragCategory.getIzLeaf());
            arrayList.add(treeModel);
        });
        return arrayList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(JimuDragCategory category) {
        String string = category.getParentId();
        category.setIzLeaf(1);
        String string2 = category.getSourceType();
        if (l.c((Object)string2)) {
            category.setSourceType("drag");
        }
        category.setDelFlag(a.h);
        category.setUpdateTime(new Date());
        this.jimuDragCategoryDao.insert(category);
        if (StringUtils.isNotBlank((CharSequence)string) && !string.equals("0")) {
            JimuDragCategory jimuDragCategory = this.jimuDragCategoryDao.get(string);
            jimuDragCategory.setIzLeaf(0);
            this.jimuDragCategoryDao.update(jimuDragCategory);
        }
    }

    @Override
    public void updateById(JimuDragCategory category) {
        this.jimuDragCategoryDao.update(category);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JimuDragCategory updateDelFlag(Integer delFlag, String id) {
        JimuDragCategory jimuDragCategory = this.jimuDragCategoryDao.get(id);
        jimuDragCategory.setDelFlag(delFlag);
        this.jimuDragCategoryDao.update(jimuDragCategory);
        String string = jimuDragCategory.getParentId();
        if (StringUtils.isNotBlank((CharSequence)string) && !string.equals("0")) {
            int n2 = this.jimuDragCategoryDao.countByParentId(string);
            JimuDragCategory jimuDragCategory2 = this.jimuDragCategoryDao.get(string);
            jimuDragCategory2.setIzLeaf(n2 == 0 ? 1 : 0);
            this.jimuDragCategoryDao.update(jimuDragCategory2);
        }
        Integer n3 = delFlag == a.g ? a.i : delFlag;
        this.a(id, n3);
        return jimuDragCategory;
    }

    @Override
    public DragPage<OnlDragRecycleVo> queryRecycleList(OnlDragRecycleVo recycleVo, Integer pageNo, Integer pageSize) {
        MiniDaoPage<OnlDragRecycleVo> miniDaoPage = this.jimuDragCategoryDao.queryRecycleBin(recycleVo, pageNo, pageSize);
        return new DragPage<OnlDragRecycleVo>(miniDaoPage);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void physicalDelete(String id) {
        this.jimuDragCategoryDao.delete(id);
        List<String> list = this.onlDragPageDao.queryIdByType(id);
        if (!CollectionUtils.isEmpty(list)) {
            this.onlDragPageCompDao.deleteByPageIds(list);
            this.onlDragPageDao.deleteByIds(list);
        }
        this.a(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void clearRecovery(JimuDragCategory jimuDragCategory) {
        List<String> list;
        Object object;
        Object object2;
        String string;
        Integer n2 = jimuDragCategory.getDelFlag();
        List<String> list2 = this.jimuDragCategoryDao.queryIdList(n2, string = jimuDragCategory.getSourceType());
        if (!CollectionUtils.isEmpty(list2)) {
            object2 = list2.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                this.jimuDragCategoryDao.delete((String)object);
                list = this.onlDragPageDao.queryIdByType((String)object);
                if (!CollectionUtils.isEmpty(list)) {
                    this.onlDragPageCompDao.deleteByPageIds(list);
                    this.onlDragPageDao.deleteByIds(list);
                }
                this.a((String)object);
            }
        }
        if (l.d(object2 = jimuDragCategory.getDragType())) {
            object = new OnlDragPage();
            ((OnlDragPage)object).setDelFlag(a.g);
            ((OnlDragPage)object).setStyle(jimuDragCategory.getDragType());
            list = this.onlDragPageDao.queryIdList((OnlDragPage)object);
            if (!CollectionUtils.isEmpty(list)) {
                this.onlDragPageCompDao.deleteByPageIds(list);
                this.onlDragPageDao.deleteByIds(list);
            }
        }
    }

    @Override
    public Map<String, Integer> queryRecycleCount(OnlDragRecycleVo recycleVo) {
        List<Map<String, Integer>> list = this.jimuDragCategoryDao.queryRecycleCount(recycleVo);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (!CollectionUtils.isEmpty(list)) {
            hashMap.put("categoryTotal", l.a((Object)list.get(0).get("total"), 0));
            hashMap.put("dragTotal", l.a((Object)list.get(1).get("total"), 0));
        }
        return hashMap;
    }

    @Override
    public Map<String, Integer> queryCountById(String id) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        List<String> list = this.jimuDragCategoryDao.getChildIds(id);
        List<String> list2 = this.onlDragPageDao.queryIdByType(id);
        Integer n2 = l.a((Object)list.size(), 0);
        Integer n3 = l.a((Object)list2.size(), 0);
        Integer[] integerArray = this.a(list);
        n2 = n2 + integerArray[0];
        n3 = n3 + integerArray[1];
        hashMap.put("categoryNum", n2);
        hashMap.put("dragNum", n3);
        return hashMap;
    }

    private Integer[] a(List<String> list) {
        Integer n2 = 0;
        Integer n3 = 0;
        if (l.d(list)) {
            for (String string : list) {
                List<String> list2 = this.jimuDragCategoryDao.getChildIds(string);
                List<String> list3 = this.onlDragPageDao.queryIdByType(string);
                n2 = n2 + l.a((Object)list2.size(), 0);
                n3 = n3 + l.a((Object)list3.size(), 0);
                if (!l.d(list2)) continue;
                Integer[] integerArray = this.a(list2);
                n2 = n2 + integerArray[0];
                n3 = n3 + integerArray[1];
            }
        }
        return new Integer[]{n2, n3};
    }

    private void a(String string, Integer n2) {
        List<String> list = this.jimuDragCategoryDao.getChildIds(string);
        for (String string2 : list) {
            this.jimuDragCategoryDao.updateDelFlagById(string2, n2);
            this.a(string2, n2);
        }
    }

    private void a(String string) {
        List<String> list = this.jimuDragCategoryDao.getChildIds(string);
        for (String string2 : list) {
            this.b(string2);
        }
    }

    private void b(String string) {
        if (l.d((Object)string)) {
            this.jimuDragCategoryDao.delete(string);
            List<String> list = this.onlDragPageDao.queryIdByType(string);
            if (!CollectionUtils.isEmpty(list)) {
                this.onlDragPageCompDao.deleteByPageIds(list);
                this.onlDragPageDao.deleteByIds(list);
            }
            this.a(string);
        }
    }
}

