function getUrl(url){
    return `${baseFull}/drag` + url;
}
//拼接待tokenurl
function getHasTokenUrl(url, id){
    if (id){
        return `${baseFull}/drag${url}/${id}?token=${token}`;
    }else{
        return `${baseFull}/drag${url}?token=${token}`;
    }
}
//拼接待域名url
function getOrigin(url){
    return `${baseFull}/drag` + url;
}

const api = {
    //首页
    index: getUrl('/index'),
    //预览界面
    view: getUrl('/view'),
    //预览界面
    shareView: getUrl('/share/view'),
    //查询用户名
    getLoginUser: getUrl('/onlDragDatasetHead/getLoginUser'),
    //查询仪表盘
    queryPageList: getUrl('/page/list'),
    //查询模版仪表盘
    queryTemplateList: getUrl('/page/queryTemplateList'),
    //仪表盘预览
    show: getOrigin('/show'),
    //删除仪表盘
    deleteDrag: getUrl('/page/delete'),
    //彻底删除仪表盘
    physicalDeleteDrag: getUrl('/page/physicalDelete'),
    //还原删除的仪表盘
    recoveryDeleteDrag: getUrl('/page/recoveryDelete'),
    //图表复制
    dragCopy: getUrl('/page/copyPage'),
    //设置模版
    setTemplate: getUrl('/page/edit'),
    //新增和编辑仪表盘
    add: getUrl('/page/add'),
    edit: getUrl('/page/edit'),

    //-----目录相关接口begin-------------------------
    //查询目录api接口
    categoryList: getUrl('/category/list'),
    //编辑目录api接口
    editCategoryTree: getUrl('/category/edit'),
    //目录
    saveCategoryTree: getUrl('/category/add'),
    //查询一个
    getCategoryById: getUrl('/category/getById'),
    //删除
    deleteCategoryTree: getUrl('/category/deleteById'),
    //-----目录相关接口end-------------------------

    //分享-根据id查询
    getShareByPageId: getUrl('/onlDragShare/getByPageId'),
    //分享-编辑
    shareEdit: getUrl('/onlDragShare/edit'),
    //分享-保存
    shareAdd: getUrl('/onlDragShare/add'),
}

/**图片预览地址*/
JM_VIEW_IMG_URL = '/sys/common/static/';