/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.drag.config.websocket;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.jeecg.common.base.BaseMap;
import org.jeecg.common.modules.redis.client.JeecgRedisClient;
import org.jeecg.common.modules.redis.listener.JeecgRedisListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dragChannelSocket")
@ServerEndpoint(value="/dragChannelSocket/{token}")
public class DragChannelWebSocket {
    private static final Logger log = LoggerFactory.getLogger(DragChannelWebSocket.class);
    private static ConcurrentHashMap<String, Session> sessionPool = new ConcurrentHashMap();
    public static final String REDIS_TOPIC_NAME = "dragChannelHandler";
    private static JeecgRedisClient jeecgRedisClient;

    @Autowired
    private void setJeecgRedisClient(JeecgRedisClient jeecgRedisClient) {
        DragChannelWebSocket.jeecgRedisClient = jeecgRedisClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnOpen
    public void onOpen(Session session, @PathParam(value="token") String token) {
        try {
            sessionPool.put(token, session);
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u6709\u65b0\u7684\u8fde\u63a5\uff0c\u603b\u6570\u4e3a:" + sessionPool.size());
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("event", (Object)"connect");
            Session session2 = session;
            synchronized (session2) {
                session.getBasicRemote().sendText(jSONObject.toJSONString());
            }
        }
        catch (Exception exception) {
            log.warn(exception.getMessage(), (Throwable)exception);
        }
    }

    @OnClose
    public void onClose(@PathParam(value="token") String token) {
        try {
            sessionPool.remove(token);
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u8fde\u63a5\u65ad\u5f00\uff0c\u603b\u6570\u4e3a:" + sessionPool.size());
        }
        catch (Exception exception) {
            log.warn(exception.getMessage(), (Throwable)exception);
        }
    }

    @OnMessage
    public void onMessage(String message, @PathParam(value="token") String token) {
        if (!"ping".equals(message) && !"heartcheck".equals(message)) {
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u6536\u5230\u5ba2\u6237\u7aef\u6d88\u606f:" + message);
        } else {
            this.sendMessage(token, "ping");
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u6536\u5230\u5ba2\u6237\u7aef\u6d88\u606f:" + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushMessage(String token, String message) {
        for (Map.Entry<String, Session> entry : sessionPool.entrySet()) {
            if (!entry.getKey().contains(token)) continue;
            Session session = entry.getValue();
            try {
                Session session2 = session;
                synchronized (session2) {
                    log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u63a8\u9001\u5355\u4eba\u6d88\u606f:" + message);
                    session.getBasicRemote().sendText(message);
                }
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable t2) {
        log.warn("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u6d88\u606f\u51fa\u73b0\u9519\u8bef");
        t2.printStackTrace();
    }

    public void sendMessage(String token, String message) {
        BaseMap baseMap = new BaseMap();
        baseMap.put("token", (Object)token);
        baseMap.put("message", (Object)message);
        jeecgRedisClient.sendMessage(REDIS_TOPIC_NAME, baseMap);
    }

    @Component(value="dragChannelHandler")
    class RedisSocketHandler
    implements JeecgRedisListener {
        private final DragChannelWebSocket dragChannelWebSocket;

        public RedisSocketHandler(DragChannelWebSocket dragSocket) {
            this.dragChannelWebSocket = dragSocket;
        }

        public void onMessage(BaseMap map) {
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011redis {}\uff0c\u53c2\u6570\uff1a{}", (Object)DragChannelWebSocket.REDIS_TOPIC_NAME, (Object)map.toString());
            String string = (String)map.get("token");
            String string2 = (String)map.get("message");
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011redis {}\uff0ctoken\u53c2\u6570\uff1a{}", (Object)string);
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011redis {}\uff0cmessage\u53c2\u6570\uff1a{}", (Object)string2);
            this.dragChannelWebSocket.pushMessage(string, string2);
        }
    }
}

