/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.drag.service.impl;

import java.util.Map;
import org.jeecg.common.api.dto.DragRelIdsDTO;
import org.jeecg.common.drag.api.IDragBaseApi;
import org.jeecg.modules.drag.entity.OnlDragPage;
import org.jeecg.modules.drag.entity.OnlDragPageComp;
import org.jeecg.modules.drag.exception.OnlDragException;
import org.jeecg.modules.drag.service.IOnlDragPageCompService;
import org.jeecg.modules.drag.service.IOnlDragPageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="onlDragBaseApiImpl")
public class OnlDragBaseApiImpl
implements IDragBaseApi {
    private static final Logger log = LoggerFactory.getLogger(OnlDragBaseApiImpl.class);
    @Autowired
    private IOnlDragPageService onlPageService;
    @Autowired
    private IOnlDragPageCompService onlPageCompService;

    public void deleteDragPage(String id) {
        this.onlPageService.deleteOne(id);
    }

    public String copyDragPage(String id, Integer tenantId) {
        String string = "";
        try {
            OnlDragPage onlDragPage = this.onlPageService.getById(id);
            if (onlDragPage == null) {
                return null;
            }
            if (tenantId != null) {
                onlDragPage.setTenantId(tenantId);
            }
            OnlDragPage onlDragPage2 = this.onlPageService.copyPage(onlDragPage);
            string = onlDragPage2.getId();
            log.info("copyDragPage\u590d\u5236\u4eea\u8868\u76d8\u540e\u7684copyId:{}", (Object)string);
        }
        catch (OnlDragException onlDragException) {
            log.error(onlDragException.getMessage(), (Throwable)onlDragException);
        }
        return string;
    }

    public String backupsPageCrossApp(String id, String backupKey) {
        OnlDragPage onlDragPage = this.onlPageService.backupsPage(id, backupKey);
        log.info("backupsPageCrossApp\u5907\u4efd\u4eea\u8868\u76d8\u540e\u7684copyPage:{}", (Object)onlDragPage.toString());
        return onlDragPage.getId();
    }

    public void revertPageCrossApp(String id, String backupKey) {
        this.onlPageService.revertPage(id, backupKey);
    }

    public String copyPageCrossApp(DragRelIdsDTO dragRelIdsDTO) {
        String string = dragRelIdsDTO.getId();
        Map map = dragRelIdsDTO.getFormCodeMap();
        Map map2 = dragRelIdsDTO.getFormIdMap();
        Map map3 = dragRelIdsDTO.getDragIdMap();
        Map map4 = dragRelIdsDTO.getViewIdMap();
        Map map5 = dragRelIdsDTO.getBpmIdMap();
        OnlDragPageComp onlDragPageComp = this.onlPageCompService.copyById(string);
        if (onlDragPageComp == null) {
            return null;
        }
        this.onlPageCompService.replaceConfigValue(onlDragPageComp, map, map2, map3, map4, map5);
        return onlDragPageComp.getId();
    }

    public void replacePageRelIdsCrossApp(DragRelIdsDTO dragRelIdsDTO) {
        Map map = dragRelIdsDTO.getFormCodeMap();
        Map map2 = dragRelIdsDTO.getFormIdMap();
        Map map3 = dragRelIdsDTO.getDragIdMap();
        Map map4 = dragRelIdsDTO.getViewIdMap();
        Map map5 = dragRelIdsDTO.getBpmIdMap();
        log.info("replacePageRelIdsCrossApp\u66ff\u6362\u4eea\u8868\u76d8\u4e2d\u7684\u6570\u636e\u3010\u5e94\u7528\u590d\u5236\u4e13\u7528\u3011dragRelIdsDTO:{}", (Object)dragRelIdsDTO);
        for (String string : map3.keySet()) {
            String string2 = (String)map3.get(string);
            log.info("\u9700\u8981\u66ff\u6362\u7684id\u914d\u7f6e\u9879id\uff1a{}", (Object)string2);
            this.onlPageService.replacePageValue(string2, map, map2, map3, map4, map5);
        }
    }
}

