/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.drag.config.sign;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.jeecg.modules.drag.f.b;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component(value="dragSignatureAspect")
public class DragSignatureAspect {
    private static final Logger log = LoggerFactory.getLogger(DragSignatureAspect.class);
    private static final long MAX_REQUEST = 600000L;
    private static final String X_SIGN = "X-SIGN";
    private static final String V_SIGN = "V-SIGN";
    private static final String TIMESTAMP = "X-TIMESTAMP";

    @Pointcut(value="execution(@org.jeecg.modules.drag.config.sign.SignatureValidation * *(..))")
    private void verifySignPointCut() {
    }

    @Before(value="verifySignPointCut()")
    public void doBasicProfiling(JoinPoint point) throws IOException {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest httpServletRequest = Objects.requireNonNull(servletRequestAttributes).getRequest();
        String string = httpServletRequest.getHeader(V_SIGN);
        String string2 = httpServletRequest.getHeader(TIMESTAMP);
        String string3 = httpServletRequest.getHeader(X_SIGN);
        long l2 = System.currentTimeMillis();
        if (StringUtil.isEmpty((String)string2)) {
            log.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u4e3a\u7a7a\uff01");
            throw new IllegalArgumentException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u4e3a\u7a7a\uff01");
        }
        long l3 = Long.parseLong(string2);
        if (l2 - l3 > 600000L) {
            log.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u5df2\u8fc7\u671f\uff0c\u6ce8\u610f\u7cfb\u7edf\u65f6\u95f4\u548c\u670d\u52a1\u5668\u65f6\u95f4\u662f\u5426\u6709\u8bef\u5dee\uff01");
            throw new IllegalArgumentException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u5df2\u8fc7\u671f");
        }
        if (StringUtil.isBlank((String)string)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:\u7b7e\u540d\u672a\u627e\u5230");
        }
        try {
            String string4 = this.generatedSignature(point, string3);
            log.info("xSign:{}", (Object)string3);
            log.info("generatedSign:{}", (Object)string4);
            log.info("sign:{}", (Object)string);
            if (!string.equals(string4)) {
                throw new IllegalArgumentException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:\u7b7e\u540d\u9519\u8bef");
            }
        }
        catch (Throwable throwable) {
            log.warn("\u7b7e\u540d\u5931\u8d25\u5f02\u5e38:" + throwable.getMessage(), throwable);
            throw new IllegalArgumentException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:\u7b7e\u540d\u9519\u8bef");
        }
    }

    private String generatedSignature(JoinPoint point, String xSign) throws IOException {
        List list;
        Object[] objectArray = point.getArgs();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("sign", xSign);
        treeMap.put("_t", Instant.now().toString());
        if (ArrayUtils.isNotEmpty((Object[])objectArray) && (list = Arrays.stream(objectArray).filter(arg -> !(arg instanceof HttpServletRequest) && !(arg instanceof HttpServletResponse)).collect(Collectors.toList())) != null && list.size() > 0) {
            JSONObject jSONObject = JSONObject.parseObject((String)list.get(0).toString());
            Set set = jSONObject.keySet();
            String string2 = "";
            for (String string2 : set) {
                Object object = jSONObject.get((Object)string2);
                if (!(object instanceof String)) continue;
                treeMap.put(string2, object.toString());
            }
        }
        log.info("generatedSignature===>params:{}", treeMap);
        return b.a(treeMap);
    }
}

