<script type="text/x-template" id="shareModal">
    <div>
        <Modal v-model="visible" title="分享链接" :footer-hide="true">
            <i-form ref="dragPageForm" label-position="left">
                <form-item label="预览链接:" style="display: flex">
                    <i-input v-model="shareUrl" readonly style="min-width: 400px">
                        <template #append>
                            <Button type="primary" @click="copyClick"><i class="ivu-icon ivu-icon-ios-browsers" style="font-size: 16px"></i></Button>
                            <Button type="primary" @click="goShare"><i class="ivu-icon ivu-icon-md-log-in" style="font-size: 16px"></i></Button>
                        </template>
                    </i-input>
                </form-item>
            </i-form>
        </Modal>
    </div>
</script>
<script>
    Vue.component('j-share-modal', {
        template: '#shareModal',
        data() {
            return {
                id: "",
                visible: false,
                shareUrl: "",
            }
        },
        methods: {
            show(url) {
                this.shareUrl = url
                this.visible = true;
            },
            //确定事件
            handleOk() {
                this.visible = false
            },
            goShare(){
                window.open(this.shareUrl,"_blank")
            },
            copyClick(){
                let textarea = document.createElement('textarea');
                textarea.value =  this.shareUrl;
                document.body.appendChild(textarea);
                textarea.select(); // 选择对象;
                document.execCommand("Copy"); // 执行浏览器复制命令
                document.body.removeChild(textarea)
                this.$Message.success('复制成功');
            }
        }
    })
</script>
