/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.drag.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.modules.drag.config.page.DragPage;
import org.jeecg.modules.drag.dao.OnlDragPageCompDao;
import org.jeecg.modules.drag.dao.OnlDragPageDao;
import org.jeecg.modules.drag.entity.OnlDragPage;
import org.jeecg.modules.drag.entity.OnlDragPageComp;
import org.jeecg.modules.drag.service.IOnlDragPageService;
import org.jeecg.modules.drag.util.b;
import org.jeecg.modules.drag.util.f;
import org.jeecg.modules.drag.util.l;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="onlDragPageServiceImpl")
public class j
implements IOnlDragPageService {
    private static final Logger a = LoggerFactory.getLogger(j.class);
    @Autowired
    private OnlDragPageDao onlDragPageDao;
    @Autowired
    private OnlDragPageCompDao onlDragPageCompDao;
    @Autowired
    private f redisUtil;

    @Override
    public OnlDragPage addOnlPage(OnlDragPage onlDragPage) {
        String string = onlDragPage.getTemplate();
        JSONArray jSONArray = JSONArray.parseArray((String)string);
        if (jSONArray != null) {
            b.a(jSONArray, null);
            onlDragPage.setTemplate(jSONArray.toJSONString());
        }
        onlDragPage.setIzTemplate("0");
        onlDragPage.setVisitsNum(0);
        this.onlDragPageDao.insert(onlDragPage);
        onlDragPage.setPath(String.format("/drag/page/view/%s", onlDragPage.getId()));
        this.onlDragPageDao.update(onlDragPage);
        return onlDragPage;
    }

    @Override
    @Cacheable(value={"drag:cache:page"}, key="#id", unless="#result == null")
    public OnlDragPage getOneOnlPage(String id) {
        OnlDragPage onlDragPage = this.getById(id);
        if (onlDragPage == null) {
            return null;
        }
        String string = onlDragPage.getTemplate();
        JSONArray jSONArray = JSONArray.parseArray((String)string);
        if (jSONArray != null) {
            List<OnlDragPageComp> list = this.onlDragPageCompDao.queryByPageId(id);
            Map<String, Object> map = list.stream().collect(Collectors.toMap(OnlDragPageComp::getId, onlDragPageComp -> onlDragPageComp.getConfig() != null ? onlDragPageComp.getConfig() : "{}"));
            b.a(jSONArray, map);
            onlDragPage.setTemplate(jSONArray.toJSONString());
        }
        return onlDragPage;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"drag:cache:page"}, key="#id")
    public void deleteOne(String id) {
        this.onlDragPageDao.deleteById(id);
        List<OnlDragPageComp> list = this.onlDragPageCompDao.queryByPageId(id);
        List list2 = list.stream().map(OnlDragPageComp::getId).collect(Collectors.toList());
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            this.onlDragPageCompDao.deleteById((String)list2.get(i2));
        }
    }

    @Override
    @CacheEvict(value={"drag:cache:page"}, key="#onlDragPage.id")
    @Transactional(rollbackFor={Exception.class})
    public boolean editOnlPageById(OnlDragPage onlDragPage) {
        Object object;
        String string = onlDragPage.getTemplate();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            List<OnlDragPageComp> list = this.onlDragPageCompDao.queryByPageId(onlDragPage.getId());
            object = list.stream().map(OnlDragPageComp::getId).collect(Collectors.toList());
            for (int i2 = 0; i2 < object.size(); ++i2) {
                this.onlDragPageCompDao.deleteById((String)object.get(i2));
            }
            JSONArray jSONArray = JSONArray.parseArray((String)string);
            if (jSONArray != null) {
                this.a(jSONArray, onlDragPage.getId());
                onlDragPage.setTemplate(jSONArray.toJSONString());
            }
        }
        onlDragPage.setPath(String.format("/drag/page/view/%s", onlDragPage.getId()));
        a.info("\u4fee\u6539\u4eea\u8868\u76d8\u914d\u7f6e\uff0conlDragPage id:{}, updateCount:{}", (Object)onlDragPage.getId(), (Object)onlDragPage.getUpdateCount());
        int n2 = this.onlDragPageDao.update(onlDragPage);
        if (n2 == 0) {
            object = String.format("drag:cache:page::%s", onlDragPage.getId());
            if (this.redisUtil.b((String)object)) {
                this.redisUtil.a(new String[]{object});
            }
            throw new JeecgBootException("\u4eea\u8868\u76d8\u5185\u5bb9\u4e0d\u662f\u6700\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u64cd\u4f5c~");
        }
        return n2 == 1;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OnlDragPage copyPage(OnlDragPage onlDragPage) {
        OnlDragPage onlDragPage2 = new OnlDragPage();
        BeanUtils.copyProperties((Object)onlDragPage, (Object)onlDragPage2);
        onlDragPage2.setId(null);
        onlDragPage2.setName(onlDragPage.getName());
        onlDragPage2.setProtectionCode(null);
        onlDragPage2.setIzTemplate("0");
        onlDragPage2.setCreateTime(new Date());
        onlDragPage2.setVisitsNum(0);
        this.onlDragPageDao.insert(onlDragPage2);
        this.a(onlDragPage2);
        onlDragPage2.setPath(String.format("/drag/page/view/%s", onlDragPage2.getId()));
        this.onlDragPageDao.update(onlDragPage2);
        return onlDragPage2;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OnlDragPage backupsPage(String id, String backupKey) {
        OnlDragPage onlDragPage = this.onlDragPageDao.get(id);
        if (onlDragPage != null) {
            String string = b.a(id, backupKey);
            String string2 = b.a(onlDragPage.getLowAppId(), backupKey);
            OnlDragPage onlDragPage2 = new OnlDragPage();
            BeanUtils.copyProperties((Object)onlDragPage, (Object)onlDragPage2);
            onlDragPage2.setId(string);
            onlDragPage2.setLowAppId(string2);
            this.onlDragPageDao.insert(onlDragPage2);
            this.a(onlDragPage2);
            onlDragPage2.setPath(String.format("/drag/page/view/%s", onlDragPage2.getId()));
            this.onlDragPageDao.update(onlDragPage2);
            return onlDragPage2;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"drag:cache:page"}, allEntries=true)
    public void revertPage(String id, String backupKey) {
        a.info("\u5e26\u6709\u540e\u7f00\u7684\u4eea\u8868\u76d8id= {}", (Object)id);
        String string = b.b(id, backupKey);
        a.info("\u539f\u59cb\u7684\u4eea\u8868\u76d8id= {}", (Object)string);
        this.deleteOne(string);
        OnlDragPage onlDragPage = this.onlDragPageDao.get(id);
        if (onlDragPage != null) {
            OnlDragPage onlDragPage2 = new OnlDragPage();
            BeanUtils.copyProperties((Object)onlDragPage, (Object)onlDragPage2);
            onlDragPage2.setId(string);
            onlDragPage2.setLowAppId(b.b(onlDragPage.getLowAppId(), backupKey));
            this.onlDragPageDao.insert(onlDragPage2);
            this.a(onlDragPage2);
            onlDragPage2.setPath(String.format("/drag/page/view/%s", onlDragPage2.getId()));
            this.onlDragPageDao.update(onlDragPage2);
        }
    }

    @Override
    public void replacePageValue(String id, Map<String, String> formCodeMap, Map<String, String> formIdMap, Map<String, String> dragIdMap, Map<String, String> viewIdMap, Map<String, String> bpmIdMap) {
        OnlDragPage onlDragPage = this.onlDragPageDao.get(id);
        a.info("\u4fee\u6539\u540e\u7684\u4eea\u8868\u76d8id= {}", (Object)onlDragPage.getId());
        JSONArray jSONArray = JSONArray.parseArray((String)onlDragPage.getTemplate());
        if (jSONArray != null && jSONArray.size() > 0) {
            jSONArray.forEach(object -> {
                OnlDragPageComp onlDragPageComp;
                JSONObject jSONObject = (JSONObject)object;
                String string = jSONObject.getString("pageCompId");
                a.info("\u9700\u8981\u66ff\u6362\u7684pageCompId\uff1a{}", (Object)string);
                if (StringUtils.isNotBlank((CharSequence)string) && (onlDragPageComp = this.onlDragPageCompDao.get(string)) != null) {
                    String string2 = onlDragPageComp.getComponent();
                    String string3 = onlDragPageComp.getConfig();
                    JSONObject jSONObject2 = JSONObject.parseObject((String)string3);
                    if ("JCustomButton".equals(string2)) {
                        JSONArray jSONArray = jSONObject2.getJSONArray("chartData");
                        if (jSONArray != null && jSONArray.size() > 0) {
                            for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
                                String string4;
                                JSONObject jSONObject3;
                                JSONObject jSONObject4 = (JSONObject)jSONArray.get(i2);
                                String string5 = jSONObject4.getString("operationType");
                                if ("1".equals(string5) || "2".equals(string5)) {
                                    String string6;
                                    jSONObject3 = jSONObject4.getJSONObject("worksheet");
                                    if (jSONObject3 == null) continue;
                                    string4 = jSONObject3.getString("key");
                                    if (StringUtils.isNotBlank((CharSequence)string4) && formCodeMap.containsKey(string4)) {
                                        jSONObject3.put("key", formCodeMap.get(string4));
                                        jSONObject3.put("value", formCodeMap.get(string4));
                                    }
                                    if (!StringUtils.isNotBlank((CharSequence)(string6 = jSONObject4.getString("view"))) || !viewIdMap.containsKey(string6)) continue;
                                    jSONObject3.put("view", viewIdMap.get(string6));
                                    continue;
                                }
                                if ("3".equals(string5)) {
                                    jSONObject3 = jSONObject4.getJSONObject("customPage");
                                    if (jSONObject3 == null || !StringUtils.isNotBlank((CharSequence)(string4 = jSONObject3.getString("key"))) || !dragIdMap.containsKey(string4)) continue;
                                    jSONObject3.put("key", dragIdMap.get(string4));
                                    jSONObject3.put("value", dragIdMap.get(string4));
                                    continue;
                                }
                                if (!"6".equals(string5) || (jSONObject3 = jSONObject4.getJSONObject("bizFlow")) == null || !StringUtils.isNotBlank((CharSequence)(string4 = jSONObject3.getString("key"))) || !bpmIdMap.containsKey(string4)) continue;
                                jSONObject3.put("key", bpmIdMap.get(string4));
                                jSONObject3.put("value", bpmIdMap.get(string4));
                            }
                        }
                    } else if ("JCarousel".equals(string2)) {
                        String string7;
                        JSONObject jSONObject5 = jSONObject2.getJSONObject("worksheet");
                        if (jSONObject5 != null && StringUtils.isNotBlank((CharSequence)(string7 = jSONObject5.getString("key"))) && formCodeMap.containsKey(string7)) {
                            jSONObject5.put("key", formCodeMap.get(string7));
                            jSONObject5.put("value", formCodeMap.get(string7));
                        }
                    } else {
                        String string8 = jSONObject2.getString("formId");
                        String string9 = jSONObject2.getString("appId");
                        String string10 = jSONObject2.getString("appType");
                        String string11 = jSONObject2.getString("tableName");
                        if (StringUtils.isNotBlank((CharSequence)string8) && formCodeMap.containsKey(string8)) {
                            jSONObject2.put("formId", formCodeMap.get(string8));
                            jSONObject2.put("tableName", formCodeMap.get(string11));
                        }
                        if (StringUtils.isNotBlank((CharSequence)string10) && StringUtils.isNotBlank((CharSequence)string9) && string10.equals("current")) {
                            jSONObject2.put("appId", (Object)onlDragPage.getLowAppId());
                        }
                    }
                    a.info("\u4fee\u6539\u540e\u7684\u914d\u7f6e\u9879id= {}", (Object)onlDragPageComp.getId());
                    a.info("\u4fee\u6539\u540e\u7684\u914d\u7f6e\u9879json= {}", (Object)jSONObject2.toJSONString());
                    onlDragPageComp.setConfig(jSONObject2.toJSONString());
                    this.onlDragPageCompDao.update(onlDragPageComp);
                }
            });
        }
    }

    @Override
    public void updateVisitsNum(String id, Integer increaseCount) {
        OnlDragPage onlDragPage = this.getByIdForVisitsNum(id);
        if (null != onlDragPage) {
            int n2 = l.a((Object)onlDragPage.getVisitsNum(), 0);
            int n3 = increaseCount + n2;
            onlDragPage.setVisitsNum(n3);
            this.onlDragPageDao.updateVisitsNum(onlDragPage);
            a.info("\u4eea\u8868\u76d8\uff1a{} \u8bbf\u95ee\u6b21\u6570+1\uff0c\u603b\u8bbf\u95ee\u6570\u91cf\uff1a{}", (Object)onlDragPage.getName(), (Object)onlDragPage.getVisitsNum());
        }
    }

    private List<OnlDragPageComp> a(OnlDragPage onlDragPage) {
        ArrayList<OnlDragPageComp> arrayList = new ArrayList<OnlDragPageComp>();
        String string = onlDragPage.getTemplate();
        JSONArray jSONArray = JSONArray.parseArray((String)string);
        if (jSONArray != null) {
            jSONArray.forEach(object -> {
                JSONObject jSONObject = (JSONObject)object;
                String string = jSONObject.getString("pageCompId");
                OnlDragPageComp onlDragPageComp = this.onlDragPageCompDao.get(string);
                if (onlDragPageComp != null) {
                    onlDragPageComp.setId(null);
                    onlDragPageComp.setPageId(onlDragPage.getId());
                    onlDragPageComp.setCreateTime(new Date());
                    this.onlDragPageCompDao.insert(onlDragPageComp);
                    jSONObject.put("pageCompId", (Object)onlDragPageComp.getId());
                }
            });
            onlDragPage.setTemplate(jSONArray.toJSONString());
            return arrayList;
        }
        return null;
    }

    public void a(JSONArray jSONArray, String string) {
        for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
            JSONObject jSONObject = jSONArray.getJSONObject(i2);
            OnlDragPageComp onlDragPageComp = new OnlDragPageComp();
            onlDragPageComp.setComponent(jSONObject.getString("component"));
            onlDragPageComp.setConfig(jSONObject.containsKey((Object)"config") ? jSONObject.getString("config") : "");
            onlDragPageComp.setPageId(string);
            this.onlDragPageCompDao.insert(onlDragPageComp);
            jSONObject.put("pageCompId", (Object)onlDragPageComp.getId());
            if (!jSONObject.containsKey((Object)"config")) continue;
            jSONObject.remove((Object)"config");
        }
    }

    @Override
    public DragPage<OnlDragPage> pageList(OnlDragPage onlDragPage, Integer pageNo, Integer pageSize) {
        MiniDaoPage<OnlDragPage> miniDaoPage = this.onlDragPageDao.getAll(onlDragPage, pageNo, pageSize);
        DragPage<OnlDragPage> dragPage = new DragPage<OnlDragPage>(miniDaoPage);
        return dragPage;
    }

    @Override
    public OnlDragPage getById(String id) {
        return this.onlDragPageDao.get(id);
    }

    @Override
    public OnlDragPage getByIdForVisitsNum(String id) {
        return this.onlDragPageDao.getByIdForVisitsNum(id);
    }

    @Override
    public Map getShareInfo(String id, String type) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        OnlDragPage onlDragPage = this.onlDragPageDao.get(id);
        hashMap.put("title", onlDragPage.getName());
        hashMap.put("path", onlDragPage.getPath());
        hashMap.put("shareInfo", null);
        return hashMap;
    }

    @Override
    public OnlDragPage getPageById(String id) {
        return this.onlDragPageDao.getById(id);
    }

    @Override
    public Integer count() {
        return this.onlDragPageDao.count();
    }

    @Override
    @CacheEvict(value={"drag:cache:page"}, key="#onlDragPage.id")
    @Transactional(rollbackFor={Exception.class})
    public void saveCompToPage(OnlDragPage onlDragPage) {
        this.onlDragPageDao.update(onlDragPage);
    }
}

