<script type="text/x-template" id="dragModal">
    <div>
        <Modal v-model="visible" :title="modalTitle" ok-text="确认">
            <i-form ref="dragPageForm" :model="dragModal" label-position="left" :label-width="80" :rules="rules">
                <form-item label="名称:" prop="name" >
                    <i-input v-model="dragModal.name" style="width: 100%"/>
                </form-item>
                <form-item label="封面图:">
                    <template v-if="dragModal.coverUrl">
                        <div class="demo-upload-list">
                            <img :src="getImgUrl" fit="cover" width="100%" height="100%" />
                            <div class="demo-upload-list-cover">
                                <Icon type="ios-trash-outline" @click="dragModal.coverUrl = ''"></Icon>
                            </div>
                        </div>
                    </template>
                    <template v-else>
                        <Upload
                                style="display: inline-block;width:68px;"
                                :headers="uploadHeader"
                                :before-upload="handleUpload"
                                :action="actionUrl"
                                :format="['jpg','jpeg','png']"
                                :on-format-error="handleFormatError"
                                :on-exceeded-size="handleMaxSize"
                                :on-success="handleSuccess">
                            <div class="upload-div">
                                <i class="ivu-icon ivu-icon-md-add" style="font-size: 24px"></i>
                            </div>
                        </Upload>
                    </template>
                </form-item>
                <form-item label="保护码:" prop="protectionCode" >
                    <i-input type="password" password  v-model="dragModal.protectionCode" style="width: 100%" placeholder="请输入保护码"></i-input>
                </form-item>
            </i-form>
            <div slot="footer">
                <i-button size="large" @click="handleCancel">取消</i-button>
                <i-button type="primary" size="large" @click="handleOk">确定</i-button>
            </div>
        </Modal>
    </div>
</script>
<script>
    Vue.component('j-drag-modal', {
        template: '#dragModal',
        data() {
            return {
                id: "",
                modalTitle: "新增",
                visible: false,
                dragModal: {
                    id: "",
                    name: "",
                    coverUrl: "",
                    type: "",
                    protectionCode: "",
                },
                uploadHeader: {},
                actionUrl: "",
                rules:{
                    name: [
                        { required: true, message: '请填写仪表盘名称', trigger: 'change' }
                    ],
                }
            }
        },
        mounted() {
            this.uploadHeader = {"X-Access-Token": window.localStorage.getItem('JmReport-Access-Token')};
            this.actionUrl = BASE_URL + "/sys/common/upload";
        },
        computed: {
            getImgUrl(){
               return this.dragModal.coverUrl.startsWith("http")?this.dragModal.coverUrl:BASE_URL + '/sys/common/static/'+this.dragModal.coverUrl;
            }
        },
        methods: {
            show(data) {
                this.handleReset();
                if (data) {
                    this.modalTitle = data.id?'编辑':'新增';
                    Object.assign(this.dragModal, {...data});
                }
                console.log("this.dragModal",this.dragModal)
                this.visible = true;
            },
            handleReset(){
                this.$refs['dragPageForm'].resetFields()
                this.close();
            },
            //关闭事件
            handleCancel() {
                this.visible = false
                this.close();
            },
            close() {
                this.dragModal.id = "";
                this.dragModal.name = "";
                this.dragModal.coverUrl = "";
                this.dragModal.type = "";
            },
            //确定事件
            handleOk() {
                let that = this;
                that.$refs['dragPageForm'].validate((valid) => {
                    console.log(valid)
                    if (valid) {
                        let data = {...that.dragModal}
                        $Http.post({
                            contentType: 'json',
                            url: that.dragModal.id ? api.edit : api.add,
                            data: data,
                            success: (res) => {
                                if (res) {
                                    that.handleCancel()
                                    that.$emit('ok')
                                }
                            },
                            error: () => {
                                that.$Message.warning("创建仪表盘失败！")
                            }
                        })
                    }
                })
            },
            handleUpload(file) {
                this.file = file;
                return true;
            },
            handleFormatError(file) {
                this.$Notice.warning({
                    title: '文件格式不正确',
                    desc: '文件 ' + file.name + ' 格式不正确，请上传 jpg 或 png 格式的图片。'
                });
            },
            handleMaxSize(file) {
                this.$Notice.warning({
                    title: '超出文件大小限制',
                    desc: '文件 ' + file.name + ' 太大，不能超过 2M。'
                });
            },
            handleSuccess(res) {
                if (res != null && res.message) {
                    let that = this
                    this.$nextTick(()=>{
                        that.dragModal.coverUrl = res.message;
                    })
                }
            },
        }
    })
</script>
<style>
    .demo-upload-list {
        display: inline-block;
        width: 68px;
        height: 68px;
        text-align: center;
        line-height: 68px;
        border: 1px solid transparent;
        border-radius: 4px;
        overflow: hidden;
        background: #fff;
        position: relative;
        box-shadow: 0 1px 1px rgba(0, 0, 0, .2);
        margin-right: 4px;
    }

    .demo-upload-list img {
        width: 100%;
        height: 100%;
    }

    .demo-upload-list-cover {
        display: none;
        position: absolute;
        top: 0;
        bottom: 0;
        left: 0;
        right: 0;
        background: rgba(0, 0, 0, .6);
    }

    .demo-upload-list:hover .demo-upload-list-cover {
        display: block;
    }

    .demo-upload-list-cover i {
        color: #fff;
        font-size: 20px;
        cursor: pointer;
        margin: 0;
    }

    .upload-div {
        width: 68px;
        height: 68px;
        line-height: 68px;
        border: 1px solid #dcdee2;
        display: flex;
        justify-content: center;
        align-items: center;
    }
</style>