/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.low.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLowApp;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.cgform.entity.OnlCgformHead;
import org.jeecg.modules.online.cgform.model.a;
import org.jeecg.modules.online.cgform.service.IOnlCgformHeadService;
import org.jeecg.modules.online.cgreport.entity.OnlCgreportHead;
import org.jeecg.modules.online.cgreport.model.OnlCgreportModel;
import org.jeecg.modules.online.graphreport.vo.OnlGraphreportHeadPage;
import org.jeecg.modules.online.low.entity.LowAppMenu;
import org.jeecg.modules.online.low.service.ILowAppMenuService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Aspect
@Component(value="lowAppAspect")
public class LowAppAspect {
    private static final Logger log = LoggerFactory.getLogger(LowAppAspect.class);
    @Autowired
    ILowAppMenuService appMenuService;
    @Autowired
    IOnlCgformHeadService cgformHeadService;

    @Pointcut(value="@annotation(org.jeecg.common.aspect.annotation.AutoLowApp)")
    public void excudeLowAppAspect() {
    }

    @Around(value="excudeLowAppAspect() && @annotation(autoLowApp)")
    public Object excudeLowAppAspect(ProceedingJoinPoint pjp, AutoLowApp autoLowApp) throws Throwable {
        switch (autoLowApp.action()) {
            case ADD: {
                return this.autoAddAspect(pjp, autoLowApp);
            }
            case DELETE: {
                return this.autoDeleteAspect(pjp, autoLowApp);
            }
            case CGFORM_DB_IMPORT: {
                return this.doExcudeCgformSaveDbTable2Online(pjp);
            }
            case COPY: {
                return this.autoCopyAspect(pjp, autoLowApp);
            }
            case DESFORM_SUB2WORK: {
                return this.doExcudeDesformSubToWorksheet(pjp);
            }
        }
        return pjp.proceed();
    }

    private Object autoAddAspect(ProceedingJoinPoint pjp, AutoLowApp autoLowApp) throws Throwable {
        switch (autoLowApp.bizType()) {
            case "cgform": {
                return this.doExcudeCgformAdd(pjp);
            }
            case "desform": {
                return this.doExcudeDesignAdd(pjp);
            }
            case "drag": {
                return this.doExcudeDragAdd(pjp);
            }
            case "cgreport": {
                return this.doExcudeCgreportAdd(pjp);
            }
            case "graphreport": {
                return this.doExcudeGraphreportAdd(pjp);
            }
        }
        return this.doInjectAppId(pjp);
    }

    private Object doInjectAppId(ProceedingJoinPoint pjp) throws Throwable {
        Object object = null;
        try {
            HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
            String string = httpServletRequest.getHeader("X-Low-App-ID");
            if (oConvertUtils.isNotEmpty((Object)string)) {
                Object[] objectArray = pjp.getArgs();
                Object object2 = objectArray[0];
                Field field = ReflectionUtils.findField(object2.getClass(), (String)"lowAppId");
                if (field != null) {
                    ReflectionUtils.setField((Field)field, (Object)object2, (Object)string);
                }
                if (!this.isSuccess(object = pjp.proceed())) {
                    return object;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object == null) {
            return pjp.proceed();
        }
        return object;
    }

    private Object autoDeleteAspect(ProceedingJoinPoint pjp, AutoLowApp autoLowApp) throws Throwable {
        Object object = null;
        try {
            object = this.autoDeleteMenu(pjp, autoLowApp.bizType());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object == null) {
            return pjp.proceed();
        }
        return object;
    }

    private Object autoCopyAspect(ProceedingJoinPoint pjp, AutoLowApp autoLowApp) throws Throwable {
        HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
        String string = httpServletRequest.getHeader("X-Low-App-ID");
        if (oConvertUtils.isNotEmpty((Object)string)) {
            try {
                switch (autoLowApp.bizType()) {
                    case "cgform": {
                        return this.doExcudeCgformCopy(pjp, string);
                    }
                }
                return pjp.proceed();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return pjp.proceed();
    }

    private Object doExcudeDesignAdd(ProceedingJoinPoint pjp) throws Throwable {
        Object object = pjp.proceed();
        try {
            Object[] objectArray = pjp.getArgs();
            HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
            String string = httpServletRequest.getHeader("X-Low-App-ID");
            if (oConvertUtils.isNotEmpty((Object)string)) {
                Object object2 = objectArray[0];
                Class<?> clazz = object2.getClass();
                clazz.getMethod("setLowAppId", String.class).invoke(object2, string);
                String string2 = clazz.getMethod("getDesformName", new Class[0]).invoke(object2, new Object[0]).toString();
                String string3 = clazz.getMethod("getId", new Class[0]).invoke(object2, new Object[0]).toString();
                String string4 = null;
                Object object3 = clazz.getMethod("getAppMenuGroupId", new Class[0]).invoke(object2, new Object[0]);
                if (object3 != null) {
                    string4 = object3.toString();
                }
                this.saveLowAppMenu2(string, string2, string3, "form", string4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    private Object doExcudeDragAdd(ProceedingJoinPoint pjp) throws Throwable {
        Object object = null;
        try {
            Object[] objectArray = pjp.getArgs();
            HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
            String string = httpServletRequest.getHeader("X-Low-App-ID");
            if (oConvertUtils.isNotEmpty((Object)string)) {
                Object object2 = objectArray[0];
                Class<?> clazz = object2.getClass();
                clazz.getMethod("setLowAppId", String.class).invoke(object2, string);
                object = pjp.proceed();
                if (!this.isSuccess(object)) {
                    return object;
                }
                String string2 = clazz.getMethod("getName", new Class[0]).invoke(object2, new Object[0]).toString();
                String string3 = clazz.getMethod("getId", new Class[0]).invoke(object2, new Object[0]).toString();
                String string4 = null;
                Object object3 = clazz.getMethod("getAppMenuGroupId", new Class[0]).invoke(object2, new Object[0]);
                if (object3 != null) {
                    string4 = object3.toString();
                }
                this.saveLowAppMenu2(string, string2, string3, "drag", string4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object == null) {
            return pjp.proceed();
        }
        return object;
    }

    private Object doExcudeCgreportAdd(ProceedingJoinPoint pjp) throws Throwable {
        Object object = null;
        try {
            HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
            String string = httpServletRequest.getHeader("X-Low-App-ID");
            if (oConvertUtils.isNotEmpty((Object)string)) {
                Object[] objectArray = pjp.getArgs();
                OnlCgreportModel onlCgreportModel = (OnlCgreportModel)objectArray[0];
                OnlCgreportHead onlCgreportHead = onlCgreportModel.getHead();
                onlCgreportHead.setLowAppId(string);
                object = pjp.proceed();
                if (!this.isSuccess(object)) {
                    return object;
                }
                this.saveLowAppMenu(string, onlCgreportHead.getName(), onlCgreportHead.getId(), "cgreport");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object == null) {
            return pjp.proceed();
        }
        return object;
    }

    private Object doExcudeGraphreportAdd(ProceedingJoinPoint pjp) throws Throwable {
        Object object = null;
        try {
            HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
            String string = httpServletRequest.getHeader("X-Low-App-ID");
            if (oConvertUtils.isNotEmpty((Object)string)) {
                Object[] objectArray = pjp.getArgs();
                OnlGraphreportHeadPage onlGraphreportHeadPage = (OnlGraphreportHeadPage)objectArray[0];
                onlGraphreportHeadPage.setLowAppId(string);
                object = pjp.proceed();
                if (!this.isSuccess(object)) {
                    return object;
                }
                this.saveLowAppMenu(string, onlGraphreportHeadPage.getName(), onlGraphreportHeadPage.getId(), "graphreport");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object == null) {
            return pjp.proceed();
        }
        return object;
    }

    private Object doExcudeCgformAdd(ProceedingJoinPoint pjp) throws Throwable {
        Object object = null;
        try {
            HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
            String string = httpServletRequest.getHeader("X-Low-App-ID");
            if (oConvertUtils.isNotEmpty((Object)string)) {
                Object[] objectArray = pjp.getArgs();
                a a2 = (a)objectArray[0];
                OnlCgformHead onlCgformHead = a2.getHead();
                onlCgformHead.setLowAppId(string);
                object = pjp.proceed();
                if (!this.isSuccess(object)) {
                    return object;
                }
                if (!org.jeecg.modules.online.cgform.enums.a.a.equals(onlCgformHead.getTableType())) {
                    this.saveLowAppMenu(string, onlCgformHead.getTableTxt(), onlCgformHead.getId(), "cgform");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object == null) {
            return pjp.proceed();
        }
        return object;
    }

    private void saveLowAppMenu(String lowAppId, String menuName, String menuUrl, String type) {
        LowAppMenu lowAppMenu = new LowAppMenu();
        lowAppMenu.setAppId(lowAppId);
        lowAppMenu.setType(type);
        lowAppMenu.setMenuName(menuName);
        lowAppMenu.setMenuUrl(menuUrl);
        lowAppMenu.setDelFlag(CommonConstant.DEL_FLAG_0);
        this.appMenuService.saveMenu(lowAppMenu);
    }

    private void saveLowAppMenu2(String lowAppId, String menuName, String menuUrl, String type, String parentId) {
        LowAppMenu lowAppMenu = new LowAppMenu();
        lowAppMenu.setAppId(lowAppId);
        lowAppMenu.setType(type);
        lowAppMenu.setMenuName(menuName);
        lowAppMenu.setMenuUrl(menuUrl);
        lowAppMenu.setDelFlag(CommonConstant.DEL_FLAG_0);
        if (oConvertUtils.isNotEmpty((Object)parentId)) {
            lowAppMenu.setParentId(parentId);
        }
        this.appMenuService.saveMenu(lowAppMenu);
    }

    private boolean removeByMenuUrl(String[] menuUrls, String type) {
        if ("desform".equals(type)) {
            return this.appMenuService.forceRemoveByDesformId(Arrays.asList(menuUrls));
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(LowAppMenu::getType, (Object)type);
        lambdaQueryWrapper.in(LowAppMenu::getMenuUrl, Arrays.asList(menuUrls));
        return this.appMenuService.forceRemove((LambdaQueryWrapper<LowAppMenu>)lambdaQueryWrapper);
    }

    private Object autoDeleteMenu(ProceedingJoinPoint pjp, String type) throws Throwable {
        HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
        String string = httpServletRequest.getHeader("X-Low-App-ID");
        if (oConvertUtils.isNotEmpty((Object)string)) {
            Signature signature = pjp.getSignature();
            Method method = ((MethodSignature)signature).getMethod();
            Object[] objectArray = pjp.getArgs();
            String string2 = (String)objectArray[0];
            String[] stringArray = "deleteBatch".equals(method.getName()) ? string2.split(",") : new String[]{string2};
            this.removeByMenuUrl(stringArray, type);
            return pjp.proceed();
        }
        return null;
    }

    private boolean isSuccess(Object ret) {
        if (ret instanceof Result) {
            return ((Result)ret).isSuccess();
        }
        return true;
    }

    private Object doExcudeCgformSaveDbTable2Online(ProceedingJoinPoint pjp) throws Throwable {
        HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
        Object object = pjp.proceed();
        String string = httpServletRequest.getHeader("X-Low-App-ID");
        if (oConvertUtils.isNotEmpty((Object)string)) {
            Object object2 = pjp.getArgs()[0];
            OnlCgformHead onlCgformHead = new OnlCgformHead();
            onlCgformHead.setLowAppId(string);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(OnlCgformHead::getTableName, object2);
            this.cgformHeadService.update(onlCgformHead, (Wrapper)lambdaQueryWrapper);
        }
        return object;
    }

    private Object doExcudeCgformCopy(ProceedingJoinPoint pjp, String lowAppId) throws Throwable {
        OnlCgformHead onlCgformHead;
        Object object = pjp.proceed();
        if (object instanceof OnlCgformHead && oConvertUtils.isNotEmpty((Object)(onlCgformHead = (OnlCgformHead)object).getId()) && !org.jeecg.modules.online.cgform.enums.a.a.equals(onlCgformHead.getTableType())) {
            this.saveLowAppMenu(lowAppId, onlCgformHead.getTableTxt() + "_\u590d\u5236", onlCgformHead.getId(), "cgform");
        }
        return object;
    }

    private Object doExcudeDesformSubToWorksheet(ProceedingJoinPoint pjp) throws Throwable {
        HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
        Object object = pjp.proceed();
        Object object2 = pjp.getArgs()[0];
        JSONObject jSONObject = JSON.parseObject((String)JSON.toJSONString((Object)object2));
        String string = jSONObject.getString("lowAppId");
        if (oConvertUtils.isNotEmpty((Object)string)) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(LowAppMenu::getAppId, (Object)string);
            JSONObject jSONObject2 = JSON.parseObject((String)JSON.toJSONString((Object)pjp.getArgs()[2]));
            String string2 = jSONObject2.getString("id");
            String string3 = jSONObject2.getString("desformCode");
            lambdaQueryWrapper.and(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.eq(LowAppMenu::getMenuUrl, (Object)string2)).or()).eq(LowAppMenu::getMenuUrl, (Object)string3);
            });
            lambdaQueryWrapper.and(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.eq(LowAppMenu::getType, (Object)"form")).or()).eq(LowAppMenu::getType, (Object)"desform");
            });
            LowAppMenu lowAppMenu = (LowAppMenu)this.appMenuService.getOne((Wrapper)lambdaQueryWrapper);
            if (lowAppMenu == null) {
                throw new JeecgBootException("\u8868\u5355\u8bbe\u8ba1\u5668\u5b50\u8868\u8f6c\u5de5\u4f5c\u8868\u65f6\u4e3b\u8868\u5e94\u7528\u83dc\u5355\u4e22\u5931");
            }
            String string4 = jSONObject.getString("id");
            String string5 = jSONObject.getString("desformName");
            this.saveLowAppMenu2(string, string5, string4, "form", lowAppMenu.getParentId());
        }
        return object;
    }
}

