/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.pay.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.exceptions.ClientException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.jeecg.common.constant.enums.DySmsEnum;
import org.jeecg.common.constant.enums.vip.PayVipResourceEnum;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.system.vo.UserAccountInfo;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.DySmsHelper;
import org.jeecg.common.util.Md5Util;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.config.vo.WeiXinPay;
import org.jeecg.modules.pay.entity.SysVipMembership;
import org.jeecg.modules.pay.entity.SysVipPayments;
import org.jeecg.modules.pay.mapper.SysVipMembershipMapper;
import org.jeecg.modules.pay.mapper.SysVipPaymentsMapper;
import org.jeecg.modules.pay.service.ISysVipPaymentsService;
import org.jeecg.modules.pay.util.WeiXinPayUtil;
import org.jeecg.modules.pay.vo.SysPaymentsUserVo;
import org.jeecg.modules.pay.vo.WeChatPayStatusVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SysVipPaymentsServiceImpl
extends ServiceImpl<SysVipPaymentsMapper, SysVipPayments>
implements ISysVipPaymentsService {
    private static final Logger log = LoggerFactory.getLogger(SysVipPaymentsServiceImpl.class);
    @Autowired
    private SysVipPaymentsMapper sysVipPaymentsMapper;
    @Autowired
    private SysVipMembershipMapper sysVipMembershipMapper;
    @Autowired
    private ISysBaseAPI sysBaseApi;
    @Resource
    private JeecgBaseConfig jeecgBaseConfig;
    @Autowired
    private RedisUtil redisUtil;

    public SysVipPayments savePayMessage(String payNo, String buyYears, String tenantId, String resultCode, String returnCode, String transactionId, BigDecimal totalAmount, String userId, String username, String status) {
        if (oConvertUtils.isEmpty((Object)tenantId)) {
            throw new JeecgBootException("\u5f53\u524d\u79df\u6237\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\u652f\u4ed8\u4fe1\u606f\uff01");
        }
        SysVipPayments sysVipPayments = new SysVipPayments();
        sysVipPayments.setPayNo(payNo);
        sysVipPayments.setPayStatus(status);
        sysVipPayments.setPayType("weixinpay");
        sysVipPayments.setBuyType("vip");
        sysVipPayments.setBuyYears(Integer.valueOf(buyYears));
        sysVipPayments.setPayTime(new Date());
        sysVipPayments.setUserId(userId);
        sysVipPayments.setTenantId(oConvertUtils.getInt((String)tenantId));
        sysVipPayments.setReturnCode(resultCode);
        sysVipPayments.setReturnMsg(returnCode);
        sysVipPayments.setTransNo(transactionId);
        sysVipPayments.setTotalAmount(totalAmount);
        sysVipPayments.setTransFinishTime(new Date());
        sysVipPayments.setCreateTime(new Date());
        sysVipPayments.setCreateBy(username);
        this.sysVipPaymentsMapper.insert(sysVipPayments);
        return sysVipPayments;
    }

    @Override
    public void updatePayStatusCompleted(String outTradeNo, String resultCode, String returnCode, String transactionId, String totalFee, String attach) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysVipPayments::getPayNo, (Object)outTradeNo);
        SysVipPayments sysVipPayments = (SysVipPayments)this.sysVipPaymentsMapper.selectOne((Wrapper)query);
        Object payData = this.redisUtil.get("pay_" + outTradeNo);
        if (null == payData) {
            log.error("\u652f\u4ed8\u5931\u8d25\uff0c\u8be5\u8ba2\u5355\u5df2\u5931\u6548\uff01");
            return;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)payData.toString());
        if (null != sysVipPayments) {
            String[] userIds = new String[]{sysVipPayments.getUserId() + "_" + attach};
            if ("3".equals(sysVipPayments.getPayStatus())) {
                this.sysBaseApi.sendWebSocketMsg(userIds, "hasBeenProcessed");
            }
        } else {
            String buyType = jsonObject.getString("buyType");
            if ("vip".equals(buyType)) {
                String token = jsonObject.getString("token");
                String tenantId = jsonObject.getString("tenantId");
                String username = JwtUtil.getUsername((String)token);
                String payCount = jsonObject.getString("payCount");
                String userId = this.getUserIdByUsername(username);
                if (oConvertUtils.isNotEmpty((Object)userId)) {
                    String[] userIds = new String[]{userId + "_" + Md5Util.md5Encode((String)token, (String)"UTF-8")};
                    BigDecimal bigDecimal = new BigDecimal(totalFee);
                    BigDecimal divide = bigDecimal.divide(new BigDecimal(100));
                    SysVipPayments vipPayments = this.savePayMessage(outTradeNo, payCount, tenantId, resultCode, returnCode, transactionId, divide, userId, username, "3");
                    this.createOrUpdateVipMember(vipPayments, bigDecimal.toPlainString());
                    this.sysBaseApi.sendWebSocketMsg(userIds, "paySuccess");
                } else {
                    log.error("\u652f\u4ed8\u5931\u8d25\uff0c\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25,\u8ba2\u5355\u53f7\uff1a" + outTradeNo);
                }
            } else if (jsonObject.containsKey((Object)"payNo")) {
                this.addExtendPayments(jsonObject, "paySuccess", resultCode, returnCode, transactionId);
            } else {
                log.error("\u652f\u4ed8\u5931\u8d25\uff0c\u672a\u627e\u5230\u8ba2\u5355\u53f7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u8ba2\u5355\u53f7\uff1a" + outTradeNo);
            }
        }
    }

    private void callBackExtendPay(SysVipPayments sysVipPayments, String[] userIds) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysVipMembership::getTenantId, (Object)sysVipPayments.getTenantId());
        List sysVipMemberships = this.sysVipMembershipMapper.selectList((Wrapper)query);
        if (CollectionUtil.isNotEmpty((Collection)sysVipMemberships)) {
            SysVipMembership ship = (SysVipMembership)sysVipMemberships.get(0);
            SysVipMembership vipMembership = new SysVipMembership();
            vipMembership.setId(ship.getId());
            if ("sms".equals(sysVipPayments.getBuyType())) {
                int count = oConvertUtils.getInt((Object)ship.getSmsCountBuy(), (int)0) + sysVipPayments.getBuyYears();
                vipMembership.setSmsCountBuy(count);
            } else if ("file".equals(sysVipPayments.getBuyType())) {
                int count = oConvertUtils.getInt((Object)ship.getUploadSizeBuy(), (int)0) + sysVipPayments.getBuyYears();
                vipMembership.setUploadSizeBuy(count);
            } else if ("userCount".equals(sysVipPayments.getBuyType())) {
                int count = oConvertUtils.getInt((Object)ship.getUserCountBuy(), (int)0) + sysVipPayments.getBuyYears();
                vipMembership.setUserCountBuy(count);
            }
            this.sysVipMembershipMapper.updateById(vipMembership);
            this.sysBaseApi.sendWebSocketMsg(userIds, "paySuccess");
        }
    }

    @Override
    public void updatePayStatusFail(String outTradeNo, String resultCode, String returnCode, String transactionId, String attach) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysVipPayments::getPayNo, (Object)outTradeNo);
        SysVipPayments sysVipPayments = (SysVipPayments)this.sysVipPaymentsMapper.selectOne((Wrapper)query);
        if (null != sysVipPayments) {
            SysVipPayments payments = new SysVipPayments();
            payments.setPayStatus("4");
            payments.setId(sysVipPayments.getId());
            payments.setReturnCode(resultCode);
            payments.setReturnMsg(returnCode);
            payments.setTransNo(transactionId);
            payments.setTransFinishTime(new Date());
            this.sysVipPaymentsMapper.updateById(payments);
            String[] userIds = new String[]{sysVipPayments.getUserId() + "_" + attach};
            this.sysBaseApi.sendWebSocketMsg(userIds, "payFail");
        } else {
            Object payData = this.redisUtil.get("pay_" + outTradeNo);
            if (ObjectUtil.isNotEmpty((Object)payData)) {
                JSONObject jsonObject = JSONObject.parseObject((String)payData.toString());
                String buyType = jsonObject.getString("buyType");
                if ("vip".equals(buyType)) {
                    String token = jsonObject.getString("token");
                    String tenantId = jsonObject.getString("tenantId");
                    String username = JwtUtil.getUsername((String)token);
                    String payCount = jsonObject.getString("payCount");
                    String userId = this.getUserIdByUsername(username);
                    if (oConvertUtils.isNotEmpty((Object)userId)) {
                        this.savePayMessage(outTradeNo, payCount, tenantId, resultCode, returnCode, transactionId, new BigDecimal(0), userId, username, "4");
                        String[] userIds = new String[]{userId + "_" + attach};
                        this.sysBaseApi.sendWebSocketMsg(userIds, "payFail");
                    } else {
                        log.error("\u652f\u4ed8\u5931\u8d25\uff0c\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25,\u8ba2\u5355\u53f7\uff1a" + outTradeNo);
                    }
                } else {
                    this.addExtendPayments(jsonObject, "payFail", resultCode, returnCode, transactionId);
                }
                this.redisUtil.removeAll("pay_" + outTradeNo);
            } else {
                log.error("\u652f\u4ed8\u5931\u8d25\uff0c\u672a\u627e\u5230\u8ba2\u5355\u53f7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u8ba2\u5355\u53f7\uff1a" + outTradeNo);
            }
        }
    }

    @Override
    public WeChatPayStatusVo getPayStatus(String orderNo) {
        WeiXinPay weiXinPay = this.jeecgBaseConfig.getWeiXinPay();
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("appid", weiXinPay.getAppId());
        paramMap.put("mch_id", weiXinPay.getMchId());
        paramMap.put("out_trade_no", orderNo);
        paramMap.put("nonce_str", RandomUtil.randomString((int)32));
        String sign = WeiXinPayUtil.createSign("UTF-8", paramMap, weiXinPay.getApiKey());
        paramMap.put("sign", sign);
        String requestXML = WeiXinPayUtil.getRequestXml(paramMap);
        String result = WeiXinPayUtil.postData("https://api.mch.weixin.qq.com/pay/orderquery", requestXML, null);
        Map<String, String> map = WeiXinPayUtil.xmlToMap(result);
        TreeMap<Object, Object> packageParams = new TreeMap<Object, Object>();
        if (null != map) {
            for (String parameter : map.keySet()) {
                String parameterValue = map.get(parameter);
                String v = "";
                if (null != parameterValue) {
                    v = parameterValue.trim();
                }
                packageParams.put(parameter, v);
            }
        }
        String resultCode = (String)packageParams.get("result_code");
        WeChatPayStatusVo weChatPayStatusVo = new WeChatPayStatusVo();
        if (WeiXinPayUtil.isTenPaySign("UTF-8", packageParams, weiXinPay.getApiKey())) {
            if ("SUCCESS".equals(resultCode)) {
                String tradeState = (String)packageParams.get("trade_state");
                String tradeStateDesc = (String)packageParams.get("trade_state_desc");
                weChatPayStatusVo.setTradeState(tradeState);
                weChatPayStatusVo.setTradeStateDesc(tradeStateDesc);
            } else {
                String returnMsg = (String)packageParams.get("return_msg");
                weChatPayStatusVo.setReturnMsg(returnMsg);
            }
        } else {
            weChatPayStatusVo.setReturnMsg("\u7b7e\u540d\u9519\u8bef");
        }
        return weChatPayStatusVo;
    }

    private void createOrUpdateVipMember(SysVipPayments sysVipPayments, String totalFee) {
        BigDecimal totalFeeDecimal;
        String userId = sysVipPayments.getUserId();
        Integer buyYears = sysVipPayments.getBuyYears();
        BigDecimal bigDecimal = new BigDecimal(buyYears);
        BigDecimal decimal = bigDecimal.multiply(PayVipResourceEnum.NORMAL_VIP.getPrice());
        if (PayVipResourceEnum.NORMAL_VIP.getDiscount() != 0.0 && PayVipResourceEnum.NORMAL_VIP.getDiscount() != 1.0) {
            decimal = decimal.multiply(BigDecimal.valueOf(PayVipResourceEnum.NORMAL_VIP.getDiscount()));
        }
        if (decimal.compareTo(totalFeeDecimal = new BigDecimal(totalFee)) != 0) {
            for (int i = 1; i < 4; ++i) {
                BigDecimal price = new BigDecimal(i).multiply(PayVipResourceEnum.NORMAL_VIP.getPrice());
                if (decimal.compareTo(price) != 0) continue;
                buyYears = i;
                break;
            }
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysVipMembership::getTenantId, (Object)sysVipPayments.getTenantId());
        List shipList = this.sysVipMembershipMapper.selectList((Wrapper)query);
        SysVipMembership vipMembership = new SysVipMembership();
        vipMembership.setTenantId(sysVipPayments.getTenantId());
        Calendar cal = Calendar.getInstance();
        if (CollectionUtil.isNotEmpty((Collection)shipList)) {
            SysVipMembership ship = (SysVipMembership)shipList.get(0);
            Date endTime = ship.getEndTime();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date nowDate = new Date();
            try {
                nowDate = dateFormat.parse(dateFormat.format(new Date()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (nowDate.getTime() > endTime.getTime()) {
                endTime = nowDate;
            }
            cal.setTime(endTime);
            cal.add(1, buyYears);
            vipMembership.setId(ship.getId());
            vipMembership.setEndTime(cal.getTime());
            vipMembership.setMemberType(PayVipResourceEnum.NORMAL_VIP.getCode());
            this.sysVipMembershipMapper.updateById(vipMembership);
        } else {
            Date date = new Date();
            cal.setTime(date);
            cal.add(1, buyYears);
            vipMembership.setUserId(userId);
            vipMembership.setMemberType(PayVipResourceEnum.NORMAL_VIP.getCode());
            vipMembership.setStartTime(date);
            vipMembership.setEndTime(cal.getTime());
            this.sysVipMembershipMapper.insert(vipMembership);
        }
        this.sendSmsByUserId(sysVipPayments.getUserId(), vipMembership.getEndTime(), totalFee);
    }

    private void sendSmsByUserId(String userId, Date endTime, String totalFee) {
        LoginUser loginUser = this.sysBaseApi.getUserById(userId);
        BigDecimal divide = new BigDecimal(totalFee).divide(new BigDecimal(100));
        JSONObject param = new JSONObject();
        param.put("realname", (Object)oConvertUtils.getString((String)loginUser.getRealname(), (String)loginUser.getPhone()));
        param.put("money", (Object)(divide.toPlainString() + "\u5143"));
        param.put("endTime", (Object)DateUtils.formatDate((Date)endTime, (String)"yyyy\u5e74MM\u6708dd\u65e5"));
        try {
            DySmsHelper.sendSms((String)loginUser.getPhone(), (JSONObject)param, (DySmsEnum)DySmsEnum.PAY_SUCCESS_NOTICE_CODE);
        }
        catch (ClientException e) {
            log.error("\u77ed\u4fe1\u63a5\u53e3\u672a\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
    }

    @Override
    public void updatePayStatusRefund(String id, String refundId, Integer buyYears, SysVipMembership sysVipMembership, String buyType) {
        SysVipPayments sysVipPayments = new SysVipPayments();
        sysVipPayments.setId(id);
        sysVipPayments.setPayStatus("5");
        sysVipPayments.setRefundId(refundId);
        this.sysVipPaymentsMapper.updateById(sysVipPayments);
        if ("sms".equals(buyType) || "file".equals(buyType) || "userCount".equals(buyType)) {
            this.updateBuyExtend(buyType, buyYears, sysVipMembership);
            return;
        }
        Date endTime = sysVipMembership.getEndTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endTime);
        calendar.add(1, -buyYears.intValue());
        SysVipMembership vipPayments = new SysVipMembership();
        vipPayments.setId(sysVipMembership.getId());
        vipPayments.setEndTime(calendar.getTime());
        try {
            String yyyyMMdd = DateUtils.getDate((String)"yyyyMMdd");
            Date date = DateUtils.parseDate((String)yyyyMMdd, (String)"yyyyMMdd");
            long nowTime = date.getTime();
            long time = calendar.getTime().getTime();
            if (time <= nowTime) {
                vipPayments.setMemberType(PayVipResourceEnum.DEFAULT.getCode());
            }
            this.sysVipMembershipMapper.updateById(vipPayments);
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u683c\u5f0f\u5316\u5931\u8d25");
        }
    }

    public void saveExtendPayments(JSONObject jsonObject, String resultCode, String returnCode, String transactionId, String userId, String[] userIds, String payStatus, String username) {
        String tenantId = jsonObject.getString("tenantId");
        String buyType = jsonObject.getString("buyType");
        int buyValue = jsonObject.getIntValue("payCount");
        BigDecimal price = jsonObject.getBigDecimal("payPrice");
        String payNo = jsonObject.getString("payNo");
        SysVipPayments sysVipPayments = new SysVipPayments();
        sysVipPayments.setTotalAmount(price);
        sysVipPayments.setPayNo(payNo);
        sysVipPayments.setBuyYears(buyValue);
        String payFail = "4";
        if ("paySuccess".equals(payStatus)) {
            payFail = "3";
        }
        sysVipPayments.setPayStatus(payFail);
        sysVipPayments.setPayType("weixinpay");
        sysVipPayments.setBuyType(buyType);
        sysVipPayments.setPayTime(new Date());
        sysVipPayments.setUserId(userId);
        sysVipPayments.setTenantId(Integer.valueOf(tenantId));
        sysVipPayments.setReturnCode(resultCode);
        sysVipPayments.setReturnMsg(returnCode);
        sysVipPayments.setTransNo(transactionId);
        sysVipPayments.setTransFinishTime(new Date());
        sysVipPayments.setCreateBy(username);
        sysVipPayments.setCreateTime(new Date());
        this.sysVipPaymentsMapper.insert(sysVipPayments);
        if ("paySuccess".equals(payStatus)) {
            this.callBackExtendPay(sysVipPayments, userIds);
        } else {
            this.sysBaseApi.sendWebSocketMsg(userIds, "payFail");
        }
    }

    private void updateBuyExtend(String buyType, Integer buyYears, SysVipMembership sysVipMembership) {
        Integer userCountBuy;
        SysVipMembership membership = new SysVipMembership();
        membership.setId(sysVipMembership.getId());
        if ("sms".equals(buyType)) {
            Integer smsCountBuy = sysVipMembership.getSmsCountBuy();
            if (smsCountBuy >= buyYears) {
                membership.setSmsCountBuy(smsCountBuy - buyYears);
                this.sysVipMembershipMapper.updateById(membership);
            }
        } else if ("file".equals(buyType)) {
            Integer uploadSizeBuy = sysVipMembership.getUploadSizeBuy();
            if (uploadSizeBuy >= buyYears) {
                membership.setUploadSizeBuy(uploadSizeBuy - buyYears);
                this.sysVipMembershipMapper.updateById(membership);
            }
        } else if ("userCount".equals(buyType) && (userCountBuy = sysVipMembership.getUserCountBuy()) >= buyYears) {
            membership.setUserCountBuy(userCountBuy - buyYears);
            this.sysVipMembershipMapper.updateById(membership);
        }
    }

    @Override
    public IPage<SysPaymentsUserVo> pagePaymentsList(Page<SysPaymentsUserVo> page, SysPaymentsUserVo sysPaymentsUserVo, String startTime, String entTime) {
        return this.sysVipPaymentsMapper.pagePaymentsList(page, sysPaymentsUserVo, startTime, entTime);
    }

    private void addExtendPayments(JSONObject jsonObject, String payStatus, String resultCode, String returnCode, String transactionId) {
        if (!CollectionUtils.isEmpty((Map)jsonObject)) {
            String token = jsonObject.getString("token");
            String username = JwtUtil.getUsername((String)token);
            List userAccountInfos = this.sysBaseApi.queryUserByNames(new String[]{username});
            if (!CollectionUtils.isEmpty((Collection)userAccountInfos)) {
                String userId = ((UserAccountInfo)userAccountInfos.get(0)).getId();
                String[] userIds = new String[]{userId + "_" + Md5Util.md5Encode((String)token, (String)"UTF-8")};
                this.saveExtendPayments(jsonObject, resultCode, returnCode, transactionId, userId, userIds, payStatus, username);
            } else {
                log.error("\u652f\u4ed8\u4fe1\u606f\u672a\u627e\u5230\uff1a");
            }
        }
    }

    @Override
    public Long izHaveBuyAuth(Integer tenantId, String userId) {
        return this.sysVipPaymentsMapper.izHaveBuyAuth(tenantId, userId);
    }

    private String getUserIdByUsername(String username) {
        List userAccountInfos = this.sysBaseApi.queryUserByNames(new String[]{username});
        if (!CollectionUtils.isEmpty((Collection)userAccountInfos)) {
            return ((UserAccountInfo)userAccountInfos.get(0)).getId();
        }
        return "";
    }
}

