/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.math.BigInteger;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;
import schemasMicrosoftComVml.CTShape;

public class XSSFComment
implements Comment {
    private final CTComment _comment;
    private final CommentsTable _comments;
    private final CTShape _vmlShape;
    private XSSFRichTextString _str;

    public XSSFComment(CommentsTable comments, CTComment comment, CTShape vmlShape) {
        this._comment = comment;
        this._comments = comments;
        this._vmlShape = vmlShape;
    }

    public String getAuthor() {
        return this._comments.getAuthor((int)this._comment.getAuthorId());
    }

    public void setAuthor(String author) {
        this._comment.setAuthorId((long)this._comments.findAuthor(author));
    }

    public int getColumn() {
        return new CellReference(this._comment.getRef()).getCol();
    }

    public int getRow() {
        return new CellReference(this._comment.getRef()).getRow();
    }

    public boolean isVisible() {
        boolean visible = false;
        if (this._vmlShape != null) {
            String style = this._vmlShape.getStyle();
            visible = style != null && style.indexOf("visibility:visible") != -1;
        }
        return visible;
    }

    public void setVisible(boolean visible) {
        if (this._vmlShape != null) {
            String style = visible ? "position:absolute;visibility:visible" : "position:absolute;visibility:hidden";
            this._vmlShape.setStyle(style);
        }
    }

    public void setColumn(int col) {
        String oldRef = this._comment.getRef();
        CellReference ref = new CellReference(this.getRow(), col);
        this._comment.setRef(ref.formatAsString());
        this._comments.referenceUpdated(oldRef, this._comment);
        if (this._vmlShape != null) {
            this._vmlShape.getClientDataArray(0).setColumnArray(new BigInteger[]{new BigInteger(String.valueOf(col))});
            this._vmlShape.getClientDataList().toString();
        }
    }

    public void setRow(int row) {
        String oldRef = this._comment.getRef();
        String newRef = new CellReference(row, this.getColumn()).formatAsString();
        this._comment.setRef(newRef);
        this._comments.referenceUpdated(oldRef, this._comment);
        if (this._vmlShape != null) {
            this._vmlShape.getClientDataArray(0).setRowArray(0, new BigInteger(String.valueOf(row)));
            this._vmlShape.getClientDataList().toString();
        }
    }

    public XSSFRichTextString getString() {
        CTRst rst;
        if (this._str == null && (rst = this._comment.getText()) != null) {
            this._str = new XSSFRichTextString(this._comment.getText());
        }
        return this._str;
    }

    public void setString(RichTextString string) {
        if (!(string instanceof XSSFRichTextString)) {
            throw new IllegalArgumentException("Only XSSFRichTextString argument is supported");
        }
        this._str = (XSSFRichTextString)string;
        this._comment.setText(this._str.getCTRst());
    }

    public void setString(String string) {
        this.setString(new XSSFRichTextString(string));
    }

    public ClientAnchor getClientAnchor() {
        String position = this._vmlShape.getClientDataArray(0).getAnchorArray(0);
        int[] pos = new int[8];
        int i = 0;
        for (String s : position.split(",")) {
            pos[i++] = Integer.parseInt(s.trim());
        }
        XSSFClientAnchor ca = new XSSFClientAnchor(pos[1] * 9525, pos[3] * 9525, pos[5] * 9525, pos[7] * 9525, pos[0], pos[2], pos[4], pos[6]);
        return ca;
    }

    protected CTComment getCTComment() {
        return this._comment;
    }

    protected CTShape getCTShape() {
        return this._vmlShape;
    }
}

