/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.wtp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.wtp.AbstractWtpResourceWriter;
import org.apache.maven.plugin.ide.IdeUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class EclipseWtpComponentWriter
extends AbstractWtpResourceWriter {
    public static final String ATTR_CONTEXT_ROOT = "context-root";
    public static final String DIR_WTP_SETTINGS = ".settings";

    protected String getComponentFileName() {
        return ".component";
    }

    protected String getProjectVersion() {
        return null;
    }

    public void write() throws MojoExecutionException {
        OutputStreamWriter w;
        File settingsDir = new File(this.config.getEclipseProjectDirectory(), DIR_WTP_SETTINGS);
        settingsDir.mkdirs();
        try {
            w = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(settingsDir, this.getComponentFileName())), "UTF-8");
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w);
        this.writeModuleTypeComponent((XMLWriter)writer, this.config.getPackaging(), this.config.getBuildOutputDirectory(), this.config.getSourceDirs(), this.config.getLocalRepository());
        IOUtil.close((Writer)w);
    }

    private void writeModuleTypeComponent(XMLWriter writer, String packaging, File buildOutputDirectory, EclipseSourceDir[] sourceDirs, ArtifactRepository localRepository) throws MojoExecutionException {
        writer.startElement("project-modules");
        writer.addAttribute("id", "moduleCoreId");
        if (this.getProjectVersion() != null) {
            writer.addAttribute("project-version", this.getProjectVersion());
        }
        writer.startElement("wb-module");
        writer.addAttribute("deploy-name", this.config.getEclipseProjectName());
        String target = "/";
        if ("war".equalsIgnoreCase(packaging)) {
            target = "/WEB-INF/classes";
            File warSourceDirectory = new File(IdeUtils.getPluginSetting(this.config.getProject(), "org.apache.maven.plugins:maven-war-plugin", "warSourceDirectory", this.config.getProject().getBasedir() + "/src/main/webapp"));
            this.writeContextRoot(writer);
            writer.startElement("wb-resource");
            writer.addAttribute("deploy-path", "/");
            writer.addAttribute("source-path", IdeUtils.toRelativeAndFixSeparator(this.config.getEclipseProjectDirectory(), warSourceDirectory, false));
            writer.endElement();
            writer.startElement("property");
            writer.addAttribute("name", "java-output-path");
            writer.addAttribute("value", "/" + IdeUtils.toRelativeAndFixSeparator(this.config.getProject().getBasedir(), buildOutputDirectory, false));
            writer.endElement();
        } else if ("ear".equalsIgnoreCase(packaging)) {
            String defaultApplicationXML = this.config.getWtpapplicationxml() ? "/target/eclipseEar" : "/src/main/application";
            String earSourceDirectory = IdeUtils.getPluginSetting(this.config.getProject(), "org.apache.maven.plugins:maven-ear-plugin", "earSourceDirectory", this.config.getProject().getBasedir() + defaultApplicationXML);
            writer.startElement("wb-resource");
            writer.addAttribute("deploy-path", "/");
            writer.addAttribute("source-path", IdeUtils.toRelativeAndFixSeparator(this.config.getEclipseProjectDirectory(), new File(earSourceDirectory), false));
            writer.endElement();
        }
        if ("war".equalsIgnoreCase(packaging) || "ear".equalsIgnoreCase(packaging)) {
            this.writeWarOrEarResources(writer, this.config.getProject(), localRepository);
        }
        for (int j = 0; j < sourceDirs.length; ++j) {
            EclipseSourceDir dir = sourceDirs[j];
            if (dir.isTest()) continue;
            writer.startElement("wb-resource");
            writer.addAttribute("deploy-path", target);
            writer.addAttribute("source-path", dir.getPath());
            writer.endElement();
        }
        writer.endElement();
        writer.endElement();
    }

    protected void writeContextRoot(XMLWriter writer) {
        writer.startElement("property");
        writer.addAttribute(ATTR_CONTEXT_ROOT, this.config.getContextName());
        writer.endElement();
    }
}

