/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.Resources;

public class ResourceUsage {
    private ReentrantReadWriteLock.ReadLock readLock;
    private ReentrantReadWriteLock.WriteLock writeLock;
    private Map<String, UsageByLabel> usages;
    private static final String NL = "";

    public ResourceUsage() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.usages = new HashMap<String, UsageByLabel>();
    }

    public Resource getUsed() {
        return this.getUsed(NL);
    }

    public Resource getUsed(String label) {
        return this._get(label, ResourceType.USED);
    }

    public void incUsed(String label, Resource res) {
        this._inc(label, ResourceType.USED, res);
    }

    public void incUsed(Resource res) {
        this.incUsed(NL, res);
    }

    public void decUsed(Resource res) {
        this.decUsed(NL, res);
    }

    public void decUsed(String label, Resource res) {
        this._dec(label, ResourceType.USED, res);
    }

    public void setUsed(Resource res) {
        this.setUsed(NL, res);
    }

    public void setUsed(String label, Resource res) {
        this._set(label, ResourceType.USED, res);
    }

    public Resource getPending() {
        return this.getPending(NL);
    }

    public Resource getPending(String label) {
        return this._get(label, ResourceType.PENDING);
    }

    public void incPending(String label, Resource res) {
        this._inc(label, ResourceType.PENDING, res);
    }

    public void incPending(Resource res) {
        this.incPending(NL, res);
    }

    public void decPending(Resource res) {
        this.decPending(NL, res);
    }

    public void decPending(String label, Resource res) {
        this._dec(label, ResourceType.PENDING, res);
    }

    public void setPending(Resource res) {
        this.setPending(NL, res);
    }

    public void setPending(String label, Resource res) {
        this._set(label, ResourceType.PENDING, res);
    }

    public Resource getReserved() {
        return this.getReserved(NL);
    }

    public Resource getReserved(String label) {
        return this._get(label, ResourceType.RESERVED);
    }

    public void incReserved(String label, Resource res) {
        this._inc(label, ResourceType.RESERVED, res);
    }

    public void incReserved(Resource res) {
        this.incReserved(NL, res);
    }

    public void decReserved(Resource res) {
        this.decReserved(NL, res);
    }

    public void decReserved(String label, Resource res) {
        this._dec(label, ResourceType.RESERVED, res);
    }

    public void setReserved(Resource res) {
        this.setReserved(NL, res);
    }

    public void setReserved(String label, Resource res) {
        this._set(label, ResourceType.RESERVED, res);
    }

    public Resource getHeadroom() {
        return this.getHeadroom(NL);
    }

    public Resource getHeadroom(String label) {
        return this._get(label, ResourceType.HEADROOM);
    }

    public void incHeadroom(String label, Resource res) {
        this._inc(label, ResourceType.HEADROOM, res);
    }

    public void incHeadroom(Resource res) {
        this.incHeadroom(NL, res);
    }

    public void decHeadroom(Resource res) {
        this.decHeadroom(NL, res);
    }

    public void decHeadroom(String label, Resource res) {
        this._dec(label, ResourceType.HEADROOM, res);
    }

    public void setHeadroom(Resource res) {
        this.setHeadroom(NL, res);
    }

    public void setHeadroom(String label, Resource res) {
        this._set(label, ResourceType.HEADROOM, res);
    }

    public Resource getAMUsed() {
        return this.getAMUsed(NL);
    }

    public Resource getAMUsed(String label) {
        return this._get(label, ResourceType.AMUSED);
    }

    public void incAMUsed(String label, Resource res) {
        this._inc(label, ResourceType.AMUSED, res);
    }

    public void incAMUsed(Resource res) {
        this.incAMUsed(NL, res);
    }

    public void decAMUsed(Resource res) {
        this.decAMUsed(NL, res);
    }

    public void decAMUsed(String label, Resource res) {
        this._dec(label, ResourceType.AMUSED, res);
    }

    public void setAMUsed(Resource res) {
        this.setAMUsed(NL, res);
    }

    public void setAMUsed(String label, Resource res) {
        this._set(label, ResourceType.AMUSED, res);
    }

    private static Resource normalize(Resource res) {
        if (res == null) {
            return Resources.none();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource _get(String label, ResourceType type) {
        try {
            this.readLock.lock();
            UsageByLabel usage = this.usages.get(label);
            if (null == usage) {
                Resource resource = Resources.none();
                return resource;
            }
            Resource resource = ResourceUsage.normalize(usage.resArr[type.idx]);
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private UsageByLabel getAndAddIfMissing(String label) {
        if (!this.usages.containsKey(label)) {
            UsageByLabel u = new UsageByLabel(label);
            this.usages.put(label, u);
            return u;
        }
        return this.usages.get(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _set(String label, ResourceType type, Resource res) {
        try {
            this.writeLock.lock();
            UsageByLabel usage = this.getAndAddIfMissing(label);
            ((UsageByLabel)usage).resArr[((ResourceType)type).idx] = res;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _inc(String label, ResourceType type, Resource res) {
        try {
            this.writeLock.lock();
            UsageByLabel usage = this.getAndAddIfMissing(label);
            Resources.addTo((Resource)usage.resArr[type.idx], (Resource)res);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _dec(String label, ResourceType type, Resource res) {
        try {
            this.writeLock.lock();
            UsageByLabel usage = this.getAndAddIfMissing(label);
            Resources.subtractFrom((Resource)usage.resArr[type.idx], (Resource)res);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static class UsageByLabel {
        private Resource[] resArr = new Resource[ResourceType.values().length];

        public UsageByLabel(String label) {
            for (int i = 0; i < this.resArr.length; ++i) {
                this.resArr[i] = Resource.newInstance((int)0, (int)0);
            }
        }
    }

    private static enum ResourceType {
        USED(0),
        PENDING(1),
        AMUSED(2),
        RESERVED(3),
        HEADROOM(4);

        private int idx;

        private ResourceType(int value) {
            this.idx = value;
        }
    }
}

