/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.tools.common.AbstractCXFToolContainer;
import org.apache.cxf.tools.common.CommandInterfaceUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolRunner;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.CommandDocument;
import org.apache.cxf.tools.common.toolspec.parser.CommandLineError;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.validator.internal.WSDL11Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLValidator
extends AbstractCXFToolContainer {
    private static final String TOOL_NAME = "wsdlvalidator";

    public WSDLValidator(ToolSpec toolspec) throws Exception {
        super(TOOL_NAME, toolspec);
    }

    private Set<String> getArrayKeys() {
        HashSet<String> set = new HashSet<String>();
        set.add("schemaURL");
        return set;
    }

    public boolean executeForMaven() {
        super.execute(false);
        ToolContext env = this.getContext();
        env.setParameters(this.getParametersMap(this.getArrayKeys()));
        if (this.isVerboseOn()) {
            env.put("verbose", (Object)Boolean.TRUE);
        }
        env.put("validate", (Object)Boolean.TRUE);
        env.put("args", (Object)this.getArgument());
        WSDL11Validator wsdlValidator = new WSDL11Validator(null, env, this.getBus());
        return wsdlValidator.isValid();
    }

    public void execute(boolean exitOnFinish) {
        block8: {
            try {
                super.execute(exitOnFinish);
                if (!this.hasInfoOption()) {
                    ToolContext env = this.getContext();
                    env.setParameters(this.getParametersMap(this.getArrayKeys()));
                    if (this.isVerboseOn()) {
                        env.put("verbose", (Object)Boolean.TRUE);
                    }
                    env.put("validate", (Object)Boolean.TRUE);
                    env.put("args", (Object)this.getArgument());
                    WSDL11Validator wsdlValidator = new WSDL11Validator(null, env, this.getBus());
                    if (wsdlValidator.isValid()) {
                        System.out.println("Passed Validation : Valid WSDL ");
                    }
                }
            }
            catch (ToolException ex) {
                this.err.println("WSDLValidator Error : " + ex.getMessage());
                if (ex.getCause() instanceof BadUsageException) {
                    this.printUsageException(TOOL_NAME, (BadUsageException)ex.getCause());
                }
                this.err.println();
                if (this.isVerboseOn()) {
                    this.err.println("[+] Verbose turned on");
                    this.err.println();
                    ex.printStackTrace(this.err);
                }
            }
            catch (Exception ex) {
                this.err.println("WSDLValidator Error : " + ex.getMessage());
                this.err.println();
                if (!this.isVerboseOn()) break block8;
                this.err.println("[+] Verbose turned on");
                this.err.println();
                ex.printStackTrace(this.err);
            }
        }
    }

    public static void main(String[] pargs) {
        CommandInterfaceUtils.commandCommonMain();
        try {
            ToolRunner.runTool(WSDLValidator.class, (InputStream)WSDLValidator.class.getResourceAsStream("wsdlvalidator.xml"), (boolean)false, (String[])pargs);
        }
        catch (Exception ex) {
            System.err.println("Error : " + ex.getMessage());
            System.err.println();
            ex.printStackTrace();
        }
    }

    public void checkParams(ErrorVisitor errors) throws ToolException {
        CommandDocument doc = super.getCommandDocument();
        if (!doc.hasParameter("wsdlurl")) {
            errors.add((CommandLineError)new ErrorVisitor.UserError("WSDL/SCHEMA URL has to be specified"));
        }
        if (errors.getErrors().size() > 0) {
            Message msg = new Message("PARAMETER_MISSING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)new BadUsageException(this.getUsage(), errors));
        }
    }
}

