/** 自动判断关闭方式 */
function handleAutoClose() {
  // 如果是在微信内，就等待微信的JS注入完成之后再执行关闭
  if (BrowserTypes.isWeChat()) {
    var count = 0

    function handler() {
      // 如果一秒后还未注入完成就无论如何都强行关闭网页
      if (count++ === 10 || window.WeixinJSBridge) {
        clearInterval(timer)
        doClose()
      }
    }

    var timer = setInterval(handler, 100)
    handler()

  } else {
    doClose()
  }
}

function doClose() {
  var ua = navigator.userAgent.toLowerCase()
  // App
  var uaApp = ua.includes('bestore')
  // 安卓浏览器
  var uaAndroid = ua.includes('android')
  // IOS浏览器
  var uaIos = /iphone|ipad|ipod/i.test(ua)
  // 判断关闭方式
  if (window.WeixinJSBridge) {
    window.WeixinJSBridge.call('closeWindow') // 微信
  } else if (window.AlipayJSBridge) {
    window.AlipayJSBridge.call('closeWebview') // 支付宝
  } else if (uaApp && uaAndroid) {
    window.obj.closePageLppzRequest('') // 安卓app
  } else if (uaApp && uaIos) {
    window.webkit.messageHandlers.closePageLppzRequest.postMessage('') //ios app
  } else {
    window.close()
  }
  setTimeout(function () {
    // 如果是在 iframe里面，则走返回逻辑
    handleBack()
  }, 300)
}

/** 返回上一页并刷新 */
function handleBack() {
  location.href = document.referrer
}

window.onload = function () {
  document.getElementById('closeBtn').style.display = null
}
