/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.aspect;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang.StreamUtils;
import org.apache.commons.lang.StringUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.extbpm.a.a;
import org.jeecg.modules.extbpm.a.d;
import org.jeecg.modules.extbpm.a.e;
import org.jeecg.modules.extbpm.process.pojo.DepInfo;
import org.jeecg.modules.extbpm.process.pojo.RoleInfo;
import org.jeecg.modules.extbpm.process.pojo.UserInfo;
import org.jeecg.modules.extbpm.process.service.IExtActProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Aspect
@Component(value="sysUserAspect")
public class SysUserAspect {
    private static final Logger log = LoggerFactory.getLogger(SysUserAspect.class);
    @Lazy
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    private IExtActProcessService extActProcessService;
    private static String[] ST;

    @Pointcut(value="execution(public * org.jeecg.modules.*.controller.SysUserController.add(..))")
    public void excudeServiceAdd() {
    }

    @Around(value="excudeServiceAdd()")
    public Object doAroundAdd(ProceedingJoinPoint pjp) throws Throwable {
        Object object = pjp.proceed();
        try {
            Object[] objectArray = pjp.getArgs();
            JSONObject jSONObject = (JSONObject)objectArray[0];
            String string = jSONObject.getString("username");
            LoginUser loginUser = this.sysBaseAPI.getUserByName(string);
            if (loginUser != null && CommonConstant.ACT_SYNC_1.equals(loginUser.getActivitiSync())) {
                UserInfo userInfo = new UserInfo();
                userInfo.setUuid(loginUser.getId());
                userInfo.setFirstName(loginUser.getRealname());
                userInfo.setEmail(loginUser.getEmail());
                userInfo.setId(loginUser.getUsername());
                List<RoleInfo> list = this.extActProcessService.getSysRolesByUserId(userInfo.getUuid());
                List<DepInfo> list2 = this.extActProcessService.getSysDepsByUserId(userInfo.getUuid());
                this.extActProcessService.saveActIdMembership(userInfo, list, list2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    @Pointcut(value="execution(public * org.jeecg.modules.*.controller.SysUserController.edit(..))")
    public void excudeServiceEdit() {
    }

    @Around(value="excudeServiceEdit()")
    public Object doAroundEdit(ProceedingJoinPoint pjp) throws Throwable {
        Object object = pjp.proceed();
        try {
            Object[] objectArray = pjp.getArgs();
            JSONObject jSONObject = (JSONObject)objectArray[0];
            String string = jSONObject.getString("username");
            LoginUser loginUser = this.sysBaseAPI.getUserByName(string);
            if (loginUser != null) {
                if (CommonConstant.ACT_SYNC_1.equals(loginUser.getActivitiSync())) {
                    UserInfo userInfo = new UserInfo();
                    userInfo.setUuid(loginUser.getId());
                    userInfo.setFirstName(loginUser.getRealname());
                    userInfo.setEmail(loginUser.getEmail());
                    userInfo.setId(loginUser.getUsername());
                    List<RoleInfo> list = this.extActProcessService.getSysRolesByUserId(userInfo.getUuid());
                    List<DepInfo> list2 = this.extActProcessService.getSysDepsByUserId(userInfo.getUuid());
                    this.extActProcessService.saveActIdMembership(userInfo, list, list2);
                } else {
                    this.extActProcessService.deleteActIdMembership(string);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    @Pointcut(value="execution(public * org.jeecg.modules.*.controller.SysUserController.putRecycleBin(..))")
    public void excudeServicePutRecycleBin() {
    }

    @Around(value="excudeServicePutRecycleBin()")
    public Object doAroundPutRecycleBin(ProceedingJoinPoint pjp) throws Throwable {
        Object object = pjp.proceed();
        try {
            Object[] objectArray = pjp.getArgs();
            JSONObject jSONObject = (JSONObject)objectArray[0];
            String string = jSONObject.getString("userIds");
            if (a.b(string)) {
                List list = this.sysBaseAPI.queryAllUserByIds(string.split(","));
                for (LoginUser loginUser : list) {
                    if (!CommonConstant.ACT_SYNC_1.equals(loginUser.getActivitiSync())) continue;
                    UserInfo userInfo = new UserInfo();
                    userInfo.setUuid(loginUser.getId());
                    userInfo.setFirstName(loginUser.getRealname());
                    userInfo.setEmail(loginUser.getEmail());
                    userInfo.setId(loginUser.getUsername());
                    List<RoleInfo> list2 = this.extActProcessService.getSysRolesByUserId(userInfo.getUuid());
                    List<DepInfo> list3 = this.extActProcessService.getSysDepsByUserId(userInfo.getUuid());
                    this.extActProcessService.saveActIdMembership(userInfo, list2, list3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public static void lastIndexOf() {
        try {
            Object object;
            if (ST == null || ST.length == 0) {
                object = a.a();
                if (object == null) {
                    object = ResourceBundle.getBundle(d.d());
                }
                ST = StreamUtils.isr() ? new String[]{StringUtil.dl()} : ((ResourceBundle)object).getString(d.f()).split(",");
            }
            if (!a.b(ST, e.b()) && !a.b(ST, e.a())) {
                System.out.println(d.h() + e.c());
                object = d.j();
                System.err.println((String)object);
                System.exit(0);
            }
        }
        catch (Exception exception) {
            try {
                System.out.println(d.h() + e.c());
                String string = d.j();
                System.err.println(string);
                System.exit(0);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Pointcut(value="execution(public * org.jeecg.modules.*.controller.SysUserController.delete(..))")
    public void excudeServiceDelete() {
    }

    @Around(value="excudeServiceDelete()")
    public Object doAroundDelete(ProceedingJoinPoint pjp) throws Throwable {
        Object object;
        try {
            object = pjp.getArgs();
            String string = (String)object[0];
            LoginUser loginUser = this.sysBaseAPI.getUserById(string);
            if (loginUser != null) {
                this.extActProcessService.deleteActIdMembership(loginUser.getUsername());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = pjp.proceed();
        return object;
    }

    @Pointcut(value="execution(public * org.jeecg.modules.*.controller.SysUserController.deleteBatch(..))")
    public void excudeServiceDeleteBatch() {
    }

    @Around(value="excudeServiceDeleteBatch()")
    public Object doAroundDeleteBatch(ProceedingJoinPoint pjp) throws Throwable {
        Object object;
        try {
            String[] stringArray;
            object = pjp.getArgs();
            String string = (String)object[0];
            for (String string2 : stringArray = string.split(",")) {
                LoginUser loginUser = this.sysBaseAPI.getUserById(string2);
                if (loginUser == null) continue;
                this.extActProcessService.deleteActIdMembership(loginUser.getUsername());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = pjp.proceed();
        return object;
    }

    static {
        SysUserAspect.lastIndexOf();
        ST = null;
    }
}

