/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import java.util.HashMap;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.task.Task;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.task.TaskActionRequest;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.activiti.rest.service.api.runtime.task.TaskRequest;
import org.activiti.rest.service.api.runtime.task.TaskResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.Put;
import org.restlet.resource.ResourceException;

public class TaskResource
extends TaskBaseResource {
    @Get
    public TaskResponse getTask() {
        if (!this.authenticate()) {
            return null;
        }
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createTaskResponse(this, this.getTaskFromRequest());
    }

    @Put
    public TaskResponse updateTask(TaskRequest taskRequest) {
        if (!this.authenticate()) {
            return null;
        }
        if (taskRequest == null) {
            throw new ResourceException(new Status(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE.getCode(), "A request body was expected when updating the task.", null, null));
        }
        Task task = this.getTaskFromRequest();
        this.populateTaskFromRequest(task, taskRequest);
        ActivitiUtil.getTaskService().saveTask(task);
        task = (Task)ActivitiUtil.getTaskService().createTaskQuery().taskId(task.getId()).singleResult();
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createTaskResponse(this, task);
    }

    @Post
    public void executeTaskAction(TaskActionRequest actionRequest) {
        if (!this.authenticate()) {
            return;
        }
        if (actionRequest == null) {
            throw new ResourceException(new Status(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE.getCode(), "A request body was expected when executing a task action.", null, null));
        }
        Task task = this.getTaskFromRequest();
        if ("complete".equals(actionRequest.getAction())) {
            this.completeTask(task, actionRequest);
        } else if ("claim".equals(actionRequest.getAction())) {
            this.claimTask(task, actionRequest);
        } else if ("delegate".equals(actionRequest.getAction())) {
            this.delegateTask(task, actionRequest);
        } else if ("resolve".equals(actionRequest.getAction())) {
            this.resolveTask(task, actionRequest);
        } else {
            throw new ActivitiIllegalArgumentException("Invalid action: '" + actionRequest.getAction() + "'.");
        }
    }

    @Delete
    public void deleteTask() {
        if (!this.authenticate()) {
            return;
        }
        Form query = this.getQuery();
        Boolean cascadeHistory = this.getQueryParameterAsBoolean("cascadeHistory", query);
        String deleteReason = this.getQueryParameter("deleteReason", query);
        Task taskToDelete = this.getTaskFromRequest();
        if (taskToDelete.getExecutionId() != null) {
            throw new ResourceException(new Status(Status.CLIENT_ERROR_FORBIDDEN.getCode(), "Cannot delete a task that is part of a process-instance.", null, null));
        }
        if (cascadeHistory != null) {
            ActivitiUtil.getTaskService().deleteTask(taskToDelete.getId(), cascadeHistory.booleanValue());
        } else {
            ActivitiUtil.getTaskService().deleteTask(taskToDelete.getId(), deleteReason);
        }
        this.getResponse().setStatus(Status.SUCCESS_NO_CONTENT);
    }

    protected void completeTask(Task task, TaskActionRequest actionRequest) {
        if (actionRequest.getVariables() != null) {
            HashMap<String, Object> variablesToSet = new HashMap<String, Object>();
            for (RestVariable var : actionRequest.getVariables()) {
                if (var.getName() == null) {
                    throw new ActivitiIllegalArgumentException("Variable name is required");
                }
                Object actualVariableValue = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().getVariableValue(var);
                variablesToSet.put(var.getName(), actualVariableValue);
            }
            ActivitiUtil.getTaskService().complete(task.getId(), variablesToSet);
        } else {
            ActivitiUtil.getTaskService().complete(task.getId());
        }
    }

    protected void resolveTask(Task task, TaskActionRequest actionRequest) {
        ActivitiUtil.getTaskService().resolveTask(task.getId());
    }

    protected void delegateTask(Task task, TaskActionRequest actionRequest) {
        if (actionRequest.getAssignee() == null) {
            throw new ActivitiIllegalArgumentException("An assignee is required when delegating a task.");
        }
        ActivitiUtil.getTaskService().delegateTask(task.getId(), actionRequest.getAssignee());
    }

    protected void claimTask(Task task, TaskActionRequest actionRequest) {
        ActivitiUtil.getTaskService().claim(task.getId(), actionRequest.getAssignee());
    }
}

