/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.task.Attachment;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.engine.AttachmentResponse;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;

public class TaskAttachmentResource
extends TaskBaseResource {
    @Get
    public AttachmentResponse getAttachment() {
        if (!this.authenticate()) {
            return null;
        }
        HistoricTaskInstance task = this.getHistoricTaskFromRequest();
        String attachmentId = this.getAttribute("attachmentId");
        if (attachmentId == null) {
            throw new ActivitiIllegalArgumentException("AttachmentId is required.");
        }
        Attachment attachment = ActivitiUtil.getTaskService().getAttachment(attachmentId);
        if (attachment == null || !task.getId().equals(attachment.getTaskId())) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have an attachment with id '" + attachmentId + "'.", Comment.class);
        }
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createAttachmentResponse(this, attachment);
    }

    @Delete
    public void deleteAttachment() {
        if (!this.authenticate()) {
            return;
        }
        Task task = this.getTaskFromRequest();
        String attachmentId = this.getAttribute("attachmentId");
        if (attachmentId == null) {
            throw new ActivitiIllegalArgumentException("AttachmentId is required.");
        }
        Attachment attachment = ActivitiUtil.getTaskService().getAttachment(attachmentId);
        if (attachment == null || !task.getId().equals(attachment.getTaskId())) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have an attachment with id '" + attachmentId + "'.", Comment.class);
        }
        ActivitiUtil.getTaskService().deleteAttachment(attachmentId);
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }
}

