/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import java.io.InputStream;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.task.Attachment;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.restlet.data.MediaType;
import org.restlet.representation.InputRepresentation;
import org.restlet.resource.Get;

public class TaskAttachmentContentResource
extends TaskBaseResource {
    @Get
    public InputRepresentation getAttachmentContent() {
        if (!this.authenticate()) {
            return null;
        }
        HistoricTaskInstance task = this.getHistoricTaskFromRequest();
        String attachmentId = this.getAttribute("attachmentId");
        if (attachmentId == null) {
            throw new ActivitiIllegalArgumentException("AttachmentId is required.");
        }
        Attachment attachment = ActivitiUtil.getTaskService().getAttachment(attachmentId);
        if (attachment == null || !task.getId().equals(attachment.getTaskId())) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have an attachment with id '" + attachmentId + "'.", Attachment.class);
        }
        InputStream attachmentStream = ActivitiUtil.getTaskService().getAttachmentContent(attachmentId);
        if (attachmentStream == null) {
            throw new ActivitiObjectNotFoundException("Attachment with id '" + attachmentId + "' doesn't have content associated with it.", Attachment.class);
        }
        MediaType type = null;
        if (attachment.getType() != null && MediaType.valueOf((String)attachment.getType()) != null) {
            type = MediaType.valueOf((String)attachment.getType());
        }
        if (type == null || !type.isConcrete()) {
            type = MediaType.APPLICATION_OCTET_STREAM;
        }
        return new InputRepresentation(attachmentStream, type);
    }
}

