/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.runtime.Execution;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.runtime.process.ExecutionActionRequest;
import org.activiti.rest.service.api.runtime.process.ExecutionBaseResource;
import org.activiti.rest.service.api.runtime.process.ExecutionResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Put;

public class ExecutionResource
extends ExecutionBaseResource {
    @Get
    public ExecutionResponse getExecution() {
        if (!this.authenticate()) {
            return null;
        }
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createExecutionResponse(this, this.getExecutionFromRequest());
    }

    @Put
    public ExecutionResponse performExecutionAction(ExecutionActionRequest actionRequest) {
        if (!this.authenticate()) {
            return null;
        }
        Execution execution = this.getExecutionFromRequest();
        if ("signal".equals(actionRequest.getAction())) {
            if (actionRequest.getVariables() != null) {
                ActivitiUtil.getRuntimeService().signal(execution.getId(), this.getVariablesToSet(actionRequest));
            } else {
                ActivitiUtil.getRuntimeService().signal(execution.getId());
            }
        } else if ("signalEventReceived".equals(actionRequest.getAction())) {
            if (actionRequest.getSignalName() == null) {
                throw new ActivitiIllegalArgumentException("Signal name is required");
            }
            if (actionRequest.getVariables() != null) {
                ActivitiUtil.getRuntimeService().signalEventReceived(actionRequest.getSignalName(), execution.getId(), this.getVariablesToSet(actionRequest));
            } else {
                ActivitiUtil.getRuntimeService().signalEventReceived(actionRequest.getSignalName(), execution.getId());
            }
        } else if ("messageEventReceived".equals(actionRequest.getAction())) {
            if (actionRequest.getMessageName() == null) {
                throw new ActivitiIllegalArgumentException("Message name is required");
            }
            if (actionRequest.getVariables() != null) {
                ActivitiUtil.getRuntimeService().messageEventReceived(actionRequest.getMessageName(), execution.getId(), this.getVariablesToSet(actionRequest));
            } else {
                ActivitiUtil.getRuntimeService().messageEventReceived(actionRequest.getMessageName(), execution.getId());
            }
        } else {
            throw new ActivitiIllegalArgumentException("Invalid action: '" + actionRequest.getAction() + "'.");
        }
        execution = (Execution)ActivitiUtil.getRuntimeService().createExecutionQuery().executionId(execution.getId()).singleResult();
        if (execution == null) {
            this.setStatus(Status.SUCCESS_NO_CONTENT);
            return null;
        }
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createExecutionResponse(this, execution);
    }
}

