/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.IdentityLink;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.engine.RestIdentityLink;
import org.activiti.rest.service.api.repository.BaseProcessDefinitionResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;

public class ProcessDefinitionIdentityLinkResource
extends BaseProcessDefinitionResource {
    @Get
    public RestIdentityLink getIdentityLink() {
        if (!this.authenticate()) {
            return null;
        }
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest();
        String family = this.getAttribute("family");
        String identityId = this.getAttribute("identityId");
        this.validateIdentityLinkArguments(family, identityId);
        IdentityLink link = this.getIdentityLink(family, identityId, processDefinition.getId());
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createRestIdentityLink(this, link);
    }

    @Delete
    public void deleteIdentityLink() {
        if (!this.authenticate()) {
            return;
        }
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest();
        String family = this.getAttribute("family");
        String identityId = this.getAttribute("identityId");
        this.validateIdentityLinkArguments(family, identityId);
        IdentityLink link = this.getIdentityLink(family, identityId, processDefinition.getId());
        if (link.getUserId() != null) {
            ActivitiUtil.getRepositoryService().deleteCandidateStarterUser(processDefinition.getId(), link.getUserId());
        } else {
            ActivitiUtil.getRepositoryService().deleteCandidateStarterGroup(processDefinition.getId(), link.getGroupId());
        }
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }

    protected void validateIdentityLinkArguments(String family, String identityId) {
        if (family == null || !"groups".equals(family) && !"users".equals(family)) {
            throw new ActivitiIllegalArgumentException("Identity link family should be 'users' or 'groups'.");
        }
        if (identityId == null) {
            throw new ActivitiIllegalArgumentException("IdentityId is required.");
        }
    }

    protected IdentityLink getIdentityLink(String family, String identityId, String processDefinitionId) {
        boolean isUser = family.equals("users");
        List allLinks = ActivitiUtil.getRepositoryService().getIdentityLinksForProcessDefinition(processDefinitionId);
        for (IdentityLink link : allLinks) {
            boolean rightIdentity = false;
            rightIdentity = isUser ? identityId.equals(link.getUserId()) : identityId.equals(link.getGroupId());
            if (!rightIdentity || !link.getType().equals("candidate")) continue;
            return link;
        }
        throw new ActivitiObjectNotFoundException("Could not find the requested identity link.", IdentityLink.class);
    }
}

