/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.repository.Model;
import org.activiti.rest.service.api.repository.BaseModelResource;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.IOUtils;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Status;
import org.restlet.ext.fileupload.RestletFileUpload;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.restlet.resource.ResourceException;

public abstract class BaseModelSourceResource
extends BaseModelResource {
    @Get
    public InputRepresentation getModelSource() {
        if (!this.authenticate()) {
            return null;
        }
        Model model = this.getModelFromRequest();
        return this.getModelStream(model);
    }

    @Put
    public InputRepresentation setModelSource(Representation representation) {
        if (!this.authenticate()) {
            return null;
        }
        Model model = this.getModelFromRequest();
        if (!MediaType.MULTIPART_FORM_DATA.isCompatible((Metadata)representation.getMediaType())) {
            throw new ResourceException(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE.getCode(), "The request should be of type 'multipart/form-data'.", null, null);
        }
        RestletFileUpload upload = new RestletFileUpload((FileItemFactory)new DiskFileItemFactory());
        try {
            FileItem uploadItem = null;
            List items = upload.parseRepresentation(representation);
            Iterator i$ = items.iterator();
            while (i$.hasNext()) {
                FileItem fileItem;
                uploadItem = fileItem = (FileItem)i$.next();
            }
            if (uploadItem == null) {
                throw new ActivitiIllegalArgumentException("No file content was found in request body.");
            }
            int size = Long.valueOf(uploadItem.getSize()).intValue();
            ByteArrayOutputStream bytesOutput = new ByteArrayOutputStream(size);
            IOUtils.copy((InputStream)uploadItem.getInputStream(), (OutputStream)bytesOutput);
            byte[] byteArray = bytesOutput.toByteArray();
            this.setModelSource(model, byteArray);
            return new InputRepresentation((InputStream)new ByteArrayInputStream(byteArray), MediaType.APPLICATION_OCTET_STREAM);
        }
        catch (FileUploadException e) {
            throw new ActivitiException("Error with uploaded file: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ActivitiException("Error while reading uploaded file: " + e.getMessage(), (Throwable)e);
        }
    }

    protected abstract void setModelSource(Model var1, byte[] var2);

    protected abstract InputRepresentation getModelStream(Model var1);
}

