/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.management;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.runtime.Job;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.RestActionRequest;
import org.activiti.rest.service.api.management.JobResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Post;

public class JobResource
extends SecuredResource {
    private static final String EXECUTE_ACTION = "execute";

    @Get
    public JobResponse getJob() {
        if (!this.authenticate()) {
            return null;
        }
        Job job = this.getJobFromResponse();
        JobResponse response = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createJobResponse(this, job);
        return response;
    }

    @Delete
    public void deleteJob() {
        if (!this.authenticate()) {
            return;
        }
        String jobId = this.getAttribute("jobId");
        if (jobId == null) {
            throw new ActivitiIllegalArgumentException("The jobId cannot be null");
        }
        try {
            ActivitiUtil.getManagementService().deleteJob(jobId);
        }
        catch (ActivitiObjectNotFoundException aonfe) {
            throw new ActivitiObjectNotFoundException("Could not find a job with id '" + jobId + "'.", Job.class);
        }
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }

    @Post
    public void executeJobAction(RestActionRequest actionRequest) {
        if (!this.authenticate()) {
            return;
        }
        String jobId = this.getAttribute("jobId");
        if (jobId == null) {
            throw new ActivitiIllegalArgumentException("The jobId cannot be null");
        }
        if (actionRequest == null || !EXECUTE_ACTION.equals(actionRequest.getAction())) {
            throw new ActivitiIllegalArgumentException("Invalid action, only 'execute' is supported.");
        }
        try {
            ActivitiUtil.getManagementService().executeJob(jobId);
        }
        catch (ActivitiObjectNotFoundException aonfe) {
            throw new ActivitiObjectNotFoundException("Could not find a job with id '" + jobId + "'.", Job.class);
        }
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }

    protected Job getJobFromResponse() {
        String jobId = this.getAttribute("jobId");
        if (jobId == null) {
            throw new ActivitiIllegalArgumentException("The jobId cannot be null");
        }
        Job job = (Job)ActivitiUtil.getManagementService().createJobQuery().jobId(jobId).singleResult();
        if (job == null) {
            throw new ActivitiObjectNotFoundException("Could not find a job with id '" + jobId + "'.", Job.class);
        }
        return job;
    }
}

