/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.management;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.runtime.Job;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;

public class JobExceptionStacktraceResource
extends SecuredResource {
    @Get
    public Representation getJobStacktrace() {
        if (!this.authenticate()) {
            return null;
        }
        Job job = this.getJobFromResponse();
        String stackTrace = ActivitiUtil.getManagementService().getJobExceptionStacktrace(job.getId());
        if (stackTrace == null) {
            throw new ActivitiObjectNotFoundException("Job with id '" + job.getId() + "' doesn't have an exception stacktrace.", String.class);
        }
        return new StringRepresentation((CharSequence)stackTrace, MediaType.TEXT_PLAIN);
    }

    protected Job getJobFromResponse() {
        String jobId = this.getAttribute("jobId");
        if (jobId == null) {
            throw new ActivitiIllegalArgumentException("The jobId cannot be null");
        }
        Job job = (Job)ActivitiUtil.getManagementService().createJobQuery().jobId(jobId).singleResult();
        if (job == null) {
            throw new ActivitiObjectNotFoundException("Could not find a job with id '" + jobId + "'.", Job.class);
        }
        return job;
    }
}

