/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.process;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricDetail;
import org.activiti.engine.history.HistoricDetailQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.history.HistoricVariableUpdate;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.RequestUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.restlet.data.Status;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;

public class LegacyProcessInstanceResource
extends SecuredResource {
    @Get
    public ObjectNode getProcessInstance() {
        if (!this.authenticate()) {
            return null;
        }
        String processInstanceId = (String)this.getRequest().getAttributes().get("processInstanceId");
        HistoricProcessInstance instance = (HistoricProcessInstance)ActivitiUtil.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (instance == null) {
            throw new ActivitiObjectNotFoundException("Process instance not found for id " + processInstanceId, ProcessInstance.class);
        }
        ObjectNode responseJSON = new ObjectMapper().createObjectNode();
        responseJSON.put("processInstanceId", instance.getId());
        if (instance.getBusinessKey() != null) {
            responseJSON.put("businessKey", instance.getBusinessKey());
        } else {
            responseJSON.putNull("businessKey");
        }
        responseJSON.put("processDefinitionId", instance.getProcessDefinitionId());
        responseJSON.put("startTime", RequestUtil.dateToString((Date)instance.getStartTime()));
        responseJSON.put("startActivityId", instance.getStartActivityId());
        if (instance.getStartUserId() != null) {
            responseJSON.put("startUserId", instance.getStartUserId());
        } else {
            responseJSON.putNull("startUserId");
        }
        if (instance.getEndTime() == null) {
            responseJSON.put("completed", false);
        } else {
            responseJSON.put("completed", true);
            responseJSON.put("endTime", RequestUtil.dateToString((Date)instance.getEndTime()));
            responseJSON.put("endActivityId", instance.getEndActivityId());
            responseJSON.put("duration", instance.getDurationInMillis());
        }
        this.addTaskList(processInstanceId, responseJSON);
        this.addActivityList(processInstanceId, responseJSON);
        this.addVariableList(processInstanceId, responseJSON);
        return responseJSON;
    }

    @Delete
    public ObjectNode deleteProcessInstance() {
        if (!this.authenticate()) {
            return null;
        }
        String processInstanceId = (String)this.getRequest().getAttributes().get("processInstanceId");
        ActivitiUtil.getRuntimeService().deleteProcessInstance(processInstanceId, "REST API");
        ObjectNode successNode = new ObjectMapper().createObjectNode();
        successNode.put("success", true);
        return successNode;
    }

    private void addTaskList(String processInstanceId, ObjectNode responseJSON) {
        List taskList = ((HistoricTaskInstanceQuery)ActivitiUtil.getHistoryService().createHistoricTaskInstanceQuery().processInstanceId(processInstanceId).orderByHistoricTaskInstanceStartTime().asc()).list();
        if (taskList != null && taskList.size() > 0) {
            ArrayNode tasksJSON = new ObjectMapper().createArrayNode();
            responseJSON.put("tasks", (JsonNode)tasksJSON);
            for (HistoricTaskInstance historicTaskInstance : taskList) {
                ObjectNode taskJSON = new ObjectMapper().createObjectNode();
                taskJSON.put("taskId", historicTaskInstance.getId());
                taskJSON.put("taskDefinitionKey", historicTaskInstance.getTaskDefinitionKey());
                if (historicTaskInstance.getName() != null) {
                    taskJSON.put("taskName", historicTaskInstance.getName());
                } else {
                    taskJSON.putNull("taskName");
                }
                if (historicTaskInstance.getDescription() != null) {
                    taskJSON.put("description", historicTaskInstance.getDescription());
                } else {
                    taskJSON.putNull("description");
                }
                if (historicTaskInstance.getOwner() != null) {
                    taskJSON.put("owner", historicTaskInstance.getOwner());
                } else {
                    taskJSON.putNull("owner");
                }
                if (historicTaskInstance.getAssignee() != null) {
                    taskJSON.put("assignee", historicTaskInstance.getAssignee());
                } else {
                    taskJSON.putNull("assignee");
                }
                taskJSON.put("startTime", RequestUtil.dateToString((Date)historicTaskInstance.getStartTime()));
                if (historicTaskInstance.getDueDate() != null) {
                    taskJSON.put("dueDate", RequestUtil.dateToString((Date)historicTaskInstance.getDueDate()));
                } else {
                    taskJSON.putNull("dueDate");
                }
                if (historicTaskInstance.getEndTime() == null) {
                    taskJSON.put("completed", false);
                } else {
                    taskJSON.put("completed", true);
                    taskJSON.put("endTime", RequestUtil.dateToString((Date)historicTaskInstance.getEndTime()));
                    taskJSON.put("duration", historicTaskInstance.getDurationInMillis());
                }
                tasksJSON.add((JsonNode)taskJSON);
            }
        }
    }

    private void addActivityList(String processInstanceId, ObjectNode responseJSON) {
        List activityList = ((HistoricActivityInstanceQuery)ActivitiUtil.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceStartTime().asc()).list();
        if (activityList != null && activityList.size() > 0) {
            ArrayNode activitiesJSON = new ObjectMapper().createArrayNode();
            responseJSON.put("activities", (JsonNode)activitiesJSON);
            for (HistoricActivityInstance historicActivityInstance : activityList) {
                ObjectNode activityJSON = new ObjectMapper().createObjectNode();
                activityJSON.put("activityId", historicActivityInstance.getActivityId());
                if (historicActivityInstance.getActivityName() != null) {
                    activityJSON.put("activityName", historicActivityInstance.getActivityName());
                } else {
                    activityJSON.putNull("activityName");
                }
                activityJSON.put("activityType", historicActivityInstance.getActivityType());
                activityJSON.put("startTime", RequestUtil.dateToString((Date)historicActivityInstance.getStartTime()));
                if (historicActivityInstance.getEndTime() == null) {
                    activityJSON.put("completed", false);
                } else {
                    activityJSON.put("completed", true);
                    activityJSON.put("endTime", RequestUtil.dateToString((Date)historicActivityInstance.getEndTime()));
                    activityJSON.put("duration", historicActivityInstance.getDurationInMillis());
                }
                activitiesJSON.add((JsonNode)activityJSON);
            }
        }
    }

    private void addVariableList(String processInstanceId, ObjectNode responseJSON) {
        List historyVariableList;
        ObjectNode variableJSON;
        ArrayNode variablesJSON;
        try {
            Map variableMap = ActivitiUtil.getRuntimeService().getVariables(processInstanceId);
            if (variableMap != null && variableMap.size() > 0) {
                variablesJSON = new ObjectMapper().createArrayNode();
                responseJSON.put("variables", (JsonNode)variablesJSON);
                for (String key : variableMap.keySet()) {
                    Object variableValue = variableMap.get(key);
                    variableJSON = new ObjectMapper().createObjectNode();
                    variableJSON.put("variableName", key);
                    if (variableValue != null) {
                        if (variableValue instanceof Boolean) {
                            variableJSON.put("variableValue", (Boolean)variableValue);
                        } else if (variableValue instanceof Long) {
                            variableJSON.put("variableValue", (Long)variableValue);
                        } else if (variableValue instanceof Double) {
                            variableJSON.put("variableValue", (Double)variableValue);
                        } else if (variableValue instanceof Float) {
                            variableJSON.put("variableValue", (Float)variableValue);
                        } else if (variableValue instanceof Integer) {
                            variableJSON.put("variableValue", (Integer)variableValue);
                        } else {
                            variableJSON.put("variableValue", variableValue.toString());
                        }
                    } else {
                        variableJSON.putNull("variableValue");
                    }
                    variablesJSON.add((JsonNode)variableJSON);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if ((historyVariableList = ((HistoricDetailQuery)ActivitiUtil.getHistoryService().createHistoricDetailQuery().processInstanceId(processInstanceId).variableUpdates().orderByTime().desc()).list()) != null && historyVariableList.size() > 0) {
            variablesJSON = new ObjectMapper().createArrayNode();
            responseJSON.put("historyVariables", (JsonNode)variablesJSON);
            for (HistoricDetail historicDetail : historyVariableList) {
                HistoricVariableUpdate variableUpdate = (HistoricVariableUpdate)historicDetail;
                variableJSON = new ObjectMapper().createObjectNode();
                variableJSON.put("variableName", variableUpdate.getVariableName());
                if (variableUpdate.getValue() != null) {
                    if (variableUpdate.getValue() instanceof Boolean) {
                        variableJSON.put("variableValue", (Boolean)variableUpdate.getValue());
                    } else if (variableUpdate.getValue() instanceof Long) {
                        variableJSON.put("variableValue", (Long)variableUpdate.getValue());
                    } else if (variableUpdate.getValue() instanceof Double) {
                        variableJSON.put("variableValue", (Double)variableUpdate.getValue());
                    } else if (variableUpdate.getValue() instanceof Float) {
                        variableJSON.put("variableValue", (Float)variableUpdate.getValue());
                    } else if (variableUpdate.getValue() instanceof Integer) {
                        variableJSON.put("variableValue", (Integer)variableUpdate.getValue());
                    } else {
                        variableJSON.put("variableValue", variableUpdate.getValue().toString());
                    }
                } else {
                    variableJSON.putNull("variableValue");
                }
                variableJSON.put("variableType", variableUpdate.getVariableTypeName());
                variableJSON.put("revision", variableUpdate.getRevision());
                variableJSON.put("time", RequestUtil.dateToString((Date)variableUpdate.getTime()));
                variablesJSON.add((JsonNode)variableJSON);
            }
        }
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

