/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.management;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.restlet.data.Status;
import org.restlet.resource.Get;

public class TablesResource
extends SecuredResource {
    @Get
    public ObjectNode getTables() {
        if (!this.authenticate("admin")) {
            return null;
        }
        Map tableCounts = ActivitiUtil.getManagementService().getTableCount();
        ArrayList tableNames = new ArrayList(tableCounts.keySet());
        Collections.sort(tableNames);
        ObjectNode responseJSON = new ObjectMapper().createObjectNode();
        ArrayNode tablesJSON = new ObjectMapper().createArrayNode();
        responseJSON.put("data", (JsonNode)tablesJSON);
        for (String tableName : tableNames) {
            ObjectNode tableJSON = new ObjectMapper().createObjectNode();
            tableJSON.put("tableName", tableName);
            tableJSON.put("total", (Long)tableCounts.get(tableName));
            tablesJSON.add((JsonNode)tableJSON);
        }
        return responseJSON;
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

