/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.management;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.activiti.engine.ActivitiException;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;

public class JobsExecuteResource
extends SecuredResource {
    @Post
    public ObjectNode startProcessInstance(Representation entity) {
        try {
            if (!this.authenticate("admin")) {
                return null;
            }
            String startParams = entity.getText();
            JsonNode startJSON = new ObjectMapper().readTree(startParams);
            ArrayNode jobIdsJSON = (ArrayNode)startJSON.get("jobIds");
            for (JsonNode jobId : jobIdsJSON) {
                ActivitiUtil.getManagementService().executeJob(jobId.textValue());
            }
            ObjectNode successNode = new ObjectMapper().createObjectNode();
            successNode.put("success", true);
            return successNode;
        }
        catch (Exception e) {
            if (e instanceof ActivitiException) {
                throw (ActivitiException)e;
            }
            throw new ActivitiException("Failed to execute jobs", (Throwable)e);
        }
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

