/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.GroupQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.legacy.identity.LegacyStateResponse;
import org.activiti.rest.service.api.legacy.identity.LegacyUserGroupsPaginateList;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Post;

public class LegacyUserGroupsResource
extends SecuredResource {
    Map<String, QueryProperty> properties = new HashMap<String, QueryProperty>();

    public LegacyUserGroupsResource() {
        this.properties.put("id", (QueryProperty)GroupQueryProperty.GROUP_ID);
        this.properties.put("name", (QueryProperty)GroupQueryProperty.NAME);
        this.properties.put("type", (QueryProperty)GroupQueryProperty.TYPE);
    }

    @Get(value="json")
    public DataResponse getGroups() {
        if (!this.authenticate()) {
            return null;
        }
        String userId = (String)this.getRequest().getAttributes().get("userId");
        if (userId == null) {
            throw new ActivitiIllegalArgumentException("No userId provided");
        }
        DataResponse dataResponse = new LegacyUserGroupsPaginateList().paginateList(this.getQuery(), (Query)ActivitiUtil.getIdentityService().createGroupQuery().groupMember(userId), "id", this.properties);
        return dataResponse;
    }

    @Post
    public LegacyStateResponse setGroups(ArrayList<String> groupIds) {
        if (!this.authenticate()) {
            return null;
        }
        String userId = (String)this.getRequest().getAttributes().get("userId");
        if (userId == null) {
            throw new ActivitiIllegalArgumentException("No userId provided");
        }
        if (groupIds == null) {
            throw new ActivitiIllegalArgumentException("No groupIds provided");
        }
        IdentityService identityService = ActivitiUtil.getIdentityService();
        if (identityService.createUserQuery().userId(userId).singleResult() == null) {
            throw new ActivitiObjectNotFoundException("The user '" + userId + " does not exist.", User.class);
        }
        for (String groupId : groupIds) {
            if (identityService.createGroupQuery().groupId(groupId).singleResult() != null) continue;
            throw new ActivitiObjectNotFoundException("Group '" + groupId + "' does not exist.", Group.class);
        }
        for (String groupId : groupIds) {
            if (identityService.createUserQuery().userId(userId).memberOfGroup(groupId).singleResult() != null) continue;
            identityService.createMembership(userId, groupId);
        }
        return new LegacyStateResponse().setSuccess(true);
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

