/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.identity;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.User;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.legacy.identity.LegacyStateResponse;
import org.activiti.rest.service.api.legacy.identity.LegacyUserInfoWithPassword;
import org.restlet.data.Status;
import org.restlet.resource.Put;
import org.restlet.resource.ResourceException;

public class LegacyUserCreateResource
extends SecuredResource {
    @Put
    public LegacyStateResponse createUser(LegacyUserInfoWithPassword userInfo) {
        if (!this.authenticate()) {
            return null;
        }
        IdentityService identityService = ActivitiUtil.getIdentityService();
        if (userInfo == null || userInfo.getId() == null) {
            throw new ActivitiIllegalArgumentException("No user id supplied");
        }
        if (identityService.createUserQuery().userId(userInfo.getId()).count() != 0L) {
            throw new ResourceException(Status.CLIENT_ERROR_CONFLICT, "user id must be unique");
        }
        User user = identityService.newUser(userInfo.getId());
        user.setFirstName(userInfo.getFirstName());
        user.setLastName(userInfo.getLastName());
        user.setPassword(userInfo.getPassword());
        user.setEmail(userInfo.getEmail());
        identityService.saveUser(user);
        return new LegacyStateResponse().setSuccess(true);
    }
}

