/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.identity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.activiti.engine.identity.Group;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.legacy.identity.LegacyGroupInfo;
import org.apache.commons.lang3.StringUtils;
import org.restlet.data.Status;
import org.restlet.resource.Get;

public class LegacyGroupSearchResource
extends SecuredResource {
    @Get(value="json")
    public DataResponse searchGroups() {
        if (!this.authenticate()) {
            return null;
        }
        String searchText = this.getQuery().getValues("searchText");
        if (searchText != null) {
            searchText = searchText.toLowerCase();
        }
        List groups = ActivitiUtil.getIdentityService().createGroupQuery().list();
        ArrayList<LegacyGroupInfo> groupList = new ArrayList<LegacyGroupInfo>();
        for (Group group : groups) {
            if (StringUtils.isNotEmpty((CharSequence)searchText)) {
                if (!group.getName().toLowerCase().contains(searchText) && !group.getId().toLowerCase().contains(searchText)) continue;
                groupList.add(new LegacyGroupInfo(group));
                continue;
            }
            groupList.add(new LegacyGroupInfo(group));
        }
        Collections.sort(groupList, new GroupResponseComparable());
        DataResponse response = new DataResponse();
        response.setStart(0);
        response.setSize(groupList.size());
        response.setSort("name");
        response.setOrder("asc");
        response.setTotal((long)groupList.size());
        response.setData(groupList);
        return response;
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }

    protected class GroupResponseComparable
    implements Comparator<LegacyGroupInfo> {
        protected GroupResponseComparable() {
        }

        @Override
        public int compare(LegacyGroupInfo group1, LegacyGroupInfo group2) {
            return group1.getName().compareTo(group2.getName());
        }
    }
}

