/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.identity;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Group;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.legacy.identity.LegacyGroupInfo;
import org.activiti.rest.service.api.legacy.identity.LegacyStateResponse;
import org.restlet.data.Status;
import org.restlet.resource.Put;
import org.restlet.resource.ResourceException;

public class LegacyGroupCreateResource
extends SecuredResource {
    @Put
    public LegacyStateResponse createGroup(LegacyGroupInfo groupInfo) {
        Group group;
        if (!this.authenticate()) {
            return null;
        }
        IdentityService identityService = ActivitiUtil.getIdentityService();
        if (groupInfo == null || groupInfo.getId() == null) {
            throw new ActivitiIllegalArgumentException("No group id supplied");
        }
        if (groupInfo.getName() == null || groupInfo.getName().equals("")) {
            groupInfo.setName(groupInfo.getId());
        }
        if (identityService.createGroupQuery().groupId(groupInfo.getId()).count() == 0L) {
            group = identityService.newGroup(groupInfo.getId());
            group.setName(groupInfo.getName());
            if (groupInfo.getType() != null) {
                group.setType(groupInfo.getType());
            } else {
                group.setType("assignment");
            }
        } else {
            throw new ResourceException(Status.CLIENT_ERROR_CONFLICT, "group id must be unique");
        }
        identityService.saveGroup(group);
        return new LegacyStateResponse().setSuccess(true);
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

