/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.history;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.impl.HistoricActivityInstanceQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.history.HistoricActivityInstancePaginateList;
import org.activiti.rest.service.api.history.HistoricActivityInstanceQueryRequest;
import org.restlet.data.Form;
import org.restlet.resource.Get;

public class HistoricActivityInstanceBaseResource
extends SecuredResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();

    @Get(value="json")
    protected DataResponse getQueryResponse(HistoricActivityInstanceQueryRequest queryRequest, Form urlQuery) {
        if (!this.authenticate()) {
            return null;
        }
        HistoricActivityInstanceQuery query = ActivitiUtil.getHistoryService().createHistoricActivityInstanceQuery();
        if (queryRequest.getActivityId() != null) {
            query.activityId(queryRequest.getActivityId());
        }
        if (queryRequest.getActivityInstanceId() != null) {
            query.activityInstanceId(queryRequest.getActivityInstanceId());
        }
        if (queryRequest.getActivityName() != null) {
            query.activityName(queryRequest.getActivityName());
        }
        if (queryRequest.getActivityType() != null) {
            query.activityType(queryRequest.getActivityType());
        }
        if (queryRequest.getExecutionId() != null) {
            query.executionId(queryRequest.getExecutionId());
        }
        if (queryRequest.getFinished() != null) {
            Boolean finished = queryRequest.getFinished();
            if (finished.booleanValue()) {
                query.finished();
            } else {
                query.unfinished();
            }
        }
        if (queryRequest.getTaskAssignee() != null) {
            query.taskAssignee(queryRequest.getTaskAssignee());
        }
        if (queryRequest.getProcessInstanceId() != null) {
            query.processInstanceId(queryRequest.getProcessInstanceId());
        }
        if (queryRequest.getProcessDefinitionId() != null) {
            query.processDefinitionId(queryRequest.getProcessDefinitionId());
        }
        if (queryRequest.getTenantId() != null) {
            query.activityTenantId(queryRequest.getTenantId());
        }
        if (queryRequest.getTenantIdLike() != null) {
            query.activityTenantIdLike(queryRequest.getTenantIdLike());
        }
        if (Boolean.TRUE.equals(queryRequest.getWithoutTenantId())) {
            query.activityWithoutTenantId();
        }
        return new HistoricActivityInstancePaginateList(this).paginateList(urlQuery, queryRequest, (Query)query, "startTime", allowedSortProperties);
    }

    static {
        allowedSortProperties.put("activityId", (QueryProperty)HistoricActivityInstanceQueryProperty.ACTIVITY_ID);
        allowedSortProperties.put("activityName", (QueryProperty)HistoricActivityInstanceQueryProperty.ACTIVITY_NAME);
        allowedSortProperties.put("activityType", (QueryProperty)HistoricActivityInstanceQueryProperty.ACTIVITY_TYPE);
        allowedSortProperties.put("duration", (QueryProperty)HistoricActivityInstanceQueryProperty.DURATION);
        allowedSortProperties.put("endTime", (QueryProperty)HistoricActivityInstanceQueryProperty.END);
        allowedSortProperties.put("executionId", (QueryProperty)HistoricActivityInstanceQueryProperty.EXECUTION_ID);
        allowedSortProperties.put("activityInstanceId", (QueryProperty)HistoricActivityInstanceQueryProperty.HISTORIC_ACTIVITY_INSTANCE_ID);
        allowedSortProperties.put("processDefinitionId", (QueryProperty)HistoricActivityInstanceQueryProperty.PROCESS_DEFINITION_ID);
        allowedSortProperties.put("processInstanceId", (QueryProperty)HistoricActivityInstanceQueryProperty.PROCESS_INSTANCE_ID);
        allowedSortProperties.put("startTime", (QueryProperty)HistoricActivityInstanceQueryProperty.START);
        allowedSortProperties.put("tenantId", (QueryProperty)HistoricActivityInstanceQueryProperty.TENANT_ID);
    }
}

