/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jeecg.common.desform.api.IDesformBaseApi;
import org.jeecg.common.desform.vo.DesignFormDataVo;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.modules.online.desform.entity.DesignForm;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.jeecg.modules.online.desform.service.IDesignFormService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="desformBaseApiImpl")
public class a
implements IDesformBaseApi {
    @Autowired
    IDesignFormService designFormService;
    @Autowired
    IDesignFormDataService dataService;

    public DesignFormDataVo getDataById(String desformCode, String id) {
        DesignFormData designFormData = this.dataService.getById(desformCode, id);
        DesignFormDataVo designFormDataVo = new DesignFormDataVo();
        if (designFormData != null) {
            BeanUtils.copyProperties((Object)designFormData, (Object)designFormDataVo);
        }
        return designFormDataVo;
    }

    public List<DesignFormDataVo> getDataByIds(String desformCode, String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        List<DesignFormData> list2 = this.dataService.getByIds(desformCode, list);
        ArrayList<DesignFormDataVo> arrayList = new ArrayList<DesignFormDataVo>(list2.size());
        for (DesignFormData designFormData : list2) {
            DesignFormDataVo designFormDataVo = new DesignFormDataVo();
            BeanUtils.copyProperties((Object)designFormData, (Object)designFormDataVo);
            arrayList.add(designFormDataVo);
        }
        return arrayList;
    }

    public boolean updateDataById(String desformCode, String id, JSONObject jsonData) {
        DesignFormData designFormData = new DesignFormData(desformCode, jsonData);
        designFormData.setId(id);
        designFormData.setDesformCode(desformCode);
        return this.dataService.updateById(designFormData);
    }

    public boolean deleteDataById(String desformCode, String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        return this.dataService.removeBatchByIds(desformCode, list);
    }

    public JSONObject translateData(String desformCode, JSONArray dataList) {
        DesignForm designForm = this.designFormService.getByCode(desformCode);
        if (designForm == null) {
            throw new JeecgBootException(desformCode + " \u4e0d\u5b58\u5728");
        }
        ArrayList<DesignFormData> arrayList = new ArrayList<DesignFormData>();
        for (int i2 = 0; i2 < dataList.size(); ++i2) {
            JSONObject jSONObject = dataList.getJSONObject(i2);
            DesignFormData designFormData = new DesignFormData(desformCode, jSONObject);
            arrayList.add(designFormData);
        }
        return this.dataService.translateData(designForm, arrayList);
    }
}

