/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.mongo.model;

import com.alibaba.fastjson.JSONObject;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.constant.WidgetTypes;
import org.jeecg.modules.online.desform.mongo.model.TreeModel;

public class FieldOption {
    private String field;
    private String type;
    private String dictTable;
    private String dictCode;
    private String dictText;
    private TreeModel treeModel;
    private String groupModeKey;
    private String groupDataConditionKey;
    private String groupOrderKey;
    private String staticOptions;
    private Boolean multi;

    public FieldOption() {
    }

    public FieldOption(String field, Boolean multi) {
        this.multi = multi;
        this.field = field;
    }

    public FieldOption(String field, String type) {
        this.type = type;
        this.field = field;
    }

    public FieldOption(JSONObject json) {
        this.type = json.getString("type");
        this.field = json.getString("model");
        JSONObject jSONObject = json.getJSONObject("options");
        if (WidgetTypes.LINK_RECORD.getType().equals(this.type)) {
            this.dictTable = jSONObject.getString("sourceCode");
            this.dictCode = "id";
            this.dictText = jSONObject.getString("titleField");
        } else if (WidgetTypes.RADIO.getType().equals(this.type) || WidgetTypes.SELECT.getType().equals(this.type)) {
            this.dictCode = jSONObject.getString("dictCode");
            this.staticOptions = jSONObject.getString("options");
        } else if (WidgetTypes.TABLE_DICT.getType().equals(this.type)) {
            this.dictTable = jSONObject.getString("dictTable");
            this.dictCode = jSONObject.getString("dictCode");
            this.dictText = jSONObject.getString("dictText");
        }
        this.initTreeModel(jSONObject);
    }

    private void initTreeModel(JSONObject options) {
        if (WidgetTypes.SELECT_TREE.getType().equals(this.getType())) {
            JSONObject jSONObject = options.getJSONObject("conf");
            JSONObject jSONObject2 = jSONObject.getJSONObject("category");
            String string = jSONObject2.getString("code");
            if (string != null && !"".equals(string)) {
                TreeModel treeModel = TreeModel.getCategoryTree(string);
                this.setTreeModel(treeModel);
            } else {
                JSONObject jSONObject3 = jSONObject.getJSONObject("table");
                TreeModel treeModel = new TreeModel(jSONObject3);
                this.setTreeModel(treeModel);
            }
        }
    }

    public boolean isList() {
        return WidgetTypes.SELECT.getType().equals(this.type) || WidgetTypes.RADIO.getType().equals(this.type) || WidgetTypes.TABLE_DICT.getType().equals(this.type) || WidgetTypes.LINK_RECORD.getType().equals(this.type);
    }

    public String getOrderType(JSONObject json) {
        String string = null;
        string = oConvertUtils.isEmpty((Object)this.getGroupOrderKey()) ? "desc" : json.getString(this.getGroupOrderKey());
        if (oConvertUtils.isEmpty((Object)string)) {
            string = "desc";
        }
        return string;
    }

    public String getField() {
        return this.field;
    }

    public String getType() {
        return this.type;
    }

    public String getDictTable() {
        return this.dictTable;
    }

    public String getDictCode() {
        return this.dictCode;
    }

    public String getDictText() {
        return this.dictText;
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public String getGroupModeKey() {
        return this.groupModeKey;
    }

    public String getGroupDataConditionKey() {
        return this.groupDataConditionKey;
    }

    public String getGroupOrderKey() {
        return this.groupOrderKey;
    }

    public String getStaticOptions() {
        return this.staticOptions;
    }

    public Boolean getMulti() {
        return this.multi;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDictTable(String dictTable) {
        this.dictTable = dictTable;
    }

    public void setDictCode(String dictCode) {
        this.dictCode = dictCode;
    }

    public void setDictText(String dictText) {
        this.dictText = dictText;
    }

    public void setTreeModel(TreeModel treeModel) {
        this.treeModel = treeModel;
    }

    public void setGroupModeKey(String groupModeKey) {
        this.groupModeKey = groupModeKey;
    }

    public void setGroupDataConditionKey(String groupDataConditionKey) {
        this.groupDataConditionKey = groupDataConditionKey;
    }

    public void setGroupOrderKey(String groupOrderKey) {
        this.groupOrderKey = groupOrderKey;
    }

    public void setStaticOptions(String staticOptions) {
        this.staticOptions = staticOptions;
    }

    public void setMulti(Boolean multi) {
        this.multi = multi;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof FieldOption)) {
            return false;
        }
        FieldOption fieldOption = (FieldOption)o2;
        if (!fieldOption.canEqual(this)) {
            return false;
        }
        Boolean bl = this.getMulti();
        Boolean bl2 = fieldOption.getMulti();
        if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
            return false;
        }
        String string = this.getField();
        String string2 = fieldOption.getField();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getType();
        String string4 = fieldOption.getType();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getDictTable();
        String string6 = fieldOption.getDictTable();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getDictCode();
        String string8 = fieldOption.getDictCode();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        String string9 = this.getDictText();
        String string10 = fieldOption.getDictText();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        TreeModel treeModel = this.getTreeModel();
        TreeModel treeModel2 = fieldOption.getTreeModel();
        if (treeModel == null ? treeModel2 != null : !((Object)treeModel).equals(treeModel2)) {
            return false;
        }
        String string11 = this.getGroupModeKey();
        String string12 = fieldOption.getGroupModeKey();
        if (string11 == null ? string12 != null : !string11.equals(string12)) {
            return false;
        }
        String string13 = this.getGroupDataConditionKey();
        String string14 = fieldOption.getGroupDataConditionKey();
        if (string13 == null ? string14 != null : !string13.equals(string14)) {
            return false;
        }
        String string15 = this.getGroupOrderKey();
        String string16 = fieldOption.getGroupOrderKey();
        if (string15 == null ? string16 != null : !string15.equals(string16)) {
            return false;
        }
        String string17 = this.getStaticOptions();
        String string18 = fieldOption.getStaticOptions();
        return !(string17 == null ? string18 != null : !string17.equals(string18));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FieldOption;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        Boolean bl = this.getMulti();
        n3 = n3 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
        String string = this.getField();
        n3 = n3 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getType();
        n3 = n3 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getDictTable();
        n3 = n3 * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getDictCode();
        n3 = n3 * 59 + (string4 == null ? 43 : string4.hashCode());
        String string5 = this.getDictText();
        n3 = n3 * 59 + (string5 == null ? 43 : string5.hashCode());
        TreeModel treeModel = this.getTreeModel();
        n3 = n3 * 59 + (treeModel == null ? 43 : ((Object)treeModel).hashCode());
        String string6 = this.getGroupModeKey();
        n3 = n3 * 59 + (string6 == null ? 43 : string6.hashCode());
        String string7 = this.getGroupDataConditionKey();
        n3 = n3 * 59 + (string7 == null ? 43 : string7.hashCode());
        String string8 = this.getGroupOrderKey();
        n3 = n3 * 59 + (string8 == null ? 43 : string8.hashCode());
        String string9 = this.getStaticOptions();
        n3 = n3 * 59 + (string9 == null ? 43 : string9.hashCode());
        return n3;
    }

    public String toString() {
        return "FieldOption(field=" + this.getField() + ", type=" + this.getType() + ", dictTable=" + this.getDictTable() + ", dictCode=" + this.getDictCode() + ", dictText=" + this.getDictText() + ", treeModel=" + this.getTreeModel() + ", groupModeKey=" + this.getGroupModeKey() + ", groupDataConditionKey=" + this.getGroupDataConditionKey() + ", groupOrderKey=" + this.getGroupOrderKey() + ", staticOptions=" + this.getStaticOptions() + ", multi=" + this.getMulti() + ")";
    }
}

