<#assign CACHE_VERSION = "cv=1.4.2">
<#assign base = springMacroRequestContext.getContextUrl("")>

<!DOCTYPE html>
<html lang="zh-Hans">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge，chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <meta name="description" content="提交成功">
    <title>提交成功</title>

    <link rel="stylesheet" href="${base}/desform/style/success.css">

    <script src="${base}/desform/lib/unpkg/polyfill/7.2.5/polyfill.js?${CACHE_VERSION}"></script>
    <script src="${base}/desform/lib/unpkg/vue@2.7.13/vue.js?${CACHE_VERSION}"></script>
    <script src="${base}/desform/utils.js?${CACHE_VERSION}"></script>

    <style>
        .info-box {
            width: 100%;
            font-size: 0;
            margin-bottom: 32px;
        }

        .info-box .info-item {
            margin-right: 0;
            margin-bottom: 0;
            width: 100%;

            border-bottom: 1px solid #d9d9d9;
        }

        .info-box .info-item:last-child {
            border-bottom: 0;
        }


        .info-box .info-item-label,
        .info-box .info-item-content {
            line-height: 32px;
            overflow: hidden;
            -ms-text-overflow: ellipsis;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .info-box .info-item-label {
            vertical-align: middle;
            float: left;
            font-size: 14px;
            padding: 0 8px 0 0;
            -webkit-box-sizing: border-box;
            box-sizing: border-box;
            width: 90px;
            color: #99a9bf;
            text-align: right;
        }

        .info-box .info-item-content {

            position: relative;
            font-size: 14px;
            text-align: left;
            padding: 0 0 0 8px;
        }

        .btn-expand {
            font-size: 14px;
            margin-top: 8px;
            text-align: right;
            border: 0;
            color: #1890ff;
            cursor: pointer;
        }
    </style>

</head>

<body>
<div id="app">

  <#-- 页眉头图 -->
  <div v-if="showHeaderImg" class="header-img">
    <img :src="headerImgUrl" alt="页眉">
  </div>

  <div  class="container">

    <#-- 成功图标 -->
    <i class="icon-success">
        <img src="${base}/desform/svg/success.svg" alt="success">
    </i>
    <div class='info'>
        <h2>提交成功</h2>
    </div>

    <#-- 保存的数据 -->
    <div v-if="widgets.length > 0" class="info-box">
        <template v-for="(item,idx) of widgets">
            <div v-if="expand || idx<5" class="info-item" :key="item.modal">
                <div class="info-item-label">{{item.title}}</div>
                <div class="info-item-content">{{item.value}}</div>
            </div>
        </template>
        <div v-if="widgets.length>5" class="btn-expand">
            <span @click="expand=!expand">{{expand ? '收起' : '更多'}}</span>
        </div>
    </div>

    <#-- 按钮 -->
    <div class="button">
        <button class="ant-btn ant-btn-default" @click="handleBack">返回</button>
        <button id="closeBtn" class="ant-btn ant-btn-default" style="display: none;" @click="handleAutoClose">关闭</button>
    </div>

  </div>
</div>
</body>

<script src="${base}/desform/script/success.js"></script>

<script>
  var widgets = (${widgets})
  new Vue({
    el: '#app',
    data: function () {
      return {
        widgets: widgets,
        expand: false,
        // 是否显示页眉图片
        showHeaderImg: ${showHeaderImg?string('true', 'false')},
        // 页眉图片地址
        headerImgUrl: '${headerImgUrl!''}',
      }
    },
    methods: {
      handleBack: function () {
        handleBack()
      },
      handleAutoClose: function () {
        handleAutoClose()
      },
    }
  })
</script>

</html>