/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.mongo.service.a;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.SerializedLambda;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.constant.enums.MessageTypeEnum;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.online.api.IOnlineBaseExtApi;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.RestUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.modules.online.desform.c.e;
import org.jeecg.modules.online.desform.c.g;
import org.jeecg.modules.online.desform.constant.WidgetTypes;
import org.jeecg.modules.online.desform.constant.a;
import org.jeecg.modules.online.desform.entity.DesignForm;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.mapper.DesignFormMapper;
import org.jeecg.modules.online.desform.mongo.model.FieldOption;
import org.jeecg.modules.online.desform.mongo.model.ListViewModel;
import org.jeecg.modules.online.desform.mongo.service.IDataMongoCurdService;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormListViewService;
import org.jeecg.modules.online.desform.service.IDesignFormAuthService;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.jeecg.modules.online.desform.vo.DesformPageVo;
import org.jeecg.modules.online.desform.vo.TranslateData;
import org.jeecg.modules.online.desform.vo.excel.DesformWidgetList;
import org.jeecg.modules.online.desform.vo.query.DesformSuperQuery;
import org.jeecg.modules.online.desform.vo.transl.TranslAllData;
import org.jeecg.modules.online.desform.vo.widget.DesformWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Primary
@Service(value="designFormDataMongoServiceImpl")
public class b
implements IDesignFormDataService {
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    private DesignFormMapper designFormMapper;
    @Autowired
    private IDesignFormAuthService designFormAuthService;
    @Lazy
    @Autowired
    ISysBaseAPI sysBaseApi;
    @Autowired
    @Lazy
    IOnlineBaseExtApi onlineBaseExtApi;
    @Autowired
    JeecgBaseConfig jeecgBaseConfig;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    IDataMongoCurdService dataMongoCurdService;
    @Autowired
    IDesignFormListViewService designFormListViewService;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public boolean saveBatchByImport(DesignForm designForm, Collection<JSONObject> entityList) {
        ArrayList<DesignFormData> arrayList = new ArrayList<DesignFormData>();
        JSONArray jSONArray = null;
        for (JSONObject jSONObject : entityList) {
            DesignFormData designFormData = new DesignFormData();
            designFormData.setDesformId(designForm.getId());
            designFormData.setDesformCode(designForm.getDesformCode());
            designFormData.setDesformName(designForm.getDesformName());
            designFormData.setOnlineFormCode(designForm.getCgformCode());
            designFormData.setDesformDataJson(jSONObject.toJSONString());
            if (StringUtils.isNotBlank((String)designForm.getCgformCode())) {
                String string = designForm.getCgformCode();
                try {
                    if (jSONArray == null) {
                        jSONArray = g.b(designForm);
                    }
                    this.a(designFormData, jSONArray, HttpMethod.POST);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            arrayList.add(designFormData);
        }
        return this.saveBatch(designForm.getDesformCode(), arrayList);
    }

    @Override
    public Result<IPage<DesignFormData>> pageList(String desformCode, Page<DesignFormData> page, DesformSuperQuery superQuery) {
        Result result = new Result();
        Query query = e.a(superQuery);
        result.setMessage("\u67e5\u8be2\u6210\u529f");
        result.setResult(this.a(page, desformCode, query));
        return result;
    }

    @Override
    public Result<Page<DesignFormData>> queryPage(String desformCode, Page<DesignFormData> page, DesformSuperQuery superQuery, String username) throws UnsupportedEncodingException {
        Result result = new Result();
        Result<?> result2 = this.a(desformCode, page, superQuery, username, false);
        BeanUtils.copyProperties(result2, (Object)result);
        return result;
    }

    @Override
    public List<DesignFormData> list(String desformCode, DesformSuperQuery superQuery) {
        Query query = e.a(superQuery);
        return this.a(desformCode, query);
    }

    private List<DesignFormData> a(String string, Query query) {
        if (query == null) {
            query = new Query();
        }
        return this.mongoTemplate.find(query, Document.class, string).stream().map(document -> new DesignFormData(string, (Document)document)).collect(Collectors.toList());
    }

    private Result<?> a(String string, Page<DesignFormData> page, DesformSuperQuery desformSuperQuery, String string2, boolean bl) throws UnsupportedEncodingException {
        Result result = new Result();
        DesignForm designForm = this.a(string);
        if (designForm == null) {
            result.setMessage("\u8868\u5355\u4e0d\u5b58\u5728");
            result.setSuccess(false);
            return result;
        }
        String string3 = designForm.getDesformCode();
        if (org.jeecg.modules.online.desform.constant.a.d.equals(designForm.getDesformType())) {
            string3 = designForm.getParentCode();
        }
        ListViewModel listViewModel = this.designFormListViewService.queryListViewInfo(designForm, desformSuperQuery.getListViewId());
        List<FieldOption> list = e.a(designForm);
        listViewModel.setFieldList(list);
        List<OrderItem> list2 = listViewModel.getOrderList();
        if (list2 != null && list2.size() > 0) {
            e.a(page, list2);
        }
        result.setMessage("\u67e5\u8be2\u6210\u529f");
        Query query = this.designFormListViewService.getQuery(string2, string, desformSuperQuery, listViewModel);
        if (bl) {
            e.a(page.orders(), query);
            result.setResult(this.a(string3, query));
        } else {
            DesformPageVo<DesignFormData> desformPageVo = new DesformPageVo<DesignFormData>(this.a(page, string3, query));
            JSONObject jSONObject = this.translateData(designForm, desformPageVo.getRecords());
            desformPageVo.setTranslData(jSONObject);
            desformPageVo.setHasSuperQuery(desformSuperQuery.hasQuery());
            result.setResult(desformPageVo);
        }
        return result;
    }

    private void a(DesignFormData designFormData, JSONArray jSONArray, HttpMethod httpMethod) throws Exception {
        String string = designFormData.getOnlineFormCode();
        if (oConvertUtils.isNotEmpty((Object)string)) {
            Object object22;
            JSONObject jSONObject = JSON.parseObject((String)designFormData.getDesformDataJson());
            for (Object object22 : jSONObject.keySet()) {
                Object object3 = jSONObject.get(object22);
                if (!(object3 instanceof JSONObject) && !(object3 instanceof JSONArray)) continue;
                jSONObject.put((String)object22, (Object)JSON.toJSONString((Object)object3));
            }
            DesformWidgetList desformWidgetList = g.b(jSONArray);
            this.a(jSONObject, desformWidgetList.main);
            for (String string2 : desformWidgetList.sub.keySet()) {
                JSONArray jSONArray2 = jSONObject.getJSONArray(string2);
                for (int i2 = 0; i2 < jSONArray2.size(); ++i2) {
                    JSONObject jSONObject2 = jSONArray2.getJSONObject(i2);
                    this.a(jSONObject2, desformWidgetList.sub.get(string2));
                }
                jSONObject.put(string2, (Object)jSONArray2);
            }
            if (httpMethod == HttpMethod.POST) {
                object22 = this.onlineBaseExtApi.cgformPostCrazyForm(string, jSONObject);
            } else {
                jSONObject.put("id", (Object)designFormData.getOnlineFormDataId());
                object22 = this.onlineBaseExtApi.cgformPutCrazyForm(string, jSONObject);
            }
            designFormData.setOnlineFormDataId((String)object22);
        }
    }

    private void a(JSONObject jSONObject, List<DesformWidget> list) {
        for (DesformWidget desformWidget : list) {
            Object object2;
            String[] stringArray;
            WidgetTypes widgetTypes = desformWidget.getType();
            String string = desformWidget.getModel();
            try {
                stringArray = JSON.parse((String)jSONObject.getString(string));
                if (widgetTypes == WidgetTypes.CHECKBOX || widgetTypes == WidgetTypes.SELECT) {
                    object2 = ((JSONArray)stringArray).toJavaList(String.class);
                    jSONObject.put(string, (Object)String.join((CharSequence)",", (Iterable<? extends CharSequence>)object2));
                } else if (widgetTypes == WidgetTypes.IMGUPLOAD || widgetTypes == WidgetTypes.FILE_UPLOAD) {
                    object2 = ((JSONArray)stringArray).stream().map(object -> ((JSONObject)object).getString("url")).collect(Collectors.toList());
                    jSONObject.put(string, (Object)String.join((CharSequence)",", object2));
                } else if (widgetTypes == WidgetTypes.DATE && desformWidget.getOptions().getTimestamp().booleanValue()) {
                    object2 = desformWidget.getOptions().getFormat();
                    jSONObject.put(string, (Object)DateUtils.formatDate((Date)new Date(Long.parseLong(stringArray.toString())), (String)object2));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!string.contains("#")) continue;
            stringArray = string.split("#");
            object2 = "sub-table-one2one_" + stringArray[0];
            String string2 = stringArray[1];
            JSONArray jSONArray = jSONObject.getJSONArray(object2);
            if (jSONArray == null) {
                jSONArray = new JSONArray();
                jSONArray.add((Object)new JSONObject());
                jSONObject.put((String)object2, (Object)jSONArray);
            }
            JSONObject jSONObject2 = jSONArray.getJSONObject(0);
            jSONObject2.put(string2, jSONObject.get((Object)string));
            jSONObject.remove((Object)string);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<?> addOne(DesignFormData designFormData, boolean isExternal) {
        if (designFormData == null) {
            return Result.error((String)"designFormData \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String string = designFormData.getDesformCode();
        if (StringUtils.isEmpty((String)string)) {
            return Result.error((String)"\u5fc5\u987b\u4f20\u9012 desformCode \u53c2\u6570");
        }
        DesignForm designForm = this.a(string);
        if (designForm == null) {
            return Result.error((String)("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + string + "\uff09\u4e0d\u5b58\u5728"));
        }
        JSONObject jSONObject = JSON.parseObject((String)designForm.getDesformDesignJson());
        JSONArray jSONArray = jSONObject.getJSONArray("list");
        this.a(string, jSONArray, designFormData);
        HttpMethod httpMethod = HttpMethod.POST;
        try {
            this.a(designFormData, jSONArray, httpMethod);
        }
        catch (Exception exception) {
            a.error("\u540c\u6b65\u4fdd\u5b58\u5230Online\u8868\u5355\u5931\u8d25", (Throwable)exception);
            throw new JeecgBootException("\u540c\u6b65\u4fdd\u5b58\u5230Online\u8868\u5355\u5931\u8d25\uff1a" + exception.getMessage());
        }
        if ("ONLINE-DATA-TEMP-ID".equals(designFormData.getId())) {
            return Result.OK((String)"\u6dfb\u52a0\u6210\u529f", (Object)designFormData.getId());
        }
        try {
            if (CommonConstant.DESIGN_FORM_TYPE_SUB.equals(designForm.getDesformType())) {
                designFormData.setDesformId(designForm.getParentId());
                designFormData.setDesformCode(designForm.getParentCode());
            } else {
                designFormData.setDesformId(designForm.getId());
            }
            designFormData.setDesformName(designForm.getDesformName());
            this.save(designFormData.getDesformCode(), designFormData);
            JSONObject jSONObject2 = jSONObject.getJSONObject("config");
            boolean bl = jSONObject2.getBooleanValue("transactional");
            boolean bl2 = this.a(designFormData, designForm, httpMethod, bl);
            this.a(designFormData, designForm, jSONArray, jSONObject2, isExternal);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("dataId", (Object)designFormData.getId());
            jSONObject3.put("customURLFail", (Object)bl2);
            return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01", (Object)jSONObject3);
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new JeecgBootException("\u64cd\u4f5c\u5931\u8d25\uff1a" + exception.getMessage());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Result<?> addOne(DesignFormData designFormData) {
        return this.addOne(designFormData, false);
    }

    private synchronized void a(String string, JSONArray jSONArray, DesignFormData designFormData) {
        ArrayList arrayList = new ArrayList();
        g.a(jSONArray, (WidgetTypes widgetTypes, JSONObject jSONObject, JSONObject jSONObject2) -> {
            if (widgetTypes == WidgetTypes.AUTO_NUMBER) {
                arrayList.add(jSONObject);
            }
        });
        if (arrayList.isEmpty()) {
            return;
        }
        JSONObject jSONObject3 = JSON.parseObject((String)designFormData.getDesformDataJson());
        for (JSONObject jSONObject4 : arrayList) {
            String string2 = jSONObject4.getString("key");
            String string3 = jSONObject4.getString("model");
            JSONArray jSONArray2 = jSONObject4.getJSONObject("options").getJSONArray("numberRules");
            StringBuilder stringBuilder = new StringBuilder();
            block13: for (int i2 = 0; i2 < jSONArray2.size(); ++i2) {
                String string4;
                JSONObject jSONObject5 = jSONArray2.getJSONObject(i2);
                switch (string4 = jSONObject5.getString("type")) {
                    case "number": {
                        JSONObject jSONObject6;
                        int n2 = jSONObject5.getIntValue("start") - 1;
                        Integer n3 = jSONObject5.getInteger("mode");
                        String string5 = "sys:desform:auto-number:" + string + ":" + string2;
                        Object object = this.redisUtil.get(string5);
                        if (object == null) {
                            jSONObject6 = new JSONObject();
                            jSONObject6.put("value", (Object)n2);
                        } else {
                            jSONObject6 = JSON.parseObject((String)object.toString());
                        }
                        Integer n4 = jSONObject5.getInteger("reset");
                        Date date = new Date(jSONObject6.getLongValue("time"));
                        if (org.jeecg.modules.online.desform.constant.a.S.equals(n4)) {
                            if (!DateUtils.isSameDay((Date)date, (Date)new Date())) {
                                jSONObject6.put("value", (Object)n2);
                            }
                        } else if (org.jeecg.modules.online.desform.constant.a.T.equals(n4)) {
                            if (!DateUtils.isSameWeek((Date)date, (Date)new Date())) {
                                jSONObject6.put("value", (Object)n2);
                            }
                        } else if (org.jeecg.modules.online.desform.constant.a.U.equals(n4)) {
                            if (!DateUtils.isSameMonth((Date)date, (Date)new Date())) {
                                jSONObject6.put("value", (Object)n2);
                            }
                        } else if (org.jeecg.modules.online.desform.constant.a.V.equals(n4) && !DateUtils.isSameYear((Date)date, (Date)new Date())) {
                            jSONObject6.put("value", (Object)n2);
                        }
                        Integer n5 = jSONObject6.getInteger("value");
                        n5 = n5 + 1;
                        jSONObject6.put("value", (Object)n5);
                        jSONObject6.put("time", (Object)new Date().getTime());
                        this.redisUtil.set(string5, (Object)jSONObject6.toJSONString(), 0L);
                        if (org.jeecg.modules.online.desform.constant.a.P.equals(n3)) {
                            stringBuilder.append(n5);
                            continue block13;
                        }
                        Object object2 = jSONObject5.getInteger("length");
                        boolean bl = jSONObject5.getBooleanValue("continue");
                        String string6 = String.format("%0" + object2 + "d", n5);
                        if (string6.length() > (Integer)object2 && !bl) {
                            string6 = String.format("%0" + object2 + "d", 0);
                            jSONObject6.put("value", (Object)0);
                            this.redisUtil.set(string5, (Object)jSONObject6.toJSONString(), 0L);
                        }
                        stringBuilder.append(string6);
                        continue block13;
                    }
                    case "create_date": {
                        Object object2 = jSONObject5.getString("format");
                        if (!oConvertUtils.isNotEmpty((Object)object2)) continue block13;
                        stringBuilder.append(DateUtils.formatDate((Date)new Date(), (String)object2));
                        continue block13;
                    }
                    case "text": {
                        String string7 = jSONObject5.getString("text");
                        if (!oConvertUtils.isNotEmpty((Object)string7)) continue block13;
                        stringBuilder.append(string7);
                        continue block13;
                    }
                    case "field": {
                        String string6 = jSONObject5.getString("model");
                        if (!oConvertUtils.isNotEmpty((Object)string6)) continue block13;
                        String string8 = jSONObject3.getString(string6);
                        stringBuilder.append(string8);
                        continue block13;
                    }
                }
            }
            jSONObject3.put(string3, (Object)stringBuilder.toString());
        }
        designFormData.setDesformDataJson(jSONObject3.toJSONString());
    }

    private void a(DesignFormData designFormData, DesignForm designForm, JSONArray jSONArray, JSONObject jSONObject, boolean bl) {
        g.a(() -> {
            try {
                boolean bl2 = jSONObject.getBooleanValue("enableNotice");
                if (!bl2) {
                    return;
                }
                String string = jSONObject.getString("noticeMode");
                if ("external".equals(string) && !bl) {
                    return;
                }
                String string2 = jSONObject.getString("noticeType");
                String string3 = jSONObject.getString("noticeReceiver");
                MessageDTO messageDTO = new MessageDTO();
                messageDTO.setToAll(Boolean.valueOf(false));
                messageDTO.setTitle("[" + designForm.getDesformName() + "]\u65b0\u589e\u4e86\u4e00\u6761\u6570\u636e");
                messageDTO.setToUser(string3);
                String string4 = this.jeecgBaseConfig.getDomainUrl().getPc();
                String string5 = string4 + "/online/desform?open=" + designForm.getDesformCode();
                String string6 = string4 + "/online/desform/list/" + designForm.getDesformCode();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("userName", designForm.getCreateBy());
                hashMap.put("formLink", string5);
                hashMap.put("formName", designForm.getDesformName());
                hashMap.put("moreLink", string6);
                hashMap.put("createTime", ((SimpleDateFormat)DateUtils.datetimeFormat.get()).format(designFormData.getCreateTime()));
                StringBuffer stringBuffer = new StringBuffer();
                JSONObject jSONObject4 = JSONObject.parseObject((String)designFormData.getDesformDataJson());
                g.a(jSONArray, (WidgetTypes widgetTypes, JSONObject jSONObject2, JSONObject jSONObject3) -> {
                    JSONArray jSONArray;
                    DesformWidget desformWidget = (DesformWidget)jSONObject2.toJavaObject(DesformWidget.class);
                    desformWidget.setType(widgetTypes);
                    String string = jSONObject4.getString(desformWidget.getModel());
                    if (widgetTypes == WidgetTypes.LINK_RECORD && (jSONArray = jSONObject4.getJSONArray(desformWidget.getModel())) != null && !jSONArray.isEmpty()) {
                        String string2 = desformWidget.getOptions().getSourceCode();
                        String string3 = desformWidget.getOptions().getTitleField();
                        List<DesignFormData> list = this.getByIds(string2, jSONArray.toJavaList(String.class));
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (DesignFormData designFormData : list) {
                            JSONObject jSONObject4 = designFormData.getDesformData();
                            arrayList.add(jSONObject4.getString(string3));
                        }
                        string = String.join((CharSequence)",", arrayList);
                    }
                    if (oConvertUtils.isNotEmpty((Object)string)) {
                        stringBuffer.append("> **").append(desformWidget.getName()).append("\uff1a**\n> ").append(string).append("\n> \n");
                    }
                });
                hashMap.put("dataMarkdown", stringBuffer.toString());
                messageDTO.setData(hashMap);
                messageDTO.setFromUser("system");
                messageDTO.setTemplateCode("desform_notice_write");
                this.a(string2, messageDTO);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
    }

    private void a(String string, MessageDTO messageDTO) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(",")) {
            MessageTypeEnum messageTypeEnum = MessageTypeEnum.valueOfType((String)string2);
            if (messageTypeEnum == null) continue;
            messageDTO.setType(messageTypeEnum.getType());
            this.sysBaseApi.sendTemplateMessage(messageDTO);
        }
    }

    private boolean a(DesignFormData designFormData, DesignForm designForm, HttpMethod httpMethod, boolean bl) {
        String string;
        boolean bl2 = false;
        JSONObject jSONObject = JSON.parseObject((String)designForm.getDesformDesignJson());
        JSONArray jSONArray = jSONObject.getJSONObject("config").getJSONArray("customRequestURL");
        if (jSONArray != null && jSONArray.size() > 0 && oConvertUtils.isNotEmpty((Object)(string = jSONArray.getJSONObject(0).getString("url")))) {
            string = string.trim();
            a.info("\u63d0\u4ea4\u5230\u7528\u6237\u81ea\u5b9a\u4e49url:" + string);
            String string2 = "^https?:/{2}";
            if (!Pattern.matches(string2, string)) {
                string = RestUtil.getBaseUrl() + string;
            }
            JSONObject jSONObject2 = JSON.parseObject((String)JSON.toJSONString((Object)designFormData));
            jSONObject2.put("dataId", (Object)designFormData.getId());
            HttpHeaders httpHeaders = new HttpHeaders();
            String string3 = "application/json";
            httpHeaders.setContentType(MediaType.APPLICATION_JSON);
            httpHeaders.set("Accept", string3);
            HttpServletRequest httpServletRequest = SpringContextUtils.getHttpServletRequest();
            String string4 = httpServletRequest.getHeader("X-Access-Token");
            httpHeaders.set("X-Access-Token", string4);
            ResponseEntity responseEntity = RestUtil.request((String)string, (HttpMethod)httpMethod, (HttpHeaders)httpHeaders, null, (Object)jSONObject2, JSONObject.class);
            if (HttpStatus.OK == responseEntity.getStatusCode()) {
                JSONObject jSONObject3 = (JSONObject)responseEntity.getBody();
                String string5 = "success";
                if (jSONObject3 == null || !jSONObject3.getBooleanValue(string5)) {
                    String string6;
                    String string7 = "";
                    if (jSONObject3 != null && oConvertUtils.isNotEmpty((Object)(string6 = jSONObject3.getString("message")))) {
                        string7 = ":" + string6;
                    }
                    a.error("\u540c\u6b65\u4fdd\u5b58\u5230\u7528\u6237\u81ea\u5b9a\u4e49URL\u5931\u8d25\uff1a" + responseEntity.toString());
                    if (bl) {
                        throw new JeecgBootException("\u4fdd\u5b58\u5230\u81ea\u5b9a\u4e49URL\u5931\u8d25" + string7);
                    }
                    bl2 = true;
                }
            } else {
                a.error("\u540c\u6b65\u4fdd\u5b58\u5230\u7528\u6237\u81ea\u5b9a\u4e49URL\u5931\u8d25\uff1a" + responseEntity.toString());
                if (bl) {
                    throw new JeecgBootException("\u540c\u6b65\u4fdd\u5b58\u5230\u7528\u6237\u81ea\u5b9a\u4e49URL\u5931\u8d25");
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    @Transactional(rollbackFor={Exception.class})
    public Result<?> editOne(DesignFormData designFormData) {
        DesignFormData designFormData2;
        String string = designFormData.getDesformCode();
        if (StringUtils.isEmpty((String)string)) {
            return Result.error((String)"\u5fc5\u987b\u4f20\u9012 desformCode \u53c2\u6570");
        }
        DesignForm designForm = this.a(string);
        if (designForm == null) {
            return Result.error((String)("\u8868\u5355\u8bbe\u8ba1\u5668\uff08" + string + "\uff09\u4e0d\u5b58\u5728"));
        }
        if (org.jeecg.modules.online.desform.constant.a.d.equals(designForm.getDesformType())) {
            string = designForm.getParentCode();
        }
        if ((designFormData2 = this.getById(string, designFormData.getId())) == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e!");
        }
        JSONObject jSONObject = JSON.parseObject((String)designForm.getDesformDesignJson());
        JSONArray jSONArray = jSONObject.getJSONArray("list");
        HttpMethod httpMethod = HttpMethod.PUT;
        try {
            this.a(designFormData, jSONArray, httpMethod);
        }
        catch (Exception exception) {
            a.error("\u540c\u6b65\u66f4\u65b0\u5230Online\u8868\u5355\u5931\u8d25", (Throwable)exception);
            throw new JeecgBootException("\u540c\u6b65\u66f4\u65b0\u5230Online\u8868\u5355\u5931\u8d25\uff1a" + exception.getMessage());
        }
        if ("ONLINE-DATA-TEMP-ID".equals(designFormData.getId())) {
            return Result.OK((String)"\u6dfb\u52a0\u6210\u529f", (Object)designFormData.getId());
        }
        designFormData.setDesformId(null);
        designFormData.setDesformCode(null);
        this.dataMongoCurdService.update(string, designFormData);
        JSONObject jSONObject2 = jSONObject.getJSONObject("config");
        boolean bl = jSONObject2.getBooleanValue("transactional");
        boolean bl2 = this.a(designFormData, designForm, httpMethod, bl);
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("dataId", (Object)designFormData.getId());
        jSONObject3.put("customURLFail", (Object)bl2);
        return Result.OK((String)"\u4fee\u6539\u6210\u529f\uff01", (Object)jSONObject3);
    }

    public Result<?> deleteOne(DesignFormData designFormData) {
        String string = designFormData.getDesformCode();
        if (oConvertUtils.isEmpty((Object)string)) {
            throw new JeecgBootException("\u5fc5\u987b\u4f20\u9012 desformCode");
        }
        if ((designFormData = this.getById(string, designFormData.getId())) == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        }
        this.dataMongoCurdService.delete(designFormData.getDesformCode(), designFormData.getId());
        this.a(designFormData);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public boolean removeBatchByIds(String desformCode, List<String> idList) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(idList));
        List list = this.mongoTemplate.find(query, Document.class, desformCode);
        for (Document document : list) {
            DesignFormData designFormData = new DesignFormData(desformCode, document);
            this.dataMongoCurdService.delete(desformCode, designFormData.getId());
            this.a(designFormData);
        }
        return true;
    }

    @Override
    public DesignFormData getByOnlineDataId(String desformCode, String onlineDataId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"online_form_id").is((Object)onlineDataId));
        Document document = (Document)this.mongoTemplate.findOne(query, Document.class, desformCode);
        if (document == null) {
            return null;
        }
        return new DesignFormData(desformCode, document);
    }

    private void a(DesignFormData designFormData) {
        String string = designFormData.getOnlineFormCode();
        String string2 = designFormData.getOnlineFormDataId();
        if (StringUtils.isNotBlank((String)string) && StringUtils.isNotBlank((String)string2)) {
            try {
                this.onlineBaseExtApi.cgformDeleteDataByCode(string, string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public JSONObject translateData(DesignForm designForm, DesignFormData designFormData) {
        ArrayList<DesignFormData> arrayList = new ArrayList<DesignFormData>();
        arrayList.add(designFormData);
        return this.translateData(designForm, arrayList);
    }

    @Override
    public JSONObject translateData(DesignForm designForm, List<DesignFormData> desformDataList) {
        JSONObject jSONObject3 = new JSONObject();
        if (desformDataList == null || desformDataList.size() == 0) {
            return jSONObject3;
        }
        TranslAllData translAllData = new TranslAllData();
        g.a(designForm, (WidgetTypes widgetTypes, JSONObject jSONObject, JSONObject jSONObject2) -> {
            DesformWidget desformWidget = (DesformWidget)jSONObject.toJavaObject(DesformWidget.class);
            desformWidget.setType(widgetTypes);
            for (DesignFormData designFormData : desformDataList) {
                String string;
                JSONObject jSONObject3 = JSON.parseObject((String)designFormData.getDesformDataJson());
                if (jSONObject3 == null || !oConvertUtils.isNotEmpty((Object)(string = jSONObject3.getString(desformWidget.getModel())))) continue;
                translAllData.packageTranslAllData(desformWidget, string);
            }
        });
        this.b(translAllData.getDictCodeDataList(), jSONObject3, desformDataList);
        this.d(translAllData.getUserDepartList(), jSONObject3, desformDataList);
        this.e(translAllData.getTableDictList1(), jSONObject3, desformDataList);
        this.f(translAllData.getTableDictList2(), jSONObject3, desformDataList);
        this.a(translAllData.getSelectTreeData1(), jSONObject3, desformDataList);
        this.g(translAllData.getSelectTreeList2(), jSONObject3, desformDataList);
        this.a(translAllData.getSwitchList(), jSONObject3, desformDataList);
        return jSONObject3;
    }

    private void a(List<TranslateData> list, JSONObject jSONObject, List<DesignFormData> list2) {
        try {
            if (list != null && list.size() > 0 && list2 != null) {
                for (DesignFormData designFormData : list2) {
                    for (TranslateData translateData : list) {
                        String string = translateData.getModel();
                        JSONObject jSONObject2 = designFormData.getDesformData();
                        if (jSONObject2 == null) continue;
                        Object object = jSONObject2.get((Object)string);
                        if ("Y".equals(object)) {
                            jSONObject2.put(translateData.getModel() + "_dictText", (Object)"\u662f");
                            continue;
                        }
                        if (!"N".equals(object)) continue;
                        jSONObject2.put(translateData.getModel() + "_dictText", (Object)"\u5426");
                    }
                }
            }
        }
        catch (Exception exception) {
            a.error("[\u8868\u5355\u8bbe\u8ba1\u5668] translateDictData error\uff1a" + exception.getMessage());
        }
    }

    private void b(List<TranslateData> list, JSONObject jSONObject, List<DesignFormData> list2) {
        try {
            if (list != null && list.size() > 0) {
                List list3 = list.stream().map(TranslateData::getDictCode).distinct().collect(Collectors.toList());
                Map map = this.sysBaseApi.getManyDictItems(list3);
                for (TranslateData translateData : list) {
                    String string = translateData.getDictCode();
                    List list4 = (List)map.get(string);
                    if (list4 == null) continue;
                    jSONObject.put(string + "_dict", map.get(string));
                    jSONObject.put(translateData.getKey(), map.get(string));
                }
                this.c(list, jSONObject, list2);
            }
        }
        catch (Exception exception) {
            a.error("[\u8868\u5355\u8bbe\u8ba1\u5668] translateDictData error\uff1a" + exception.getMessage());
        }
    }

    private void c(List<TranslateData> list, JSONObject jSONObject, List<DesignFormData> list2) {
        if (list2 != null) {
            for (TranslateData translateData : list) {
                for (DesignFormData designFormData : list2) {
                    Object object;
                    JSONObject jSONObject2 = designFormData.getDesformData();
                    if (jSONObject2 == null || !oConvertUtils.isNotEmpty((Object)(object = jSONObject2.get((Object)translateData.getModel())))) continue;
                    JSONArray jSONArray = jSONObject.getJSONArray(translateData.getKey());
                    String string = g.a(jSONArray, object);
                    jSONObject2.put(translateData.getModel() + "_dictText", (Object)string);
                }
            }
        }
    }

    private void d(List<TranslateData> list, JSONObject jSONObject, List<DesignFormData> list2) {
        try {
            Map<String, List<DictModel>> map = this.translateColumns(list);
            for (String string : map.keySet()) {
                g.a(string, map.get(string), jSONObject);
            }
            this.c(list, jSONObject, list2);
        }
        catch (Exception exception) {
            a.error("[\u8868\u5355\u8bbe\u8ba1\u5668] translateDepartAndUserData error\uff1a" + exception.getMessage());
        }
    }

    private void e(List<TranslateData> list, JSONObject jSONObject, List<DesignFormData> list2) {
        for (TranslateData translateData : list) {
            try {
                String[] stringArray = translateData.getDictCode().split(",");
                String string = stringArray[0];
                String string2 = stringArray[1];
                String string3 = stringArray[2];
                List list3 = this.onlineBaseExtApi.cgreportGetDataPackage(string, string2, string3, translateData.getDataListJoin());
                g.a(translateData.getKey(), list3, jSONObject);
            }
            catch (Exception exception) {
                a.error("[\u8868\u5355\u8bbe\u8ba1\u5668] translateTableDictDataCgreport error\uff1a" + exception.getMessage());
            }
        }
        this.c(list, jSONObject, list2);
    }

    private void f(List<TranslateData> list, JSONObject jSONObject, List<DesignFormData> list2) {
        for (TranslateData translateData : list) {
            try {
                List list3 = this.sysBaseApi.loadDictItemByKeyword(translateData.getDictCode(), translateData.getDataListJoin(), null);
                g.a(translateData.getKey(), list3, jSONObject);
            }
            catch (Exception exception) {
                a.error("[\u8868\u5355\u8bbe\u8ba1\u5668] translateTableDictDataDatabase error\uff1a" + exception.getMessage());
            }
        }
        this.c(list, jSONObject, list2);
    }

    private void a(TranslateData translateData, JSONObject jSONObject, List<DesignFormData> list) {
        if (translateData == null) {
            return;
        }
        try {
            List<String> list2 = translateData.getDataList();
            List list3 = this.sysBaseApi.loadCategoryDictItem(String.join((CharSequence)",", list2));
            List<DictModel> list4 = g.a(translateData.getKey(), jSONObject);
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                g.a(list4, new DictModel(list2.get(i2), (String)list3.get(i2)));
            }
            jSONObject.put(translateData.getKey(), list4);
            ArrayList<TranslateData> arrayList = new ArrayList<TranslateData>();
            arrayList.add(translateData);
            this.c(arrayList, jSONObject, list);
        }
        catch (Exception exception) {
            a.error("[\u8868\u5355\u8bbe\u8ba1\u5668] translateSelectTreeDataCategory error\uff1a" + exception.getMessage());
        }
    }

    private void g(List<TranslateData> list, JSONObject jSONObject, List<DesignFormData> list2) {
        for (TranslateData translateData : list) {
            try {
                String string = translateData.getDictCode();
                List<String> list3 = translateData.getDataList();
                List list4 = this.sysBaseApi.loadDictItem(string, translateData.getDataListJoin());
                List<DictModel> list5 = g.a(translateData.getKey(), jSONObject);
                for (int i2 = 0; i2 < list3.size(); ++i2) {
                    g.a(list5, new DictModel(list3.get(i2), (String)list4.get(i2)));
                }
                jSONObject.put(translateData.getKey(), list5);
            }
            catch (Exception exception) {
                a.error("[\u8868\u5355\u8bbe\u8ba1\u5668] translateSelectTreeDataTable error\uff1a" + exception.getMessage());
            }
        }
        this.c(list, jSONObject, list2);
    }

    @Override
    public JSONObject jmReportQueryDataById(String desformCode, String id) throws Exception {
        DesignForm designForm = this.a(desformCode);
        if (designForm == null) {
            throw new JeecgBootException("\u8868\u5355[" + desformCode + "]\u4e0d\u5b58\u5728");
        }
        DesignFormData designFormData = this.getById(desformCode, id);
        if (designFormData == null) {
            throw new JeecgBootException("\u8868\u5355\u6570\u636e[" + id + "]\u4e0d\u5b58\u5728");
        }
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        arrayList.add((Map<String, Object>)JSON.parseObject((String)designFormData.getDesformDataJson()));
        DesformWidgetList desformWidgetList = g.e(designForm);
        if (desformWidgetList == null) {
            return new JSONObject((Map)arrayList.get(0));
        }
        org.jeecg.modules.online.desform.b.a.b.a(1, arrayList, desformWidgetList.main);
        JSONObject jSONObject = new JSONObject((Map)arrayList.get(0));
        for (String string : new ArrayList(jSONObject.keySet())) {
            if (!this.a(desformWidgetList.main, string)) {
                jSONObject.remove((Object)string);
                continue;
            }
            String string2 = string;
            if (string2.contains("-")) {
                string2 = string2.replaceAll("-", "_");
            }
            if (string2.contains("#")) {
                string2 = string.replaceAll("#", "__");
            }
            if (string.equals(string2)) continue;
            jSONObject.put(string2, jSONObject.get((Object)string));
            jSONObject.remove((Object)string);
        }
        return jSONObject;
    }

    private boolean a(List<DesformWidget> list, String string) {
        for (DesformWidget desformWidget : list) {
            if (!desformWidget.getModel().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, List<DictModel>> translateColumns(List<TranslateData> translateDataList) {
        ArrayList<JSONObject> arrayList;
        Object object;
        HashMap<String, List<DictModel>> hashMap = new HashMap<String, List<DictModel>>(10);
        ArrayList<TranslateData> arrayList2 = new ArrayList<TranslateData>();
        ArrayList<TranslateData> arrayList3 = new ArrayList<TranslateData>();
        for (TranslateData object22 : translateDataList) {
            object = object22.getType();
            String string = object22.getCustomReturnField();
            if (object == WidgetTypes.SELECT_USER) {
                arrayList2.add(object22);
                continue;
            }
            if (object != WidgetTypes.SELECT_DEPART) continue;
            arrayList3.add(object22);
        }
        if (arrayList2.size() > 0) {
            arrayList = new ArrayList();
            String string = this.b(arrayList2, "id");
            if (oConvertUtils.isNotEmpty((Object)string)) {
                arrayList.addAll(this.sysBaseApi.queryUsersByIds(string));
            }
            if (oConvertUtils.isNotEmpty((Object)(object = this.b(arrayList2, "username")))) {
                arrayList.addAll(this.sysBaseApi.queryUsersByUsernames((String)object));
            }
            this.a(hashMap, arrayList2, arrayList, "realname");
        }
        if (arrayList3.size() > 0) {
            arrayList = new ArrayList<JSONObject>();
            String string = this.b(arrayList3, "id");
            if (oConvertUtils.isNotEmpty((Object)string)) {
                arrayList.addAll(this.sysBaseApi.queryDepartsByIds(string));
            }
            if (oConvertUtils.isNotEmpty((Object)(object = this.b(arrayList3, "orgCode")))) {
                arrayList.addAll(this.sysBaseApi.queryDepartsByOrgcodes((String)object));
            }
            this.a(hashMap, arrayList3, arrayList, "departName");
        }
        return hashMap;
    }

    private DesignForm a(String string) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(DesignForm::getDesformCode, (Object)string);
        return (DesignForm)this.designFormMapper.selectOne((Wrapper)lambdaQueryWrapper);
    }

    private String b(List<TranslateData> list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TranslateData translateData : list) {
            if (!string.equals(translateData.getCustomReturnField())) continue;
            arrayList.addAll(translateData.getDataList());
        }
        if (arrayList.size() == 0) {
            return "";
        }
        return StringUtils.join(arrayList, (String)",");
    }

    private void a(Map<String, List<DictModel>> map, List<TranslateData> list, List<JSONObject> list2, String string2) {
        for (TranslateData translateData : list) {
            block1: for (String string3 : translateData.getDataList()) {
                for (JSONObject jSONObject : list2) {
                    String string4 = jSONObject.getString(translateData.getCustomReturnField());
                    if (string4 == null || !string4.equals(string3)) continue;
                    String string5 = jSONObject.getString(string2);
                    List list3 = map.computeIfAbsent(translateData.getKey(), string -> new ArrayList());
                    list3.add(new DictModel(string4, string5));
                    continue block1;
                }
            }
        }
    }

    @Override
    public List<DesignFormData> queryByCode(String desformCode) {
        return this.a(desformCode, new Query());
    }

    @Override
    public Page<DesignFormData> page(Page<DesignFormData> page, String desformCode, DesformSuperQuery superQuery) {
        Query query = e.a(superQuery);
        return this.a(page, desformCode, query);
    }

    private Page<DesignFormData> a(Page<DesignFormData> page, String string, Query query) {
        int n2 = (int)page.getCurrent();
        int n3 = (int)page.getSize();
        long l2 = (long)(n2 - 1) * (long)n3;
        if (query == null) {
            query = new Query();
        }
        long l3 = this.mongoTemplate.count(query, string);
        page.setTotal(l3);
        query.skip(l2).limit(n3);
        e.a(page.orders(), query);
        a.info("mongodb \u67e5\u8be2\u6761\u4ef6\uff0cdesformCode\uff1a{}\uff0cquery\uff1a{}", (Object)string, (Object)query);
        List list = this.mongoTemplate.find(query, Document.class, string);
        a.debug("mongodb \u67e5\u8be2\u7ed3\u679c\uff1a pageList size:" + list.size());
        a.debug("mongodb \u67e5\u8be2\u7ed3\u679c\uff1a pageList :" + list.toString());
        List list2 = list.stream().map(document -> new DesignFormData(string, (Document)document)).collect(Collectors.toList());
        page.setRecords(list2);
        return page;
    }

    @Override
    public DesignFormData getById(String desformCode, String id) {
        Document document = (Document)this.mongoTemplate.findById((Object)id, Document.class, desformCode);
        if (document == null) {
            return null;
        }
        a.info(" mongodb \u67e5\u8be2\u5355\u6761\u6570\u636e\uff1a getById jsonData 1:" + document.toString());
        return new DesignFormData(desformCode, document);
    }

    @Override
    public List<DesignFormData> getByIds(String desformCode, Collection<String> idList) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(idList));
        List list = this.mongoTemplate.find(query, Document.class, desformCode);
        return list.stream().map(document -> new DesignFormData(desformCode, (Document)document)).collect(Collectors.toList());
    }

    @Override
    public boolean save(String desformCode, DesignFormData entity) {
        return this.dataMongoCurdService.save(desformCode, entity);
    }

    @Override
    public boolean saveBatch(String desformCode, Collection<DesignFormData> entityList) {
        return this.dataMongoCurdService.saveBatch(desformCode, entityList) > 0;
    }

    @Override
    public boolean updateById(DesignFormData entity) {
        String string = entity.getDesformCode();
        if (oConvertUtils.isEmpty((Object)string)) {
            throw new JeecgBootException("\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataMongoCurdService.update(string, entity);
    }

    @Override
    public boolean updateBatchById(List<DesignFormData> entityList) {
        if (entityList.size() == 0) {
            return false;
        }
        String string = entityList.get(0).getDesformCode();
        if (oConvertUtils.isEmpty((Object)string)) {
            throw new JeecgBootException("\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.dataMongoCurdService.updateBatch(string, entityList);
        return false;
    }

    @Override
    public boolean removeById(String desformCode, Serializable id) {
        return this.dataMongoCurdService.delete(desformCode, id.toString());
    }

    @Override
    public boolean removeByCode(String desformCode) {
        this.mongoTemplate.getCollection(desformCode).drop();
        return true;
    }

    private static /* synthetic */ Object a(SerializedLambda serializedLambda) {
        switch (serializedLambda.getImplMethodName()) {
            case "getDesformCode": {
                if (serializedLambda.getImplMethodKind() != 5 || !serializedLambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !serializedLambda.getFunctionalInterfaceMethodName().equals("apply") || !serializedLambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !serializedLambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignForm") || !serializedLambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignForm::getDesformCode;
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

