<script>

  // 上一次向父级提交的高度
  var lastPostHeight = null

  // 每隔 100ms 向父级提交一次高度
  function postHeightChange() {
    var height = document.body.scrollHeight

    // console.log('postHeightChange: height: ', height );
    // console.log('postHeightChange: lastPostHeight: ', lastPostHeight);

    if (height !== lastPostHeight) {
      lastPostHeight = height
      postEvent('height-change', height, messageId)
    }
  }

  /**
   * 定义 VUE_OBJECT 的目的是为了要在 new Vue() 之前处理异步请求的问题
   *
   * jsonData 表单设计JSON
   * editData 表单数据JSON
   */
  var VUE_OBJECT = {
    el: '#app',
    store: store,
    mixins: [DeviceMixins, ExternalMixins],
    data: {
      // 操作动作模式（preview、edit、detail）
      action: "${action}",
      loading: false,
      jsonData: {},
      editData: {},
      desformCode: null,
      desformName: null,
      dialogVisible: false,
      showSaveData: false,
      dataId: null,
      // online数据id
      onlineDataId: null,
      remoteFuncs: {
        funcGetToken: function (resolve) {
          request({
            token: token,
            url: '${base}/desform/getQiniuUploadToken',
            method: 'GET',
            success: function (res) {
              if (res.success) {
                resolve(res.message)
              } else {
                console.error('图片token获取失败：', res)
              }
            }, fail: function (res) {
              console.error('图片token获取失败：' + res)
            }
          })
        },
      },
      // 是否是只读模式
      readOnly: false,
      // 当前登录的用户信息
      userInfo: null,
      // 是否在内部展示对话框
      innerDialog: innerDialog,
      // 是否是关联表单
      isLinkDialog: getQueryParams("isLinkDialog") === "true",
      // 自定义URL是否请求失败
      customURLFail: false,
      // 下一步路由配置
      nextRouteConfig: (${nextRouteConfig!"null"}),
      // 后台翻译数据
      translData: (${translData!"null"}),
      url: {
        base: '${base}',
        add: function (desformCode) {
          if (isExternal) {
            return '${base}/desform/ext/' + desformCode
          } else {
            return '${base}/desform/data/add'
          }
        },
        edit: function (desformCode, dataId) {
          if (isExternal) {
            return '${base}/desform/ext/' + desformCode + '/' + dataId
          } else {
            return '${base}/desform/data/edit'
          }
        },
        online: '${base}/online/cgform/api/crazyForm'
      }
    },
    created: function () {
      if (!this.innerDialog && document.body.style.backgroundColor === 'transparent') {
        document.body.style.backgroundColor = '#FFFFFF'
      }
    },
    mounted: function () {
      this.dialogVisible = true
      postHeightChange()
      setInterval(postHeightChange, 100)
    },
    methods: {
      handleClose: function () {
        postEvent('close', {}, messageId)
      },
      handleSubmit: function (event) {
        if (this.action === 'detail') {
          this.dialogVisible = false
          this.handleClose()
          return
        }
        var _this = this
        var getData = null
        if (this.innerDialog) {
          getData = event.getData
        } else {
          getData = this.$refs.generateForm.getData
        }
        getData().then(function (data) {
          // 数据校验成功，data 为获取的表单数据

          // 新数据和旧数据合并
          var assign = {}
          for (var dataKey in _this.editData) {
            if (_this.editData.hasOwnProperty(dataKey)) {
              assign[dataKey] = _this.editData[dataKey]
            }
          }
          for (var key in data) {
            if (data.hasOwnProperty(key)) {
              assign[key] = data[key]
            }
          }
          var params = {
            json: assign,
            formConfig: _this.jsonData.config,
            onlineForm: _this.jsonData.config.onlineForm,
            onlineDataId: _this.onlineDataId
          }


          // 判断是否在内部保存数据
          if (innerRequest) {
            _this.saveAllData(params)
          } else {
            postEvent('save', params, messageId)
          }
        }).catch(function (e) {
          // 数据校验失败
          console.error('数据校验失败: ', e)
        })
      },
      saveAllData: function (params) {
        var _this = this

        var url = _this.url.add(_this.desformCode), method = 'POST'
        var formData = {
          desformCode: _this.desformCode,
          desformDataJson: JSON.stringify(params.json)
        }
        if (params.onlineForm) {
          formData['onlineFormCode'] = params.onlineForm
          formData['onlineFormDataId'] = params.onlineDataId
        }

        if (_this.action !== 'add' && _this.dataId != null) {
          url = _this.url.edit(_this.desformCode, _this.dataId)
          method = 'PUT'
          formData['id'] = _this.dataId
        }

        _this.loading = true
        try {
          _this.saveStep1(url, method, formData)
        } catch (e) {
          console.error(e)
          _this.showMessage('error', '保存失败，请稍后重试')
          _this.loading = false
        }
      },

      // step.1 如果存在 onlineForm 就首先提交给online表单，获取到 id 后再提交到数据表，再提交到自定义URL
      saveStep1: function (url, method, formData) {
        var _this = this
        request({
          token: token,
          url: url,
          method: method,
          data: formData,
          success: function (res) {
            if (res.success) {
              _this.dataId = res.result.dataId
              _this.customURLFail = res.result.customURLFail
              _this.requestSuccess(_this.dataId, formData)
            } else {
              _this.loading = false
              console.error('保存失败', res)
              _this.showMessage('error', res.message || '保存失败，请稍后重试')
            }
          },
          fail: function (res) {
            _this.loading = false
            console.error('保存失败', res)
            _this.showMessage('error', '保存失败，请稍后重试')
          }
        })
      },
      requestSuccess: function (dataId, formData) {
        this.loading = false
        if (this.customURLFail) {
          this.customURLFail = false
          this.showMessage('warning', '保存成功，但自定义URL请求失败')
        } else if (!this.nextRouteConfig) {
          // 没有下一步路由配置的时候才显示保存成功
          // 不是关联表单才显示保存成功
          if (!this.isLinkDialog) {
            this.showMessage('success', '保存成功！')
          }
        }
        // 数据保存成功，如果当前是在外部链接模式，就将已保存的数据放到 LocalStorage 里
        if (isExternal) {
          this.setExternalSaved(dataId)
          // 外部链接无论如何都跳转到成功页面，而不走路由
          window.location.href = '${base}/desform/ext/success?desformCode=' + this.desformCode + '&dataId=' + dataId
        } else {
          // 如果是关联表单，则不走下一步路由
          if (this.isLinkDialog) {
            this.editData = JSON.parse(formData.desformDataJson)
            return
          }
          // 内部链接需要根据路由配置来决定如何跳转，
          // 如果有路由配置就触发route-jump事件，
          // 没有就触发success事件，
          // 因为route-jump事件已经包含了success事件，无需重复触发。
          this.handleNextRoute(dataId)
        }
      },
      handleNextRoute: function (dataId) {
        var nextRouteConfig = this.nextRouteConfig
        if (nextRouteConfig) {
          // 1. 有路由配置，走路由跳转
          postEvent('route-jump', { nextRouteConfig: nextRouteConfig, dataId: dataId }, messageId)
        } else if (skip) {
          // 2. 没有路由配置，skip = true，跳转到成功页面
          window.location.href = '${base}/desform/success.html'
        } else {
          //update-begin--Author:scott  Date:20220114 for：【JTC-981】工单申请中的设计器表单全屏效果不好，弹出选择人效果也不好（success模式下也传递dataId）---
          // 3. 没有路由配置，skip = false，触发success事件
          postEvent('success', { dataId: dataId }, messageId)
          //update-end--Author:scott  Date:20220114 for：【JTC-981】工单申请中的设计器表单全屏效果不好，弹出选择人效果也不好（success模式下也传递dataId）--
        }
      },

      // 打开关联记录
      onOpenLinkForm: function (payload) {
        // TODO 【关联记录】这里带方法会导致报错，无法打开弹窗
        delete payload.onChange
        postEvent('open-link-form', payload, messageId)
      },

      showMessage: function (type, message) {
        if (innerDialog) {
          postEvent('show-message', { type: type, message: message }, messageId)
        } else {
          this.$message[type](message)
        }
      },
      handleDialogChange: function (val) {
        postEvent('dialog-change', val, messageId)
      }
    }
  }

  /* 实例化VUE之前的前置操作 */

  var requestCount = 0

  // 查询出用户信息
  if (isExternal) {
    VUE_OBJECT.data.userInfo = {}
  } else {
    requestCount++
    request({
      token: token,
      url: '${base}/sys/user/getUserSectionInfoByToken',
      method: 'GET',
      success: function (res) {
        if (res.success) {
          VUE_OBJECT.data.userInfo = res.result
        } else {
          console.error('查询用户信息失败：', res)
        }
        requestCount--
      }, fail: function (res) {
        requestCount--
        console.error('查询用户信息失败：', res)
      }
    })
  }

  /* 将需要用到的数据通过 Freemarker表达式 取出来 */
  var dataSource = {}
  // 设计器构造JSON
  dataSource.jsonData = (${ designForm.desformDesignJson }) || {}
  // 设计器code
  dataSource.desformCode = '${ designForm.desformCode }'
  dataSource.desformName = '${ designForm.desformName }'

  window.desformId = '${ designForm.id }'
  window.desformCode = dataSource.desformCode
  window.desformName = dataSource.desformName

  // 判断是否为只读模式
  // ---- <#if isReadOnly ? exists>
  dataSource.readOnly = true
  // ---- </#if>

  // 判断是否有数据，若有数据则是修改，反之则是新增
  // ---- <#if designFormData ? exists>
  dataSource.dataId = '${ designFormData.id }'
  dataSource.onlineDataId = '${designFormData.onlineFormDataId!}'

  window.desformDataId = dataSource.dataId
  window.onlineDataId = dataSource.onlineDataId

  dataSource.editData = ${ designFormData.desformDataJson }

    /* 判断是否绑定了Online表单，如果绑定了就从online里取数据 */

    // 处理子表数据
    function handleSubTableData(key, cgformSubData) {
      var desformSubData = JSON.parse(decodeURIComponent(dataSource.editData[key]))
      //update-begin--Author:zhangdaihao  Date:20191003 for：实现表单的渲染，直接通过online dataid进行渲染，design_form_data无数据-------------------
      //如果表单设计data数据与物理表数据不一致，则以物理表数据为准
      if (desformSubData.length < cgformSubData.length) {
        desformSubData = cgformSubData
      }
      //update-end--Author:zhangdaihao  Date:20191003 for：实现表单的渲染，直接通过online dataid进行渲染，design_form_data无数据-------------------
      for (var i = 0; i < desformSubData.length; i++) {
        objectAssign(desformSubData[i], cgformSubData[i])
        desformSubData[i].id = undefined
      }
      dataSource.editData[key] = encodeURIComponent(JSON.stringify(desformSubData))
    }

  // 查询主表
  var codeFromJson = (dataSource.jsonData.config || {}).onlineForm
  var codeFromTable = '${ designForm.cgformCode! }'
  var tableName = (codeFromJson || codeFromTable)
  if (tableName) {
    // 从online表里查询数据，并和现有的合并
    requestCount++
    request({
      token: token,
      url: '${base}/online/cgform/api/form/table_name/' + tableName + '/' + dataSource.onlineDataId,
      method: 'GET',
      success: function (res) {
        if (res.success) {
          objectAssign(dataSource.editData, res.result)
          dataSource.editData.id = undefined

          // 判断是否存有子表
          for (var key in dataSource.editData) {
            if (dataSource.editData.hasOwnProperty(key)) {
              // var subTable = dataSource.editData[key];
              var split = key.split('sub-table-design_')
              if (split.length === 2 && split[0] === '') {
                var subTableName = split[1]
                // 查询子表（查询主表时已经返回了子表的数据，可以直接取出来处理）
                handleSubTableData(key, dataSource.editData[subTableName])
              }
            }
          }
        } else {
          console.error(res)
        }
        requestCount--
      }, fail: function (res) {
        requestCount--
        console.error(res)
      }
    })
  }
  // ---- </#if>
  // 上一个路由带过来的数据
  window.routeData = (${routeData!'null'})
  dataSource.editData = objectAssign(dataSource.editData||{}, window.routeData||{})

  // 根据用户设定的边距生成style
  var dialogOptions = dataSource.jsonData.config.dialogOptions
  if (dialogOptions) {
    var pd = dialogOptions.padding
    VUE_OBJECT.data['bodyStyle'] = {
      padding: pd.top + 'px ' + pd.right + 'px ' + pd.bottom + 'px ' + pd.left + 'px'
    }
  } else {
    VUE_OBJECT.data['bodyStyle'] = { padding: '25px 25px 30px 25px' }
  }

  /* 表单字段权限 */
  <#if authUserInfoJson ??>
  window['__authUserInfo'] =
  ${authUserInfoJson}
  </#if>

  <#if authInfoJson ??>
  var authInfo = (${authInfoJson} || []
  )
  var authsMap = {}
  for (var i = 0; i < authInfo.length; i++) {
    var auth = authInfo[i], temp = authsMap[auth.authComKey]
    if (temp instanceof Array) {
      temp.push(auth)
    } else {
      authsMap[auth.authComKey] = [auth]
    }
  }
  window['__authsMap'] = authsMap
  </#if>

  // console.log('dataSource: ', JSON.parse(JSON.stringify(dataSource)))

  // 检测所有的请求是否都已结束
  var timer = setInterval(function () {
    if (requestCount <= 0) {
      clearInterval(timer)
      //  合并数据
      objectAssign(VUE_OBJECT.data, dataSource)
      // ** 等待所有的前置请求都完成之后才进行实例化VUE操作
      new Vue(VUE_OBJECT)
    }
  }, 10)
</script>