/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.extbpm.listener.global;

import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.modules.bpm.service.ActivitiService;
import org.jeecg.modules.extbpm.listener.global.AutoCompleteCmd;
import org.jeecg.modules.extbpm.listener.global.FlowEventHandler;
import org.jeecg.modules.extbpm.process.entity.ExtActBpmLog;
import org.jeecg.modules.extbpm.process.service.IExtActBpmLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="taskCreatedEventListener")
public class TaskCreatedEventListener
implements FlowEventHandler {
    @Autowired
    private IExtActBpmLogService extActBpmLogService;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    private ActivitiService activitiService;
    @Lazy
    @Autowired
    private ISysBaseAPI sysBaseAPI;

    @Override
    public void handle(ActivitiEvent activitiEvent) {
        if (!(activitiEvent instanceof ActivitiEntityEventImpl)) {
            return;
        }
        ActivitiEntityEventImpl activitiEntityEventImpl = (ActivitiEntityEventImpl)activitiEvent;
        Object object = activitiEntityEventImpl.getEntity();
        if (!(object instanceof TaskEntity)) {
            return;
        }
        TaskEntity taskEntity = (TaskEntity)object;
        try {
            this.onCreate((DelegateTask)taskEntity);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onCreate(DelegateTask delegateTask) throws Exception {
        PvmActivity pvmActivity = this.findFirstActivity(delegateTask.getProcessDefinitionId());
        if (!pvmActivity.getId().equals(delegateTask.getExecution().getCurrentActivityId())) {
            return;
        }
        List<Map<String, Object>> list = this.activitiService.getHistTaskNodeList(delegateTask.getProcessInstanceId());
        if (list != null && list.size() > 0) {
            return;
        }
        new AutoCompleteCmd(delegateTask.getId(), delegateTask.getVariables(), "\u53d1\u8d77\u6d41\u7a0b").execute(Context.getCommandContext());
        String string = JwtUtil.getUserNameByToken((HttpServletRequest)SpringContextUtils.getHttpServletRequest());
        LoginUser loginUser = this.sysBaseAPI.getUserByName(string);
        String string2 = delegateTask.getProcessInstanceId();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(string2).singleResult();
        ExtActBpmLog extActBpmLog = new ExtActBpmLog();
        if (processInstance != null) {
            extActBpmLog.setBusinessKey(processInstance.getBusinessKey());
            extActBpmLog.setProcName(processInstance.getName());
        }
        extActBpmLog.setOpTime(new Date());
        extActBpmLog.setOpUserId(string);
        if (loginUser != null) {
            extActBpmLog.setOpUserName(loginUser.getRealname());
        }
        extActBpmLog.setProcInstId(string2);
        extActBpmLog.setRemarks("\u53d1\u8d77\u6d41\u7a0b");
        extActBpmLog.setTaskDefKey(delegateTask.getTaskDefinitionKey());
        extActBpmLog.setTaskId(delegateTask.getId());
        extActBpmLog.setTaskName(delegateTask.getName());
        this.extActBpmLogService.save(extActBpmLog);
    }

    public RepositoryService getRepositoryService() {
        return (RepositoryService)SpringContextUtils.getBean(RepositoryService.class);
    }

    public PvmActivity findFirstActivity(String processDefinitionId) {
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.getRepositoryService()).getDeployedProcessDefinition(processDefinitionId);
        ActivityImpl activityImpl = processDefinitionEntity.getInitial();
        PvmTransition pvmTransition = (PvmTransition)activityImpl.getOutgoingTransitions().get(0);
        PvmActivity pvmActivity = pvmTransition.getDestination();
        if (!"userTask".equals(pvmActivity.getProperty("type"))) {
            return null;
        }
        return pvmActivity;
    }
}

